# IRAF script -- _obshedit.cl
#
## this is a record processing script which is a HIDDEN task, user cannot
#   use it in the front end.
#  function: to put the essential information during the runs into the headers
#
# progrmmer : sjchan (December 1997)
#

procedure _obshedit(frame_in,filename2,rootname2,object2,imagetype2,
                    ra2,dec2,eqoch2,
                    tot_loop2, loopnum_st2,loopnum_end2,filter2,exprrr2,
                    utstart2, ststart2, airmass2, readout2, readrate2,
                    status2, weather2,date2)

string frame_in {"", prompt="Input image name", mode="ql"}
string filename2 {"", prompt="Input name of loop-1 file in a given loop", mode="ql"}
string rootname2 {"",prompt="Input rootname of a set of files", mode="ql"}
string object2 {"obj_title",prompt="Input the name of current object",mode="ql"}
string imagetype2{"target", prompt="Input object type (target| dark|flat)", mode="ql"}
string ra2  {"03:17:14.50", prompt="RA taken from the target list; hh:mm:ss.ss", mode="ql"}
string dec2 {"15:21:00.00", prompt="DEC taken from the target list; Sdd:mm:ss.ss; S=-", mode="ql"}
string eqoch2 {"1950.0", prompt="Eqoch of the coordinates in CAT-RA, CAT-DEC; B1950.0|J2000.0", mode="ql"}
string tot_loop2 {"10",prompt="Effective otal number of this loop (_totloop_RRR-1)", mode="ql"}
string loopnum_st2 {"1", prompt="Starting loop/run  number in a given loop", mode="ql"}
string loopnum_end2 {"10", prompt="End loop/run number in a given loop", mode="ql"}
string filter2   {"J", prompt="Filter", mode="ql"}
string exprrr2 {"5.0", prompt="Length of exposure time per RRR (sec)", mode="ql"}
string utstart2 {"01:10:10.0", prompt="UT at exposure start; hh:mm:ss.s", mode="ql"}
string ststart2 {"00:00:00.0", prompt="Local sideral time at exposure start; hh:mm:ss.s", mode="ql"}
string airmass2  {"1.00", prompt="Airmass at start x.xx", mode="ql"}
string readout2 {"normal", prompt="Detector readout mode", mode="ql"}
string readrate2 {"387", prompt="Detector readout rate", mode="ql"}
string status2 {"concluded", prompt="Termination mode (concluded, aborted, error)", mode="ql"}
string weather2 {"excellent", prompt="Weather condition (excellent,good,moderate,cloud)", mode="ql"}
string date2 {"09/12/97", prompt="Date of observation", mode="ql"}

begin
      # Local variable declarations
        string framein       # input image name
        string filename1    # name of loop-1 file in a given loop
        string rname1       # rootname of input files
        string title        # the title of this object
        string imgtype      # image type
        string ra1          # RA of the object that the telescope is tracking
        string dec1         # DEC of the object that  the telescope is tracking
        string eqoch1     # eqoch of the coordinates in RA, DEC
        string totloop      # total number of a loop
        string loopst       # Starting loop/run  number in a given loop
        string loopend      # end loop/run number in a given loop
        string filter1       # filter
        string exprrr1      # Length of exposure time per RRR (sec)
        string utstart1     # UT at exposure start
        string ststart1     # local sideral time start
        string airmass1     # airmass at start
        string readout1     # detector readout mode
        string readrate1    # detector readout rate (KHz)
        string status1      # status mode of observation
        string weather1     # weather condition
        string date1        # date of observation
        string tmpinfo    # dummy file to hold the nescessary info for ASTHEDIT
        string colnm      # column names in table file for ASTHEDIT
        string obsheditlog # logfile
        string commandin1
        real   exptime     # length of exposure time per loop (sec)
        real   rtotloop    # total loopnum per a given loop in real

      # Get the reset of the parameters
        framein = frame_in
        filename1 = filename2
        rname1 = rootname2
        title = object2     
        imgtype = imagetype2
        ra1 = ra2
        dec1 = dec2
        eqoch1 = eqoch2
        totloop = tot_loop2
        loopst  = loopnum_st2
        loopend = loopnum_end2
        filter1 = filter2
        exprrr1 = exprrr2
        utstart1 = utstart2
        ststart1 = ststart2
        airmass1 = airmass2
        readout1 = readout2
        readrate1 = readrate2
        status1 = status2
        weather1 = weather2
        date1 = date2
        tmpinfo = "dummy.inf"
        colnm = "date utstart cat_ra cat_dec cat_epoc itime"
        obsheditlog = "obshedit.log"
        commandin1 = "cqlook$obshedit.cmd"
        exptime = 10.0
        rtotloop = real(totloop)
        exptime = (rtotloop) * real(exprrr1)

      # Check the existence of the file
        if (access(tmpinfo))
           delete(tmpinfo, ver-, >& "dev$null")

        if (access(obsheditlog))
           delete(obsheditlog, ver-, >& "dev$null")

       # Input the default information to the headers
        hedit(framein,field="i_title",value=title,add-,del-,ver-,update+,
                 show-)
        hedit(framein,field="DATE-OBS",value=date1,add+,del-,ver-,update+,
                 show-) 
        hedit(framein,field="filename",value=filename1, add+,del-,ver-,update+,
                 show-)     
        hedit(framein,field="rootname",value=rname1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="imagetype",value=imgtype,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="CAT-RA",value=ra1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="CAT-DEC",value=dec1,add+,del-,ver-,update+,
               show-) 
        hedit(framein,field="CAT-EPOCH",value=eqoch1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="FILTER",value=filter1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="exprrr",value=exprrr1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="exptime",value=exptime,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="UTSTART",value=utstart1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="STSTART",value=ststart1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="AIRMASS",value=airmass1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="readout",value=readout1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="readrate",value=readrate1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="STATUS",value=status1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="weather",value=weather1,add+,del-,ver-,update+,
                 show-)
        hedit(framein,field="loop",value=rtotloop,add+,del-,ver-,update+,
                 show-)
   
        # make a tempoary table for asthedit 

        #  utstart1, date1, ra1, dec1, eqoch1
      
        print(date1," ",utstart1," ",ra1," ",dec1," ",eqoch1," ",exptime, >> tmpinfo)
        #colnm = "date utstart cat_ra cat_dec cat_epoc itime"

       # calcuate the current epoch, ra, dec at the current epoch, airmass
       # and effective airmass
       # Not update header because ASTHEDIT change the location of the keyword
        unlearn asthedit
        asthedit(framein, commandin1, table=tmpinfo, colnames=colnm, 
                ver+, >> obsheditlog)

        

end

