# IRAF script -- cmkllistint1.cl
#	
#     this is a sub file management task which is ALMOST same as
#       HIDDEN task _mkllist
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to divide a list of finput iles into few (total_folds) sublists
#                 of files which will be in a file (inlist)
#              to make few lists of files which will be in a file (outlist)
#      different: _mkllist.cl -- ic = 0
#                 cmkllist.cl -- ic == -1
#                 print(ilist, >> foldlist) if (ic > 0)
#                 (try to fit the files which were reset corrected in the PC.
#     ***  NOTICE:  cmkllistint1.cl -- only for 1st INT run data *****
#                  (The filename is NOT unique, no running number)
#
# programmer: sjchan 
#    history: nov97  -- created (_mkllist.cl)
#             dec97  -- modified at INT,  ic = 0 --> ic = -1
#             (try to fit the files which were coadded in the PC.
#             24feb98 -- try to produce "make sense" file name.
#                        add a required parameter "totquad" to check number of
#                       files

procedure cmkllistint1(file_in, tot_fold, fold_list, out_list, totquad, runno)

string	file_in   {"",prompt="List of Input images",mode="ql"}
int     tot_fold  {min=1, prompt="total number of folds for a fixed-pos obs",mode="ql"}
string  fold_list {"", prompt="a file containing fold input filenames",mode="ql"}
string  out_list {"", prompt="a file containing final fold output image names", mode="ql"}
int  totquad {16, prompt="Total number of quadrants", mode="ql"}
int  runno   {prompt="The running number of this set of data", mode="ql"}
string  check   {"G", prompt= "Check file flag (G/B)"}

struct  *filist


begin
        string  filein      # input file list
        int     totfold     # total number of folds for a fixed-pos observation
        string  foldlist    # a file containing fold input fileanmes 
        string  outlist     # a file containing fold output filenames
        string  ilist       # list of input files in #th fold
        string  ilisto      # a prefix for ilist file
        string  olist       # list of output files in #th fold
        string  olisto      # a prefix for olist file
        string  framein     # input frame
        string  framein2    # input frame (with FITS extension)
        string  temphead    # the prefix of an image name
        string  temptail    # the subfix(extension) of an image name
        int     icounter    # counter
        int     foldseq     # total sequence number in one fold
        int     ic, ic2     # dummy counters
        int     len         # the total length of an input filename
        int     lentemp     # the location of the last '_" in the filename
        int     lentemp2    # the location of the last "." in the filename
        int     totquad1    # total number of quadrants
        string  check1      # check file flag
        string  ss1         # dummy variable
        string  sic2        # quadrant number in integer
        int     runno1      # running number of this set of data
        string  srunno      # the running number in string
        int     k

      #  Get the rest of the parameters

        filein=file_in
        totfold=tot_fold
        foldlist=fold_list
        outlist = out_list
        totquad1 = totquad
        runno1 = runno
        check1 = check
        ilisto = "infd"
        olisto = "outfd"
        temphead = ""
        temptail = ""

        _sdigit(runno1, 4)
        srunno = _sdigit.value
        ilisto = "r"//srunno//"_"//ilisto
        olisto = "r"//srunno//"_"//olisto

      # Check existence of output files
        if (access(foldlist))
          delete(foldlist, ver-, >& "dev$null")
        if (access(outlist))
          delete(outlist, ver-, >& "dev$null")

        # find out the total number of input files in the list
        count(filein) | scan(ss1)
        icounter = int(ss1)

        # find out the total seq number in one fold
        foldseq = icounter/totfold      # total quads
        if (foldseq != totquad1)
          {
            print("File IMCOMPLETE!!")
            check1 = "B"
            check = check1
            bye
          }
        else
          check1 = "G"

        filist = ""; filist = filein   # open the file
       # make foldlist files

         ic = -1
         for (k=1; k <= icounter; k += foldseq)
          {  
            ic += 1
            ilist = ilisto//str(ic) # make a fold list input filenames
            olist = olisto//str(ic) # make a fold list output filenames
            if (ic > 0) {
              print (ilist, >> foldlist)

              if (ic < totfold)
                 print(olist, >> outlist)
            }
            if (access(ilist))
               delete(ilist, ver-, >& "dev$null")
            if (access(olist))
               delete(olist, ver-, >& "dev$null")

               ic2 = 0
               while (fscan(filist,framein2) !=EOF)
                {
                  ic2 += 1
                  
         # check whether the input frame with FITS extension
                  _checkfit(framein2)
                  framein = _checkfit.framext # nov the file with FITS extension
                  print(framein, >> ilist)   # make an input fold list

        # find out the location of the last "_" in the given filename
                  len = strlen(framein)
                  
                  _locate(framein, "_")
                  lentemp = _locate.value
  
        # make the prehead from char#1 to char#(lentemp)
                     temphead = substr(framein, 1, lentemp)

        # find out the location of the last "." in the given filename
                   _locate(framein, ".")
                   lentemp2 = _locate.value 

        # make the subhead from char#lentemp2 to char#(len)
                     temptail = substr(framein, lentemp2, len)

        # make an output fold list
                 _sdigit(ic2,2)
                 sic2 = _sdigit.value
                 print(temphead//str(ic)//"p"//sic2//temptail, >> olist)

         
        # check whether a "complete" is finished
                   if (ic2 == foldseq)
                         break     # leave the fold to create another file
                }  # this brace is from while block

          }  # this brace is from for outer block i
          check = check1   # if check1 = "G"

          filist = ""   # close the file

end

