# IRAF script -- cmkqlist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to make a list of quads files from a list of fold files
#
# programmer: sjchan
#     history: nov97 -- created (cmkqlist.cl)
#              6feb98 -- use cirrename.cl more effectively
#                     (i.e: eliminate the chance to rename unnecessary files)
#              10feb98 -- noticed that ttranpose cannot transpose 1 column,
#                           n rows into n columns, 1 row.
#                         cheat ttranspose if we need to transpose 1xn table
#                          make a temporary file as 2xn table - after 
#                          ttranspose does its job - change back that file
#                          into 1xn table
#

procedure cmkqlist(fold_list, quad_list, pre_head)

string  fold_list {"", prompt="an input file containing fold input filenames",mode="ql"}
string  quad_list {"quadlist.in", prompt="Output list of list of quad-images", mode="ql"}
string  pre_head {"quad_", prompt="Prefix of each quad-image files", mode="ql"}

struct  *filist

begin
        string  foldlist          # a file containing fold input fileanmes 
        string  quadlist          # a file containing fold output filenames
        string  filein1, filein2  # dummy variables (temporary files)
        int     foldseqno         # total sequenc number in a fold
        string  inquad            # prefix of each quad"
        string  temp1             # dummy variable
        string  ss1               # dummy variable (tot_fold in string)
        int     foldno            # tot_fold in integer
        string  tfoldlist         # temporary foldlist 
        string  ffold             # dummy variable
        string  ss2               # dummy variable (the starting line number
                                    # the parameter of fields, lines
        string  tfl               # temporary file
        string  s1
        int     i, j  

      #  Get the rest of the parameters

        foldlist = fold_list
        quadlist = quad_list
        inquad = pre_head
        filein1 = mktemp("quad1")
        filein2 = mktemp("quad2")


       if (access(quadlist))
               delete(quadlist, ver-, >& "dev$null")
 
     # join the lines in foldlist and store them in filein1
         tfoldlist = mktemp("tfold")
         count(foldlist) | scan(ss1)
         foldno = int(ss1)
         if (foldno == 1) 
           {  # ttranspose cannot transpose 1xn table into nx1 table,
              # need to produce a false table with 2xn
              filist = ""; filist = foldlist
              while(fscan(filist, ffold) !=EOF)
                { 
                   for (i=1; i<=2; i += 1)
                     print(ffold, >> tfoldlist)

                }  # this brace is from while block (filist, ffold)
              filist = ""   # close the file
           }  # this brace is from if block (foldno == 1)
         else
              copy (foldlist, tfoldlist, ver-)

         unlearn joinline
         joinline("@"//tfoldlist, output= filein1, maxchars = 2000)
         delete(tfoldlist, ver-, >& "dev$null")  

     #  find out the total sequence number in one fold
          count(filein1) | scan(s1)
          foldseqno = int(s1)

     # transpose the table/file so that input rows become output columns
     #  and input columns become output rows
        ttranspose(filein1, filein2, "t", ver-)

     # break this filein2 (multicolumns) into 'foldseqno' single column files
     #  whose root is "inquad" if foldseqno > 1

        column(filein2, foldseqno, outroot = inquad)
        
     #  take away the duplicate row (when foldno = 1)
        if (foldno == 1)
           ss2 = "2-"
        else if (foldno > 1)
           ss2 = "1-"

        for (j=1; j <= foldseqno; j += 1)
           {
             tfl = inquad//str(j)
             if (access(tfl//".in"))
                delete(tfl//".in", ver-, >& "dev$null")

             unlearn fields
             fields(tfl, "1", lines=ss2, >> tfl//".in") 
             delete(tfl, ver-, >& "dev$null")

           # make a list of these quad-lists
             print(tfl//".in", >> quadlist)               
           }  # this brace is from for block (j=1, foldseqno)
     

     # sort the list to increasing order
       _finsort(quadlist)

     # cleaning uup
       delete(filein1, ver-, >& "dev$null")
       delete(filein2, ver-, >& "dev$null")     


end

