# IRAF script -- cirdiffdisp.cl
#	
#   functions:  to take a quick look at a field thru difference of 2 setsof
#                images
#              option: given a single pair set of images (m=1,2,3, ...)
#                        to display m-diff-images in one buffer
#
# programmer: sjchan (nov 97)
#     history: nov 97 -- created         
#              11mar98 -- add an option: given a single pair set of 
#                          images to display m-diff-images in one buffer
#        
#

procedure cirdiffdisp(imglist1, imglist2, stat, answer)

string  imglist1 {"", prompt="List1 of (@ or *.fits) input images",mode="ql"}
string  imglist2 {"", prompt="List2 of (@ or *.fits) input images", mode="ql"}
bool  stat {yes, prompt="Display image statistics", mode="ql"}
bool  answer {yes, prompt=">>> Next diff-image?", mode="ql"}

struct *flist1, *flist2

begin
        string ftmpi1      #i input string containing list1 of images
        string ftmpi2      #i input string containing list2 of images
        string ifile1      #i final version of the input list1
        string ifile2      #i final version of the input list2
        string framein1    #i image name from the input list1
        string framein2    #i image name from the input list2
        string ofile       #i dummp variables (never really use them)
        string ind         #  indicator (dummy variable)
        string frameout    # Output image 
        bool   sstat       # prompt display image statistics 
        int    frameno     # display frame buffer
        int    icount      # dummy counter
        int    naxis       # length of the axis
        real   dmag        # the display window magnification

         cache imgets     # need this action due to a bug in imgets

      #  Get the rest of the parameters

        ftmpi1 = imglist1
        ftmpi2 = imglist2
        sstat  = stat
        frameno = 1
        ind = "DI"  # dummy definition
        ifile1 = mktemp("cddif1")
        ifile2 = mktemp("cddif2")
        ofile  = mktemp("cddof")  # dummy variable
        frameout = "diff.fits"
        dmag  = 1.0  # display window magnification (naxis = 512)

      # Check the existence of the files
         if (access(frameout))
              imdelete(frameout, ver-, >& "dev$null")
         if (access(ifile1))
              delete(ifile1, ver-, >& "dev$null")
         if (access(ifile2))
             delete(ifile2, ver-, >& "dev$null")   
         if (access(ofile))
             delete(ofile, ver-, >& "dev$null")

      # Find out the suitable input option
         # for input list1
         _finout(ftmpi1, ind, ifile1, ofile) 
    
         # for input list2
          if (access(ofile))
            delete(ofile, ver-, >& "dev$null")
      
          _finout(ftmpi2, ind, ifile2, ofile)
 

       # Read the file ifile1, ifile2 containing the names of files
          icount = 0
          flist1 = ""; flist1 = ifile1
          flist2 = ""; flist2 = ifile2
          while( (fscan(flist1, framein1) != EOF) &&
                    (fscan(flist2, framein2) !=EOF) )
            {

               if (access(frameout))
                   imdelete(frameout, ver-, >& "dev$null")    

             # Obtaining the difference   
               unlearn imarith
               imarith(operand1=framein1, op="-", operand2=framein2,
                  result=frameout,  pixtype="real", calctype="real",
                  verbose=yes)  

             if (sstat)
              {
                 print("")
                 print("Diff-image statistic:")
                 unlearn gstatistic
                 gstatistic(frameout, fields="doall")
               }  

             # Display the different image
              icount += 1
               if (icount == 1)
                 {  # find out the size of the input image
                   imgets(framein1, param ="i_naxis1")
                   naxis = int(imgets.value)
                   if (naxis == 1024)
                       dmag = 0.5
                 }

             print("")
             print("Diff-Image No: ", icount)
             unlearn display
             display (frameout, frameno, xmag=dmag, ymag=dmag)
             print("")
             print("================================================")
      
             if (!answer)
                goto lab

        }   # this brace is from while block (flist1=ifile1, flist2=ifile2)

           # cleaning up
           
           lab:
           flist1 = ""; flist2=""   #close the files
           delete(ifile1, ver-, >& "dev$null")
           delete(ifile2, ver-, >& "dev$null")
           delete(ofile, ver-, >& "dev$null")

end

