# IRAF script -- cndrproc
#	
#   function:  to do the reduction up to sky-subtraction given the prefix
#                and a list of running numbers
#              (this is a proto-type)
#              
#      basic tasks: _mkrnoifl -- _mkilist -- cmkimg (-- cstripe) --
#                   cassquad (-- chiptrans) -- cmkqobj --
#                   cdossky (cmkqsky -- cmkqlist -- csubqsky)
#      abb: ir  - input requred; ih -- input hidden; ip -- input by program
#           o-i - output --> input; of - final output; oh -- output hidden
#                                   ot - temporaray output
#
# programmer: sjchan 
#    history: 17march98 (create)
#             4june98 -- modified (to process any number of chip-images
#             5june98 -- modified (to process quadrant-images)
#                        -- add a reuqired parameter: standard
#             8june98 -- modified (able to select the single chip/quad files)
#                        -- add a hidden parameter: quadnos
#             11june98 -- modified (to add to use a non-scaling quads option)
#                         -- (hidden parameter: doscaleq == yes, default)
#             26june98 -- modified (to add an option for the user to supply
#                            a directory where the raw data is kept.
#                           -- (hidden parameter: datapath = current, default)
#                           -- change "prefix" from a required parameter into
#                                a hidden parameter
#             29june98 -- modified (make a stop option after cmkimg and
#                           cmkchip)
#
#             2july98 -- add an option to perform the dark correction
#             3july98 -- add an option to perform the flat-fielding correction

procedure cndrproc(rnorange, tfold, tquad, tndr, range1, range2, skyfl, presky, standard)

string rnorange  {"rno1-rno2,rno3", prompt="Range of runno (delimiters: commas and/or dashes)", mode="ql"}
int  tfold       {1, prompt="Total number of folds", mode="ql"}
int  tquad       {16, prompt="Total number of quadrants", mode="ql"}
int  tndr        {6, prompt="Total number of NDR per fold", mode="ql"}
int  range1      {2, prompt="Lower value of RC pair", mode="ql"}
int  range2      {5, prompt="Upper value of RC pair", mode="ql"}
string skyfl  {"", prompt="File containing names of output skyframes (skyframe.in/none)", mode="ql"}
string presky    {"sky_c", prompt="Prefix of output sky frames (subsky case only)", mode="ql"}
bool  standard   {no, prompt="Process standard star (quadrant-images)", mode="ql"}
string prefiximg {"", prompt="Prefix of input images"}
string datapath  {"current", prompt="path name of raw data location"}
string  stripe   {"NO", prompt="Destriping correction option (MB/MR/MC/B/R/C/NO)"}
bool stoprc      {no, prompt="Stop after RC correction"}
string transpose {"WHT", prompt="Transpose;North-top seen from Ximtool (WHT/INT/none)"}
bool  doscaleq   {yes, prompt="Scaling the quadrants?"}
string quadnos   {"all", prompt="Which quadant number(s) (all; c1/../c4; q1/../q16) to be selected"}
bool  stopass    {no, prompt="Stop after assembling quadrant-images to chip-images"}
bool darkcorr    {yes, prompt="Perform dark correction?"}
bool   scalfac   {yes, prompt="Using scaled darks (yes: normalized darks)?"}
string darklist  {"", prompt="List of darks"}
bool flatcorr    {yes, prompt="Perform flat-fielding correction?"}
string flatlist  {"", prompt="List of flats"}
string obj_stfold {"1", prompt="Starting fold for coadding object frames"}
string sky_stfold {"1", prompt="Starting fold for making sky frames"}
bool delfl    {yes, prompt="Delete intermediate output images"}
bool delskyfl {yes, prompt="Delete sky-subtracted images"}

struct *rnolist
struct *tmplist, *tmplist2

begin

  # Declare local parameters
    # basic local parameters for cndrproc
       string rnorange1       #ir  range of running number
       string rnofile1        #ir  list of input running numbers
       bool   delfl1          #ih   delete the intermediate output images
       bool   delskyfl1       #ih   delete the sky-subtracted images
       string cndrproclog    #fo   logfile of cndrproc
       string templog         #ot   temporary logfile from each task
       bool   standard1       #ir   process standard star image (quad-images)
       bool   stoprc1         #ih   stop after RC correction
       bool   stopass1        #ih   stop after assembling the quadrants into
                              #      chips
  
    #basic local paramters for _mkilist
       string prefiximg1      #ih  prefix of raw data filename
       string runno1          #ir  running number for the list, runnofile1
       int    tfold1          #ir  total number of folds
       int    tquad1          #ir  total number of quadrants
       string quadnos1        #ir  chipno/quadno to be selected 
       string imglist1        #o-i  name of the file containing ndr raw list
       string dcase1          #i read-out mode  (NDR)
       string chk1            #oh  check file flag (G/B)
       string datapath1       #ih  path of data directory
 
    #basic local parameters for cmkimg
       int     tndr1        #ir   total number of NDR per fold
       int     rc1, rc2     #ir   RC pair (range1, range2)
       string  stripe1      #ih   destriping correction option
       bool    sort1        #ip   ask sort the input list (yes)
       bool    head1        #ip   ask for getting information from header (no)
       string  pixty1       #ip   pixtype of output images from cmkimg (real)
       string  calcty1      #ip   calculating type for IMARITH in cmkimg( real)
       string  rcflout1  #o-i name of file containing output images from cmkimg
                         # rcflout1 is a list of fold lists of RC pairs 

    #basic local parameters for cmkchip
       bool   doscaleq1     #ih  ask scaling quads (default: yes)
       string transpose1    #ih  ask transpose image (north-top; WHT/none)
       string cassfile1     #o-i file containing output images from cmkchip
                                 # non-transpose or transpose option
       string cobjin        #o-i file containing output foldlist of cassfile1
                            #o-i Or: file containing output foldlist of 
                              # chiptranfile1

   #basic local parameters for csubqdark
       bool    darkcorr1    #i  ask dark correction (default: yes)
       bool    scalfac1     #i  using scaled darks if darkframe are normalized
       string  darklist1    #i  list of the darks  
       string  etimechk     #o  indicator of keyword exptime
       string  tmpout       #o-i  file containing output foldlist of cobjin
        
    #basic local parameters for cmkqobj
       string objfile1      #o-i file containing output coadded object images
                                   # from cmkqobj
       string objstfold1    #ih  the start fold number for combination
       string endfold1      #ip  the end fold number for combination
                                   # need to find out from the program 
                                   # count objfile
       string osetfile1     #ip  offset file (none)

   #basic local parameters for cdossky
       string skyfile1      #o-i/of  name of file containing output skyframes
       string skylist       #ip  name of file containing list of "cassfile1"
                                #  which is for making skyframes
       string presky1       #ir     prefix of output sky frames
       string skystfold1    #ih     the starting fold number for making sky
       string objflist     #ot  file containing list of dithering lists of
                             #coadded images

   #basic local parameters for cqflatcor
       #string tmpout -- use again -- #o-i output filename (list of lists)
       #                       containing substracted sky images
       bool flatcorr1      #ih  prompt flat-fielding correction (default: yes)
       string flatlist1    #ih  list of flats 

   #temporary local parameter in cndrproc
       string ss1, s1
       string tmpfile, tmpfile2   # dummy variable
       int    tchip1              # total number of chips


  # Get the rest of parameters 
       rnorange1  = rnorange   # required
       tfold1     = tfold
       tquad1     = tquad
       tndr1      = tndr
       rc1        = range1 
       rc2        = range2 
       skyfile1   = skyfl
       presky1    = presky 
       standard1  = standard
       prefiximg1 = prefiximg  # hidden
       datapath1  = datapath  
       stripe1    = stripe    
       transpose1 = transpose
       doscaleq1  = doscaleq
       quadnos1   = quadnos
       darkcorr1  = darkcorr
       darklist1   = darklist
       scalfac1   = scalfac
       flatcorr1  = flatcorr
       flatlist1  = flatlist
       objstfold1 = obj_stfold
       skystfold1 = sky_stfold
       delfl1     = delfl
       delskyfl1  = delskyfl

  # Define the local or temporary parameters
       cndrproc = "cndrproc.log"
       templog = "temp.log"
       dcase1 = "NDR"     # for _mkilist
       chk1 = ""
       imglist1 = "r0000.in"   # default (will be changed by running no)
       sort1 = yes; head1 = yes      # for cmkimg
       pixty1 = "real"; calcty1 = "real"
       rcflout1 = "rc_"//imglist1   # (wil be changed by running no)
       cobjin = "cobjin"
       tmpout = "tmpout"
       etimechk = "G"  #for csubqdark
       osetfile1 = "none"      # for cmkqobj
       endfold1 = str(tfold1)
       skylist = prefiximg1//"_dithersky.in"   # for cdossky

       if (!standard1)
         {
           if (mod(tquad1,4) == 0) 
             tchip1 = tquad1/4
           else
             tchip1 = int(tquad1/4) + 1
          } # this brace is from if block (standard1 == no)
       else 
           tchip1 = tquad1   # processing quad-images only (standard1 == yes)
       
       objflist = prefiximg1//"_ditherobj.in"   # for cdossky 
                                       # subsky (list of dithering list)


       cache imgets     # need this action due to a bug in imgets
       if (access(cndrproclog))
           delete(cndrproclog, ver-, >& "dev$null")
       if (access(skylist))

           delete(skylist, ver-, >& "dev$null")
       if (access(objflist))
           delete(objflist, ver-, >& "dev$null")


 # Check the existence of calibration files (such dark frames, flat frames)
        print("")
        print("========= Checking the existence of calibration files =======")
        print("")
          chk1 = "G"
          unlearn _chkcalib
          _chkcalib(darkcorr1, darklist1)
          chk1 = _chkcalib.index
          if (chk1 == "B")
             bye     # exit the program 

          chk1 = "G"
          unlearn _chkcalib
          _chkcalib(flatcorr1, flatlist1)
          chk1 = _chkcalib.index
          if (chk1 == "B")
             bye    #exit the program

 # Make a running number list from given range of running number

           rnofile1 = prefiximg1//"_rno.in"
           if (access(rnofile1))
               delete(rnofile1, ver-, >& "dev$null")

           unlearn _mkrnoifl
           _mkrnoifl(rnorange1, rnofile1)      


 # Make a fold to start preprocessing images
      rnolist = ""; rnolist = rnofile1      
      while( fscan(rnolist, runno1) != EOF)
       {
          flpr # need to free the process memory
          print("")
          print("", >> cndrproclog)
          print("Running number: ", runno1)
          print("Running number: ", runno1, >> cndrproclog)
          print("")
          print("=============Making the input list============")
          print("")
          imglist1 = "r"//str(runno1)//".in"
          print("Input list: ", imglist1)
          if (access(imglist1))
             delete(imglist1, ver-, >& "dev$null")

         # Make an input list from runno and prefix of raw data filename
         unlearn _mkilist
         _mkilist(datapath1, prefiximg1, runno1, dcase1, tfold1, tquad1, tndr1, imglist1, quadnos1)
 
         # check the list is incomplete, exit the program
           chk1 = _mkilist.chk
           if (chk1 == "B")
             {
               rnolist = ""
               bye
             }

   # Obtain the RC pair images -- run cmkimg
           print("")
           print("", >> cndrproclog)
           print("===========Producing RC pairs =============")
           print("===========Producing RC pairs =============", >> cndrproclog)
           print("")
           if (stripe != "NO")
               rcflout1 = "nrc_"//imglist1
           else 
               rcflout1 = "rc_"//imglist1

           templog = "cmkimg.log"
           if (access(rcflout1))
               delete(rcflout1, ver-, >& "dev$null")
 
           unlearn cmkimg
           cmkimg("@"//imglist1, rcflout1, rc1, rc2, tquad1, head1, tfold1,
               tndr1, stripe1, pixty1, calcty1, sort1)
  
           unlearn type          
           type (templog, >> cndrproclog)

        # cleaning previous output
          if (delfl1)
             delete(imglist1, ver-, >& "dev$null")


        # check whether stopping after RC-correction
          if (stoprc)
            {
               # cleaning previous output (from cmkimg)
               if (delfl1)
                  {
                    tmplist = ""; tmplist = rcflout1
                    while( fscan(tmplist, tmpfile) != EOF)
                       delete("@"//tmpfile, ver-, >& "dev$null")
      
                    tmplist = "" # close the file
                    delete("@"//rcflout1, ver-, >& "dev$null")
                    delete(rcflout1, ver-, >& "dev$null")
                   }       # this brace is from if block (delfl)
         
                goto jumplab   # jump to just before the brace of while 
                               # block
            } # this brace is from if block (stoprc == yes)

  # If processing standard stars, not assemble into chip -- standard1 == yes
  #   if transpose == WHT or INT, run chiptrans, if not, not anything
  # Assemble quadrant-images into chip-images -- runing cmkchip -- !standard

      if (!standard1)
        {
          print("")
          print("", >> cndrproclog)
          print("=======Assembling quadrant-images into chip-images ========")
          print("=======Assembling quadrant-images into chip-images ========",
                   >> cndrproclog)
          print("")

        # rcflout1 is a list of fold lists output filename,   
        # make a filename containing the output foldlist from cmkchip
          if ((transpose1 == "WHT") || (transpose1 == "INT"))
             cobjin = "ta"//rcflout1
          else
             cobjin = "a"//rcflout1

          if (access(cobjin))
             delete(cobjin, ver-, >& "dev$null")

          print("Input list: ", rcflout1)
          print("Output list: ", cobjin)

              templog = "cmkchip.log"
              unlearn cmkchip
              cmkchip("@"//rcflout1, transpose1, doscaleq1)
              unlearn type
              type (templog, >> cndrproclog)

        } # this brace is from if block (!standard1)
      else
       {  # processing quad-images (not assemble quad-images to chip-images)
         print("")
          print("", >> cndrproclog)
          print("======= Processing quadrant images ========")
          print("======= Processing quadrant images ========",
                   >> cndrproclog)
          print("")

        # rcflout1 is a list of fold lists output filename,   
        # make a filename containing the output foldlist from cmkchip
          if ((transpose1 == "WHT") || (transpose1 == "INT"))
            {
              cobjin = "tq"//rcflout1
              print("Input list: ", rcflout1)
              print("Output list: ", cobjin)

              if (access(cobjin))
                  delete(cobjin, ver-, >& "dev$null")
    
              templog = "chiptrans.log"
              unlearn cqtrans
              cqtrans("@"//rcflout1, transpose1)
              unlearn type
              type (templog, >> cndrproclog)

            } # this brace is from if block (telescope1 == wht or int)
          else
            {
              cobjin = "q"//rcflout1

              if (access(cobjin))
                   delete(cobjin, ver-, >& "dev$null")
        
              copy(rcflout1, cobjin, ver+, >> cndrproclog)

            } # this brace is from if-else (telescope1 == none)
          
       } # this brace is from if-else (standard1 == yes)


         # cleaning previous output (from cmkimg)
           if (delfl1)
             {
               tmplist = ""; tmplist = rcflout1
               while( fscan(tmplist, tmpfile) != EOF)
                  delete("@"//tmpfile, ver-, >& "dev$null")
      
               tmplist = "" # close the file
               delete("@"//rcflout1, ver-, >& "dev$null")
               delete(rcflout1, ver-, >& "dev$null")
             }       # this brace is from if block (delfl)
          

         if (stopass)
            goto jumplab    #jump to the end of the while block (jumplab)


    
    # Performing the dark correction if (darkcorr == yes)
          if (darkcorr)
            {
              print("")
              print("", >> cndrproclog)
              print("========= Performing dark correction ==============")
              print("========= Performing dark correction ==============",
                    >> cndrproclog)
              print("")
   
              s1 = "" #clear the field
              tmpout = ""; tmpout = "d"//cobjin
              if (access(tmpout))
                  delete(tmpout, ver-, >& "dev$null")

              tmplist = ""; tmplist = cobjin
              while(fscan(tmplist, s1) !=EOF)
                {
                  unlearn csubqdark
                  csubqdark("@"//s1, "@"//darklist1, scalfac1)
                  templog = "csubqdark.log"
                  unlearn type
                  type(templog, >> cndrproclog)
                  print("d"//s1, >> tmpout) # producing a list of lists darks
                  etimechk = csubqdark.expcheck
                  if (etimechk == "B")
                      bye     #exit the program -- no exptime available

                  if (delfl1)
                    {  #cleaning the previous result
                      delete("@"//s1, ver-, >& "dev$null")
                      delete(s1, ver-, >& "dev$null")
                    } #this brace is from if-block (delfl1 == yes)
                } # this brace is from while-block (tmplist = cobjin)
              tmplist = "" # close the file
              s1 = "" #empty the field 

              delete(cobjin, ver-, >& "dev$null")
              cobjin = tmpout

            } #this brace is from if-block (darcorr == yes)

            print(cobjin, >> skylist) # producing a list of loolist of images
                                      # to make sky

         # need to prepare the input file for next task -- cmkqobj
         # cassfile1: containing imagenames -- e.g. nr1329_rc0502_1p
         # cobjin: containing foldlist -- e.g. tarc_r1329.in

   # Coadd the chip-images -- runing cmkqobj
#
          print("")
          print("", >> cndrproclog)
          print("======== Renaming the chip-images or quad-images===========")
          print("======== Renaming the chip-images or quad-images==========", 
                  >> cndrproclog)
          print("")
       
          # Need to produce output file containing output coadded imagenames
          objfile1 = "ca_"//cobjin
          templog = "cmkqobj.log"
          unlearn cmkqobj
          cmkqobj("@"//cobjin, objfile1, objstfold1, endfold1, osetfile1)
 
          unlearn type
          type(templog, >> cndrproclog)

         print("")
         print("", >> cndrproclog)
         print("************************************************************")
         print("*********************************************", >> cndrproclog)
         print("")
  
         # making list of dithering lists of coadded object images for
         #   substracting sky background

         print(objfile1, >> objflist)

         jumplab:     # jump from an option (stoprc or stopass)
       } # this brace is from while fold (rnolist, runno1)
         rnolist = "" # close the file
        
         delete(rnofile1, ver-, >& "dev$null")

   # Exit the program if (stoprc or stopass == yes)
         if ((stoprc) || (stopass))
           {
              print("<<=============== CNDRPROC DONE ================>>")
              bye
           }


  # Now we are ready to make the skyimage if we choose this option
      if (skyfile1 != "none")
        {
          templog = "cdossky.log"
          unlearn cdossky
          cdossky(skylist, objflist, prefiximg1, presky1, skyfile1, skystfold1,
              tchip1)
          unlearn type
          type(templog, >> cndrproclog)

         # cleaning previous results -- output images from cmkchip 
          if (delfl1)
           {
               tmplist = ""; tmplist = skylist # open file skylist
               while( fscan(tmplist, tmpfile) != EOF)
                 {
                   tmplist2 = ""; tmplist2 = tmpfile # open file cobjin
                   while( fscan(tmplist2, tmpfile2) != EOF)
                      delete("@"//tmpfile2, ver-, >& "dev$null")
      
                   tmplist2 = "" # close the file tmpfile
                   delete("@"//tmpfile, ver-, >& "dev$null")
                   delete(tmpfile, ver-, >& "dev$null")
                 } # this brace is from while fold (tmplist, tempfile)

               tmplist = ""   # close the file skylist
               delete(skylist, ver-, >& "dev$null")
             }       # this brace is from if block (delfl)
        }  # this brace is from if block (skyfile1 != none)
     else
        {
           print("")
           print(" === Example input files for sky substraction CDOSSKY ===")
           print("Make skyframes: ",skylist)
           print("Input object image file: ", objflist)
           print("")
        } # this brace is from if else block (non-skysubtractiion case)

   # Exit the program if (skyfile1 = none || flatcorr == yes)
         if ((skyfile1 ==  "none") && (flatcorr1))
            {
              print("")
              print("  The sky substraction must be done before flat-fielding")
              print("")
              print("<<=============== CNDRPROC DONE ================>>")
              bye
           }

  #  Performing  flat-fielding correction
       if (flatcorr1)
         {
           print("")
           print("", >> cndrproclog)
           print("======= Performing flat-fielding correction ======")
           print("======= Performing flat-fielding correction ======",
              >> cndrproclog)
           print("")
           tmpout = "" # clean the variable
           tmpout = "s"//prefiximg1//"_chip.in"   #output listfile from 
                                             #skysubtraction
                                 #sm51_chip.in (sm51_c01.in,..., sm51_c04.in)
           templog = "cqflatcor.log"
           unlearn cqflatcor
           cqflatcor("@"//tmpout, "@"//flatlist1)
           unlearn type
           type (templog, >> cndrproclog)

           if (delskyfl1)
             { #cleaning the sky-subtacted images
               s1 = "" #clean the field
               tmplist = ""; tmplist = tmpout
               while (fscan(tmplist, s1) !=EOF)
                    delete("@"//s1, ver-, >& "dev$null")

               tmplist = "" #close the file
               delete("@"//tmpout, ver-, >& "dev$null")
               delete(tmpout, ver-, >& "dev$null")
             } # this brace is from sky-subtracted images
           
         } # this brace is from if-block (flatcorr1 == yes)
  #  Final cleaning up
        


        print("<<=============== CNDRPROC DONE ================>>")

end


