# IRAF script -- 
#      function: to update the header after each processing
#	
# programmer: sjchan 
#          history: 
#             july 1997 -- modified from irheadup.cl 
#             12mar98   -- add transpose (TR)
#

procedure _irheadup(frame_in,index_case)

string	frame_in   {"",prompt="(@List of / *.imh) Input images",mode="ql"}
string	index_case   {"",prompt="which processing:(D,SF)",mode="ql"}
struct  *filist

begin
        string  ftmpi, ifile
        string  ind
        string  fdname, framein
        int     leni
        string  s1

        #  Get the rest of the parameter

        ftmpi=frame_in
        ind = index_case
        fdname=""

          if (ind == "D")               # dark correction 
            fdname = "DARK_COR"         
          if (ind == "F")               # flat fielding correction
            fdname = "FLATCOR"
          if (ind == "S")               # sky background correction
            fdname = "SKYCOR"
          if (ind == "N")               # noise correction
            fdname = "NOISE_COR"
          if (ind == "TR")               # trimming process
            fdname = "TRANSPOSE"
          if (ind == "X")               # Fix badpix
            fdname = "BAD_COR"
          if (ind == "L")
            fdname = "SLICED"           # slicing processing

        # updated the title in the image header and the noise-cor flag
        #  to the header

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }


        filist = ""; filist = ifile
        while(fscan(filist,framein) !=EOF)
         {
          imgets(framein, param="i_title")
              s1=(imgets.value)//" "//";"//ind
           hedit(framein,field="i_title",value=s1,add-,del-,ver-,update+,
                 show-)
           hedit(framein,field=fdname,value=ind,add+,del-,ver-,
                 update+,show-)
         }

         filist = "" # close the file

       if (stridx(ftmpi, "@") != 1)
          delete(ifile, ver-, >& "dev$null")

end

