# IRAF script -- _finout.cl
#	
#   this is a main file management task which is a HIDDEN task.
#    user cannot this it in the front end.
# programmer: sjchan 
#       history: july97  -- created 
#                oct97   -- modified
#                10feb98 -- add an option: transpose case
#                 8may98 -- add an dummy option: cleaning sky case
#	       28april99 - mhoenig: added "TQR" option, for transposed single
#			    quadrants! This adds the required "q" to the various
#			    out-list files - without which the tasks weren't 
#			    finding them!
#	       29april99 - mhoenig: but changed the actual image prefix back
#			    from "tq" to just "t", the "q" is redundant and 
#			    confusing.
#

procedure _finout(frame_in,index_case, file_in, file_out)

string	frame_in   {"",prompt="(@List of / *.fit*) Input images",mode="ql"}
string	index_case {"",prompt="which processing:(L,A,D,M,Q,CR,X)",mode="ql"}
string  file_in   {"",prompt="Modified Input file containing names of image files ",mode="ql"}
string  file_out  {"",prompt="Output file containing names of image files ",mode="ql"}
struct  *filist

begin
        string  framein           # Input image with FITS extension
        string  ftmpi             # List of input images   
        string  framein2          # Output image with FITS extenion
        string  frametemp         # dummy variable (for input image)
        string  fintemp, foutemp  # final verison of input and output list
        string  fout2             # filename of output list
        string  ifile             # dummy variable
        string  ind               # indicator
        int     icount, icount2   # counters (dummy variables)
        int     leni, ic          # dummy variables (length of string variables
        int     len, len3, itemp
        string  s1, s2
        int     i

        #  Get the rest of the parameters

        ftmpi=frame_in
        ind = index_case
        fintemp=file_in
        foutemp=file_out
        framein2 = ""
        framein = ""

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

        filist = ifile
        icount = 0
        icount2 = 0
        if (access("slice.out"))
           delete("slice.out", ver-, >> "dev$null")

	while (fscan(filist,frametemp) !=EOF)
        {
        # Check whether the input frames with "FITS" extension
          unlearn _checkfit
          _checkfit(frametemp)
          framein = _checkfit.framext  # now the file with fits extension

        # Make the output image  name
         icount += 1

         if (ind == "A")   # assemble 4 quadrants into 1 frame
           {
             itemp = mod(icount, 4)
             if (itemp == 1)
               {
               # find out the location "_" and make a list of output file names
                 icount2 += 1
                 _chipfin(framein, icount2)
                 framein2 = _chipfin.chipin    

                 print(framein2, >> foutemp)
               }
           }  # this brace is from if block 'ind == "A" '

	  if (ind == "TR")
             framein2 = "t"//framein    # transpose the image into right
                                        #  orientation: N -- up
          if (ind == "QTR")             # transpose: quads only 
	     framein2 = "t"//framein
          if (ind == "D")               # dark correction 
             framein2 = "d"//framein
          if (ind == "S")               # sky background correction
             framein2 = "s"//framein
          if (ind == "F")               # flat fielding correction
             framein2 = "f"//framein
          if (ind == "X")               # Fix badpix
             framein2 = "x"//framein    
          if (ind == "Q")               # Fix quad noise
             framein2 = "q"//framein    
          if (ind == "CR")                 # cosmicrays correction
             framein2 = "cr"//framein
          if (ind == "C")
             framein2 = "c"//framein     # combining process
          if (ind =="N")
             framein2 = "n"//framein     # destriping process
          if (ind == "O")
             framein2 = "o"//framein     # offset process
          if (ind == "DI")
             framein2 = "di"//framein     # quick display the seriew
         if (ind == "CS")
             framein2 = "cs_"//framein     # cleaning sky process
          if (ind == "L")                 # slice process
             {
               imgets(framein, param="i_naxis3")
               ic = int(imgets.value)
               len = strlen(framein)
               s1 = substr(framein, 1, len - 5)
               framein2 = s1//"_"
               print (framein2, >> foutemp)   # list of initial of output image
            
               # Make the list of real output images from slice process
               for (i = 1; i <= ic; i += 1)
                 {
                   if (i < 10)
                     s2 = s1//"_00"//str(i)//".fits"
                   else if (i < 100)
                     s2 = s1//"_0"//str(i)//".fits"
                   else
                     s2 = s1//"_"//str(i)//".fits"
        
                   print(s2, >> "slice.out")
                 }

             }
          if (ind != "A"  && ind != "L") 
              print(framein2,  >> foutemp)
          
          print(framein,  >> fintemp)

          if (access(framein2))
            imdelete(framein2, ver-, >& "dev$null")
   
        } # this bracket is from the while loop

	if (stridx(ftmpi, "@") == 1)
         {   # to produce a suitable outfile name if the input is the list
             fout2 = ""
          if (ind == "TR")              # transpose the images
             fout2 = "t"//ifile        
          if (ind == "QTR")             # transpose: quads only 
	     fout2 = "tq"//ifile
          if (ind == "D")               # dark correction 
             fout2 = "d"//ifile
          if (ind == "F")               # flat fielding correction
             fout2 = "f"//ifile
          if (ind == "S")               # sky background correction
             fout2 = "s"//ifile
	  if (ind == "X")               # Fix badpix
             fout2 = "x"//ifile    
	  if (ind == "Q")               # clear quad noise
             fout2 = "q"//ifile    
          if (ind == "CR")             # clear cosmicrays
             fout2 = "cr"//ifile
          if (ind == "C")
             fout2 = "c"//ifile          # combine process
          if (ind == "N")
             fout2 = "n"//ifile          # destriping process
          if (ind == "O")
             fout2 = "o"//ifile          # offset process (dummy)
          if (ind == "DI")
             fout2 = "di"//ifile  
          if (ind == "A")                # assemble the quads
             fout2 = "a"//ifile
          if (ind == "CS")                # cleaning sky process
             fout2 = "cs_"//ifile
          if (ind == "L")                # slice process
             fout2 = "l"//ifile

          if (access(fout2))
             delete(fout2, ver-, >& "dev$null")
          copy(foutemp, fout2)
     
          if ((ind == "C") || (ind == "O") || (ind == "DI") || (ind == "L") ||
              (ind == "CS") )
             delete(fout2, ver-, >& "dev$null") 
           
         } # this brace is from if statement
        else
         delete(ifile, ver-, >& "dev$null")

        
end

