# IRAF script -- csubdark
#	
#  function: subtract the dark from the frames
#
# programmer: sjchan (oct 1997)
#  history:   oct97  -- created: cirsubdark.cl
#            23jan98 -- reanme to csubdark.cl
#            28may98 -- scaling factor option (direct input)
#            1july98 -- scaling factor option (get exptime from header)
#

procedure csubdark(frame_in,file_dark, scalfac)

string	frame_in   {"",prompt="(@List of / *.fits) Input images",mode="ql"}
string  file_dark  {"",prompt="Name of Dark frame",mode="ql"}
bool    scalfac      {yes, prompt="scaling the nomalized darks", mode="ql"}
string  check      {prompt="exposure time indicator in the header"}

struct  *filist, *folist

begin
        string  ftmpi        # list of input images
        string  fdark        # Name of dark frame
        string  tsfdark       # scaled dark
        bool    scalfac1       # the scaling factor
        string  ifile,ofile  # final verison of list of input and output
        string   sublog      # logfile
        string  ind          # indicator
        string  imgin        # individual input frame
        string  imgout       # individual output frame
        string  sscale       # scaling factor from header in string
        real    scale        # scaling factor (real)
  

        cache imgets     # need this action due to a bug in imgets
        #  Get the rest of the parameter

          ftmpi=frame_in
          fdark=file_dark
          scalfac1 = scalfac
          sublog="csubdark.log"
          tsfdark = "tsfdark.fits"
          ind="D"    # dummy definition
          ifile="dummy1_dark"
          ofile="dummy2_dark"
          check = "G"
     
        #  Check the existence of the logfile
           if (!access(fdark))
             {
               print("")
               print("   ", fdark, " is not in the current directory!")
               print("    csubdark is going to be terminated!")
             }
           if (access(sublog))
             delete(sublog, ver-, >& "dev$null")
            if (access(tsfdark))
             delete(tsfdark, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
		

        #  Find out the suitable input option

           unlearn _finout
           _finout(ftmpi, ind, ifile, ofile)

           filist = ""; filist = ifile
           folist = ""; folist = ofile           
           while( (fscan(filist, imgin) !=EOF) && 
                  (fscan(folist, imgout) !=EOF) )
            { 
             #  check the existence the output file
              if (access(imgout))
                  delete(imgout, ver-, >& "dev$null")

          # get the exposure time from image header
             if (scalfac1)
               {
                 imgets(imgin, param="exptime")
                 sscale = imgets.value
                 if ( (sscale == "") || (sscale == "0") || (sscale == "/") )
                   {
                     print("")
                     print("     Bad exptime keyword in the header")
                     print("Using hedit to put exptime into the header")
                     check = "B"
                     bye
                   }
                 else
                    scale = real(sscale)

               } # this brace is from if-block (scalfac1 == yes)
              else 
                scale = 1.0

          
        #  scaling the dark
           unlearn imarith
           imarith(operand1=fdark, op="*", operand2=scale,
            result=tsfdark, title="", divzero=0., hparams="", 
            pixtype="real", calctype="real", verbose=yes, 
            noact=no, >> sublog)

        # subtract the dark

           unlearn imarith
           imarith(operand1=imgin, op="-", operand2=tsfdark,
            result=imgout, title="", divzero=0., hparams="", 
            pixtype="real", calctype="real", verbose=yes, 
            noact=no, >> sublog) 

          delete(tsfdark, ver-, >& "dev$null")
       }
          filist = ""; folist = "" #close the files

        # updated the title in the image header and the noise-cor flag
        #  to the header
 
         _irheadup("@"//ofile,ind)

        # Clearing up

          delete(ofile, ver-, >& "dev$null")
          delete(ifile, ver-, >& "dev$null")
          delete(tsfdark, ver-, >& "dev$null")


#          print("      <<=========== csubdark DONE =========== >>")
#          beep; beep; beep

end

