# IRAF script -- cqtrans.cl
#	
#   function:  to make quad-images 
#               input: from the output of cmkimg (rc_rxxxx.in) list of lists
#    stage: NEED change
#
# programmer: sjchan 
#   history: 5june98 -- created
#        

procedure cqtrans(file_in, telescope)

string	file_in  {"",prompt="(@List of lists) of Input quad- images",mode="ql"}
string  telescope {"WHT",prompt="Telescope to be used",mode="ql"}

struct  *filist

begin
        string  filein      # input file list of lists of quad-images
        string  telescope2   # telescope to be used
        string  ifile       # the final version of input file 
        string  foldin      # the input list individual quad-images
        string  fileout    # the output list of list individual chip-images
        string  cqtranslog   # logfile
        string  templog     # dummy variable (temporary logfile)
        int     ic, icdet   # counters
        int     leni        # the length of the input file name 
        string  fout        # dummy variable
        string  foldout     # the output of individual chip-images

   

      #  Get the rest of the parameters

        filein = file_in
        telescope2 = telescope
        cqtrans = "cqtrans.log"
        templog = "chiptrans.log"

        #  Find out the suitable input option

        print ("")
	print ("Transposing images ...")
	
	leni=strlen(filein)

        if (stridx(filein, "@") == 1)
           ifile = substr(filein, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

        if (telescope2 == "none")
           fileout = "q"//ifile  
        else
           fileout = "tq"//ifile
	
     # Check existence of output files

        if (access(cqtranslog))
           delete(cqtranslog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

     # Read the list of input list filename of quads
        ic = 0
        filist = ""
        filist = ifile   # open the file
        while (fscan(filist, foldin) != EOF)
         {
	    ic += 1
            print("Fold ", ic, >> cqtranslog)
            chiptrans("@"//foldin, telescope2)    # assemble the quads 
            if (telescope2 == "none")
               print("q"//foldin, >> fileout)
             else
	       print("tq"//foldin, >> fileout)
   
            print("", >> templog)
            print("=========================================", >> templog)
            unlearn type
            type(templog, >> cqtranslog)
          }    # this brace is from while (filist, filein)

         # close the files and cleaning up
           filist = ""   


          print("CQTRANS done.")

end

