# IRAF script -- cqflatcor.cl
#	
#   function:  to subtract the quad-nflat
#               input: from the output of ccmkimg or ccmkobj, ccmkqnflat
#
# programmer: sjchan (nov 97)
#        

procedure cqflatcor(file_in, flat_list)

string	file_in   {"",prompt="(@List/of  lists) of Input chip or quad images",mode="ql"}
string  flat_list  {"",prompt="@List of normflat (quad or chip)", mode="ql"}

struct  *filist, *filist2

begin
        string  ftmpi     #i input file list
        string  flatlist  #i a file containing list of flats
        string  flatfile  #i individual flat frame
        string  ifile     #i the final version of input file 
        string  fileout   #i a file containing the output list filename
        string  quadin    #i input for cflatcor
        string  filein    #i (dummy variable)final input verion for cflatcor 
        string  cqflatcorlog   #o logfile
        string  templog    # dummy variable (temporary logfile)
        string  flattemp   # dummy variable (final version of input flat string
        int     leni       # length of input file list string
        int     lentemp    # dummy variable (length of input image)
        int     ic         # quad-counter
        int     idrop      # the location of the last "." of the input image
        string  prechar    # the pre-character of the output filenames
        string  s1

      #  Get the rest of the parameters

        ftmpi = file_in
        flatlist = flat_list
        cqflatcorlog = "cqflatcor.log"
        templog = "cflatcor.log"
        prechar = "f"

 
        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
         {
           ifile = substr(ftmpi, 2, leni)
           fileout = prechar//ifile
         }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           fileout = "cqflatcor.in"
         }

        leni = strlen(flatlist)
        if (stridx(flatlist, "@") == 1)
           flattemp = substr(flatlist, 2, leni)
        else
         {
           flattemp = mktemp("fin")
           sections(flatlist, option="fullname", > flattemp)
         }

     # Check existence of output files

        if (access(cqflatcorlog))
           delete(cqflatcorlog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")


      # Read the list of input  list filename
        ic = 0
        lentemp = 1
        filist = ""; filist2 = ""
        filist = ifile; filist2 = flattemp
        while ( (fscan(filist, quadin) != EOF) &&
                (fscan(filist2, flatfile) != EOF) )
         {
           ic += 1     # count quad
                lentemp = strlen(quadin)
         # To locate the last "." in the string
               _locate(quadin, ".")
               idrop = _locate.value
               s1 = substr(quadin, idrop+1, lentemp)
               if ((s1 != "fits") && (s1 != "fit") && (s1 != "imh"))
                 filein = "@"//quadin
               else
                 filein = quadin 

               print(prechar//quadin, >> fileout)   # collect the output filenames
                                                # in filout
                print("", >> cqflatcorlog)
                print("Chip or Quad ", ic, >> cqflatcorlog )
                cflatcor(filein, flatfile)
                unlearn type
                type (templog, >> cqflatcorlog)
                print("=========================================", >> cqflatcorlog)

         }    # this brace is from while (filist, quadin)

         # close the files and cleaning up
           filist = ""  ; filist2 = "" 
           if (stridx(ftmpi, "@") != 1)
             delete(ifile, ver-, >& "dev$null")
           if (stridx(flatlist, "@") != 1)
             {
              delete(flattemp, ver-, >& "dev$null")
              print("")
              print("Remember to rename ", fileout, " if you wish to use it later")
             }
          print("CQFLATCOR done.")
          # beep; beep; beep

end

