# IRAF script -- cndrproc
#	
#   function:  to do the reduction up to sky-subtraction given the prefix
#                and a list of running numbers
#              (this is a proto-type)
#              
#      basic tasks: _mkrnoifl -- _mkilist -- cmkimg (-- cstripe) --
#                   cassquad (-- chiptrans) -- cmkqobj --
#                   cdossky (cmkqsky -- cmkqlist -- csubqsky)
#      abb: ir  - input requred; ih -- input hidden; ip -- input by program
#           o-i - output --> input; of - final output; oh -- output hidden
#                                   ot - temporaray output
#
# programmer: sjchan 
#    history: 17march98 (create)
#             4june98 -- modified (to process any number of chip-images
#             5june98 -- modified (to process quadrant-images)
#                        -- add a reuqired parameter: standard
#             8june98 -- modified (able to select the single chip/quad files)
#                        -- add a hidden parameter: quadnos
#             11june98 -- modified (to add to use a non-scaling quads option)
#                         -- (hidden parameter: doscaleq == yes, default)
#             26june98 -- modified (to add an option for the user to supply
#                            a directory where the raw data is kept.
#                           -- (hidden parameter: datapath = current, default)
#                           -- change "prefix" from a required parameter into
#                                a hidden parameter
#             29june98 -- modified (make a stop option after cmkimg and
#                           cmkchip)
#
#             2july98 -- add an option to perform the dark correction
#             3july98 -- add an option to perform the flat-fielding correction
#            16july98 -- add an option to select the pixtype, calctype for
#                         RC corrections
#                      input running numbers containing in a file also (option)
#
#             7aug98 -- INPUT"tquad" must be the real tquad number which is 
#                         used to generate the sequence number by PIXEL in
#                          order to call new version of cmkimg. Need to refine
#                          "tchip1". Parameter "standard" is NOT used anymore.
#
#             7aug98 -- add pset option for user (cdossky)
#
#            13aug98 -- try to get prefix from header  (para = "object") after
#                         rnofile1 is created
#            14aug98 -- *try to get tndr from the header (para = "tndr")
#                       change the following parameters to become hidden
#                       parameters::
#                       tfold, tquad, range1, range2,  presky
#                       *skyfile1 becomes INTERNAL REQUIRED parameter
#                       *add a new parameter: bool mksky (front end parameter)
#                       *mgb said that keyword "nframes" is totquad 
#                         so, tquad can be obtained from header 
#                              (dangerous approach, requested by rgm)
#             
#    23aug98(sjchan) -- using rgm and mhoenig's input parameter prompts
#    26aug98(sjchan) -- put Date and time during each run
#    06feb99(rgm)    -- prompts and defaults changes so that defaults
#                        do not require flats or darks
#    23mar99(mhoenig)-- * removed the "presky" prompt. Ie., the name of the sky images
#			  is no longer a user option, since
#			* all sky image names are now unique, ie. will not be
# 			  overwritten - they contain info on the run nos. used, the 
#			  chip and the reset corr.
#			* changed some default parameters and prompts slightly
#			* removed option to delete the sky-subtracted images 
#			  (delskyfl), since it is utter nonsense
#			* rewrote all the output in print statements to make more
#			  sense in English  (phew!)
#			* now deletes all the single-chip _1p images, they seem to be
#			  exactly the same as the ones without an _1p, so not sure why
#			  keep them - just waste space.
#			  Also deleting dummy* files, but like I say below, there is a
#			  lot more junk (mainly obscure list files) that could be
#			  deleted
#			* added option for pre-rc'ed and pre-assembled data
#			  (not sure if this works the way it should yet)
#    25mar99		* it does now!
#    26mar99		* Now also can handle pre-assembled data; did this by creating
#			  a new parameter, "preass", which is passed down --> cmkchip
#			  --> cassquad
#    22april99		* actually this was only fully implemented yesterday. A 
#			  (tedious!) rewrite of several of the subroutines was 
#			  required.
#			  Additionally, now parse the list of run nos. for the
#			  name of the sky image.
#    23june99: * changed prompts for destriping options.
#	       * removed the two "Stop after...") command lines as they are redundant.
#	         Hence set stoprc1 and stopass1 directly. Beware! Might cause problems?
#


procedure cndrproc(rnorange)

string rnorange  {"", prompt="Run numbers to be processed (list or @file)", mode="ql"}
bool   prerc     {no, prompt="Has the data already been reset-corrected?"}
bool   preass    {no, prompt="Has the data already been assembled?\n"}
bool   dostripe	 {no, prompt="Perform first pass destriping correction?"}
#bool   stoprc 	 {no, prompt="Stop after reset correction?"}
bool   darkcorr	 {no, prompt="Perform dark correction?"}
bool   scalfac	 {no, prompt="Use dark frames that are scaled to 1s?"}
bool   doscaleq	 {no, prompt="Scale quadrants when assembling?"}
#bool   stopass	 {no, prompt="Stop after assembling chip images?"}
bool   dotrans   {no, prompt="Rotate images so North is on top?"}
bool   mksky     {yes, prompt="Make sky images?"}
bool   usebpm    {no, prompt="Use bad pixel map (bpm) when making sky?"}
bool usrskyopt   {no, prompt="Edit the IMCOMBINE parameters for sky creation directly?"}
bool   subsky    {yes, prompt="Subtract the sky background?"}
bool   flatcorr  {no, prompt="Perform flat field correction?"}
#bool   coadd    {no, prompt="Co-add sky-subtracted images?"}
#bool   coverage {no, prompt="Generate coverage (exposure) map image?"}
bool   delfl     {no, prompt="Delete intermediate output images?\n"}
#bool   delskyfl {no, prompt="Delete sky-subtracted images?"}
string datapath  {"CURRENT", prompt="Path name for raw data location"}
string quadnos   {"all", prompt="Chips or quadrants to process (c1, q1, .. all)"}
int    tfold     {1, prompt="Total number of folds"}
int    range1    {1,   prompt="Lower NDR of RC pair"}
int    range2    {4,   prompt="Upper NDR of RC pair"}
string calctype  {"short", prompt="Calctype to use for reset-correction",enum="short|ushort|integer|long|real|double"}
string pixtype   {"short", prompt="Pixtype of reset-corrected images", enum="short|ushort|integer|long|real|double"}
string stripe	 {"fd", prompt="Stripe correction algorithm to use? (fd|dB|dR|dC|B|R|C)"}
string darklist  {"", prompt="List of dark images"}
string transpose {"none", prompt="Telescope to use for transpose? (INT|WHT|DUP)"}
#string presky   {"sky_c", prompt="Prefix of output sky frames"}
pset   mkskypar  {prompt="pset: IMCOMBINE parameters for making sky images"}
string flatlist  {"", prompt="List of flat field images\n"}
string obj_stfold {"1", prompt="Starting fold for coadding object frames"}
string sky_stfold {"1", prompt="Starting fold for making sky frames\n"}


struct *rnolist
struct *tmplist
struct  *tmplist2

begin

  # Declare local parameters
    # basic local parameters for cndrproc
       string rnorange1       #ir  range of running number
       string rnofile1        #ir  list of input running numbers
       bool   delfl1          #ih   delete the intermediate output images
       bool   delskyfl1       #ih   delete the sky-subtracted images
       string cndrproclog    #fo   logfile of cndrproc
       string templog         #ot   temporary logfile from each task
       bool   stoprc1         #ih   stop after RC correction
       bool   stopass1        #ih   stop after assembling the quadrants into
                              #      chips
       struct list            # dummy string
       
       bool prerc1, preass1   # data already reset-corr'd/assembled?

    #basic local paramters for _mkilist
       string prefiximg1      #ih  prefix of raw data filename
       string runno1          #ir  running number for the list, runnofile1
       int    tfold1          #ir  total number of folds
       int    tquad1          #ir  total number of quadrants
       string quadnos1        #ir  chipno/quadno to be selected 
       string imglist1        #o-i  name of the file containing ndr raw list
       string dcase1          #i read-out mode  (NDR)
       string chk1            #oh  check file flag (G/B)
       string datapath1       #ih  path of data directory
 
    #basic local parameters for cmkimg
       int     tndr1        #ir   total number of NDR per fold
       int     rc1, rc2     #ir   RC pair (range1, range2)
       bool    dostripe1    #ih   destriping correction option
       string  stripe1      #ih   destriping correction option
       bool    sort1        #ip   ask sort the input list (yes)
       bool    head1        #ip   ask for getting information from header (no)
       string  pixty1       #ip   pixtype of output images from cmkimg 
       string  calcty1      #ip   calculating type for IMARITH in cmkimg
       string  rcflout1  #o-i name of file containing output images from cmkimg
                         # rcflout1 is a list of fold lists of RC pairs 

    #basic local parameters for cmkchip
       bool   doscaleq1     #ih  ask scaling quads (default: yes)
       bool   dotrans1       #ih  (dummy input parameter, requested by rgm)
       string transpose1    #ih  ask transpose image (north-top; WHT/none)
       string cassfile1     #o-i file containing output images from cmkchip
                                 # non-transpose or transpose option
       string cobjin        #o-i file containing output foldlist of cassfile1
                            #o-i Or: file containing output foldlist of 
                              # chiptranfile1

   #basic local parameters for csubqdark
       bool    darkcorr1    #i  ask dark correction (default: yes)
       bool    scalfac1     #i  using scaled darks if darkframe are normalized
       string  darklist1    #i  list of the darks  
       string  etimechk     #o  indicator of keyword exptime
       string  tmpout       #o-i  file containing output foldlist of cobjin
        
    #basic local parameters for cmkqobj
       string objfile1      #o-i file containing output coadded object images
                                   # from cmkqobj
       string objstfold1    #ih  the start fold number for combination
       string endfold1      #ip  the end fold number for combination
                                   # need to find out from the program 
                                   # count objfile
       string osetfile1     #ip  offset file (none)
       bool   usrobjopt1    #ip   input IMCOMBINE parameter by user

   #basic local parameters for cdossky
       bool mksky1          #ir perform make sky images
       bool usebpm1         # use BPM when make sky images
       string skyfile1      #o-i/of  name of file containing output skyframes
       string skylist       #ip  name of file containing list of "cassfile1"
                                #  which is for making skyframes
       string presky1       #ir     prefix of output sky frames
       string skystfold1    #ih     the starting fold number for making sky
       string objflist     #ot  file containing list of dithering lists of
                             #coadded images
       bool subsky1        #ir  perform substract sky background
       bool usrskyopt1     #ir  user option to choose one's IMCOMBINE 
                             #parameters for making sky

   #basic local parameters for cqflatcor
       #string tmpout -- use again -- #o-i output filename (list of lists)
       #                       containing substracted sky images
       bool flatcorr1      #ih  prompt flat-fielding correction (default: yes)
       string flatlist1    #ih  list of flats 

   #temporary local parameter in cndrproc
       string ss1, s1, s2, s3
       string tmpfile, tmpfile2   # dummy variable
       int    tchip1              # total number of chips
       int    lenrno
       string fieldid         # field ID to calculate tchip1
       int    ic1


       string srno1, srno2	# first and last run no.
       string runnolist
       

  # Get the rest of parameters 
       rnorange1  = rnorange   # required
       tfold1     = tfold
       rc1        = range1 
       rc2        = range2 
       mksky1     = mksky
       usebpm1    = usebpm
       #presky1    = presky 
       datapath1  = datapath  
       pixty1     = pixtype
       calcty1    = calctype
       stripe1    = stripe    
       dostripe1  = dostripe
       dotrans1   = dotrans
       transpose1 = transpose
       doscaleq1  = doscaleq
       quadnos1   = quadnos
       darkcorr1  = darkcorr
       darklist1   = darklist
       scalfac1   = scalfac
       usrskyopt1 = usrskyopt
       subsky1    = subsky
       flatcorr1  = flatcorr
       flatlist1  = flatlist
       objstfold1 = obj_stfold
       skystfold1 = sky_stfold
       delfl1     = delfl
       #delskyfl1  = delskyfl
       
       prerc1     = prerc
       preass1    = preass

  # Define the local or temporary parameters
       prefiximg1 = ""
       cndrproc = "cndrproc.log"
       templog = "temp.log"
       dcase1 = "NDR"     # for _mkilist
       chk1 = ""
       imglist1 = "r0000.in"   # default (will be changed by running no)
       sort1 = yes; head1 = yes      # for cmkimg
#       pixty1 = "real"; calcty1 = "real"
       rcflout1 = "rc_"//imglist1   # (wil be changed by running no)
       cobjin = "cobjin"
       tmpout = "tmpout"
       etimechk = "G"  #for csubqdark
       osetfile1 = "none"      # for cmkqobj
       endfold1 = str(tfold1)
       lenrno  = 1
       tndr1 = 0
       tquad1     = 16 #(default)
       tchip1 = 4 #default
       usrobjopt1 = no

       fieldid = substr(quadnos1, 1, 1)
       if (fieldid == "")
         fieldid = "a"

       if (mksky1)
          skyfile1 = "skyframe.in"
       else
          skyfile1 = "none"

       cache imgets     # need this action due to a bug in imgets

       if (access(cndrproclog))
           delete(cndrproclog, ver-, >& "dev$null")

        if (!dostripe1)
            stripe1 = "NO"

        if (dostripe1 && (stripe1 == ""))
          {
             print("")
             print("There are 7 possible destriping correction algorithms:")
             print("fd | dB | dR | dC | B | R | C")
             print(" Please try again! Exiting ...")
             print("")
             bye
          }

       if (!dotrans1 && (transpose1 != "none"))
           transpose1 = "none"

       if (dotrans1 && (transpose1 == ""))
          {
             print("")
             print("There are 3 telescope options:  WHT | INT | DUP")
             print(" DUP is NOT available at this moment.")
             print(" Please try again! Exiting ...")
             print("")
             bye
          }


 # Check the existence of calibration files (such dark frames, flat frames)
        print("")
        print("Checking for calibration files ...")
          chk1 = "G"
          unlearn _chkcalib
          _chkcalib(darkcorr1, darklist1)
          chk1 = _chkcalib.index
          if (chk1 == "B")
             bye     # exit the program 

          chk1 = "G"
          unlearn _chkcalib
          _chkcalib(flatcorr1, flatlist1)
          chk1 = _chkcalib.index
          if (chk1 == "B")
             bye    #exit the program

 # Make a running number list from given range of running number and input file

           if (prefiximg1 == "")
              s3 = "tmp"
           rnofile1 = s3//"_rno.in"
           if (access(rnofile1))
               delete(rnofile1, ver-, >& "dev$null")

           lenrno = strlen(rnorange1)
           if (stridx(rnorange1, "@") == 1)
             rnofile1 = substr(rnorange1, 2, lenrno)
           else
             {
               unlearn _mkrnoifl
               _mkrnoifl(rnorange1, rnofile1)      
             }
	     
	runnolist = mktemp("runnos")//".list"
	copy (rnofile1, runnolist, ver-,  >& "dev$null")

 # Make a fold to start preprocessing images
      ic = 0
      rnolist = ""; rnolist = rnofile1      
      while( fscan(rnolist, runno1) != EOF)
       {
         flpr # need to free the process memory

          ic += 1
          # print("")
          print("", >> cndrproclog)
          print("", >> cndrproclog)
          print ("")
	  print ("Run number: ", runno1)
          print("Run number: ", runno1, >> cndrproclog)
          print("")
          list = ""; time | scan(list)
          print("Starting reduction: ",list, >> cndrproclog)
          # print("Starting reduction: ",list)
          # print("")
          print("Making input list ...")
          imglist1 = "r"//str(runno1)//".in"
          # print("Input list: ", imglist1)
          if (access(imglist1))
             delete(imglist1, ver-, >& "dev$null")

         if ((datapath1 == "CURRENT") || (datapath1 == "") ) 
               datapath1 = "current"

	 # Make an input list from runno and prefix of raw data filename
         unlearn _mkilist
         _mkilist(datapath1, prefiximg1, runno1, dcase1, tfold1, imglist1, quadnos1)
 

         # check the list is incomplete, exit the program
           chk1 = _mkilist.chk
           if (chk1 == "B")
             {
               rnolist = ""
               bye
             }

         tndr1 = _mkilist.tndr
         tquad1 = _mkilist.tquad
         # print("tquad1: ", tquad1)


   # Get the prefix of the image name from the header if ic == 1
      
          if (ic == 1)
            {
              tmplist = ""; tmplist = imglist1
              while (fscan(tmplist, s2) != EOF)
               {
                 imgets(s2, param="object")
                 prefiximg1 = imgets.value
                 break
               }#this brace is from while block (tmplist = imglist1 get prefix)

              tmplist = "" # close the file
              skylist = prefiximg1//"_dithersky.in"   # for cdossky
              objflist = prefiximg1//"_ditherobj.in"   # for cdossky 
                                       # subsky (list of dithering list)
              if (mksky1)
                  skyfile1 = prefiximg1//"_"//skyfile1

              if (access(skylist))
                delete(skylist, ver-, >& "dev$null")
              if (access(objflist))
                delete(objflist, ver-, >& "dev$null")
           } #this brace is from if-block (ic == 1)


   # Obtain the RC pair images -- run cmkimg
           print("", >> cndrproclog)
           list = ""; time | scan(list)
           print("Starting reset correction: ",list, >> cndrproclog)
           # print("Starting reset correction: ",list)
           # print("")
	   list = ""
           print("Performing reset correction ...")
           print("Performing reset correction ...", >> cndrproclog)
           # print("")

           if (stripe1 != "NO")
               rcflout1 = "nrc_"//imglist1
           else 
               rcflout1 = "rc_"//imglist1

           templog = "cmkimg.log"
           if (access(rcflout1))
               delete(rcflout1, ver-, >& "dev$null")

	   unlearn cmkimg

	   if (prerc1==0)
	   {
              cmkimg("@"//imglist1, rcflout1, rc1, rc2, tquad1, head1, tfold1,
               tndr1, stripe1, pixty1, calcty1, sort1, dorc=yes)
	   }
	   else if (prerc1==1)
	   {
              cmkimg("@"//imglist1, rcflout1, rc1, rc2, tquad1, head1, tfold1,
               tndr1, stripe1, pixty1, calcty1, sort1, dorc=no)
	   }
	   

             unlearn type          
           type (templog, >> cndrproclog)

        # cleaning previous output
          if (delfl1)
             delete(imglist1, ver-, >& "dev$null")


        stoprc1=no
	# check whether stopping after RC-correction
          if (stoprc1)
            {
               # cleaning previous output (from cmkimg)
               if (delfl1)
                  {
                    tmplist = ""; tmplist = rcflout1
                    while( fscan(tmplist, tmpfile) != EOF)
                       delete("@"//tmpfile, ver-, >& "dev$null")
      
                    tmplist = "" # close the file
                    delete("@"//rcflout1, ver-, >& "dev$null")
                    delete(rcflout1, ver-, >& "dev$null")
                   }       # this brace is from if block (delfl)
         
                goto jumplab   # jump to just before the brace of while 
                               # block
            } # this brace is from if block (stoprc == yes)
	    
  
  # If processing standard stars, not assemble into chip -- standard1 == yes
  #   if transpose == WHT or INT, run chiptrans, if not, not anything
  # Assemble quadrant-images into chip-images -- runing cmkchip 

      if ((fieldid == "a") || (fieldid == "c"))
        {
        if (preass==0)
          {
          print("")
          print("", >> cndrproclog)

           list = ""; time | scan(list)
           print("Starting to assemble quadrants: ",list, >> cndrproclog)
           # print("Starting to assemble quadrants: ",list)
           # print("") 
	   list = ""

          print("Assembling quadrants ...")
          print("Assembling quadrants ...", >> cndrproclog)
          # print("")
          }
	  
        # rcflout1 is a list of fold lists output filename,   
        # make a filename containing the output foldlist from cmkchip
          
	  if ((transpose1 == "WHT") || (transpose1 == "INT"))
             cobjin = "ta"//rcflout1
          else
             cobjin = "a"//rcflout1

          if (access(cobjin))
             delete(cobjin, ver-, >& "dev$null")

          # print("Input list: ", rcflout1)
          # print("Output list: ", cobjin)

              templog = "cmkchip.log"
              unlearn cmkchip
              if (preass1==no) cmkchip("@"//rcflout1, transpose1, doscaleq1, doass=yes)
              else if (preass1) cmkchip("@"//rcflout1, transpose1, doscaleq1, doass=no)
              unlearn type
              type (templog, >> cndrproclog)

        } # this brace is from if block (fieldid == a or c)
      else  if (fieldid == "q")
      
       {  # processing quad-images (not assemble quad-images to chip-images)
          print("")
          print("", >> cndrproclog)

           # print("")
           list = ""; time | scan(list)
           print("Starting to process quadrants: ",list, >> cndrproclog)
           # print("Starting to process quadrants: ",list)
           # print("")
	   list = ""

          print("Processing quadrant images ...")
          print("Processing quadrant images ...", >> cndrproclog)
          # print("")

        # rcflout1 is a list of fold lists output filename,   
        # make a filename containing the output foldlist from cmkchip
          if ((transpose1 == "WHT") || (transpose1 == "INT"))
            {
              cobjin = "tq"//rcflout1
              # print("Input list: ", rcflout1)
              # print("Output list: ", cobjin)

              if (access(cobjin))
                  delete(cobjin, ver-, >& "dev$null")
    
              templog = "chiptrans.log"
              unlearn cqtrans
              cqtrans("@"//rcflout1, transpose1)
              unlearn type
              type (templog, >> cndrproclog)

            } # this brace is from if block (telescope1 == wht or int)
          else
            {
              cobjin = "q"//rcflout1

              if (access(cobjin))
                   delete(cobjin, ver-, >& "dev$null")
        
              copy(rcflout1, cobjin, ver+, >> cndrproclog)

            } # this brace is from if-else (telescope1 == none)
          
       } # this brace is from if-else (fieldid == "q")


         # cleaning previous output (from cmkimg)
           if (delfl1)
             {
               tmplist = ""; tmplist = rcflout1
               while( fscan(tmplist, tmpfile) != EOF)
                  delete("@"//tmpfile, ver-, >& "dev$null")
      
               tmplist = "" # close the file
               delete("@"//rcflout1, ver-, >& "dev$null")
               delete(rcflout1, ver-, >& "dev$null")
             }       # this brace is from if block (delfl)
          

         stopass1=no
	 if (stopass1)
            goto jumplab    #jump to the end of the while block (jumplab)

    # Performing the dark correction if (darkcorr == yes)
          if (darkcorr1 == yes)
            {
 
              print("")
              list = ""; time | scan(list)
              print("Starting dark correction: ",list, >> cndrproclog)
              # print("Starting dark correction: ",list)
              # print("")
	      list = ""

              # print("")
              print("", >> cndrproclog)
              print("Performing dark subtraction ...")
              print("Performing dark subtraction ...",
                    >> cndrproclog)
              # print("")
   
              s1 = "" #clear the field
              tmpout = ""; tmpout = "d"//cobjin
              if (access(tmpout))
                  delete(tmpout, ver-, >& "dev$null")

              tmplist = ""; tmplist = cobjin
              while(fscan(tmplist, s1) !=EOF)
                {
                  unlearn csubqdark
                  csubqdark("@"//s1, "@"//darklist1, scalfac1)
                  templog = "csubqdark.log"
                  unlearn type
                  type(templog, >> cndrproclog)
                  print("d"//s1, >> tmpout) # producing a list of lists darks
                  etimechk = csubqdark.expcheck
                  if (etimechk == "B")
                      bye     #exit the program -- no exptime available

                  if (delfl1)
                    {  #cleaning the previous result
                      delete("@"//s1, ver-, >& "dev$null")
                      delete(s1, ver-, >& "dev$null")
                    } #this brace is from if-block (delfl1 == yes)
                } # this brace is from while-block (tmplist = cobjin)
              tmplist = "" # close the file
              s1 = "" #empty the field 

              delete(cobjin, ver-, >& "dev$null")
              cobjin = tmpout

            } #this brace is from if-block (darcorr == yes)

	    print (cobjin, >> skylist)
	    
         # need to prepare the input file for next task -- cmkqobj
         # cassfile1: containing imagenames -- e.g. nr1329_rc0502_1p
         # cobjin: containing foldlist -- e.g. tarc_r1329.in


          # Coadd the chip-images -- runing cmkqobj
   
          print("")
          print("", >> cndrproclog)
          print("Co-adding the folds ...")
          print("Co-adding the folds ...", >> cndrproclog)
	  
	  # Need to produce output file containing output coadded imagenames
          objfile1 = "ca_"//cobjin
          templog = "cmkqobj.log"
          unlearn cmkqobj
          cmkqobj("@"//cobjin, objfile1, objstfold1, endfold1, osetfile1, usrobjopt1)
 
          unlearn type
          type(templog, >> cndrproclog)

         print("", >> cndrproclog)
         # print("************************************************************")
         # print("*********************************************", >> cndrproclog)
	   
         # making list of dithering lists of coadded object images for
         #   substracting sky background

         print(objfile1, >> objflist)

         jumplab:     # jump from an option (stoprc or stopass)
       } # this brace is from while fold (rnolist, runno1)
         rnolist = "" # close the file
        
         delete(rnofile1, ver-, >& "dev$null")

   # Exit the program if (stoprc or stopass == yes)
         if ((stoprc1) || (stopass1))
           {
              print("")
              list = ""; time | scan(list)
              print("Finished all tasks: ",list, >> cndrproclog)
              print("Finished all tasks: ",list)
              print("")
              print("CNDRPROC done.")
	      print ("")
              bye
           }

   # try to obtain the total number of chip from tquad1

       if (fieldid == "a")  #using all the data from PIXEL
          {
            if (mod(tquad1,4) == 0) 
              tchip1 = tquad1/4
            else
              tchip1 = int(tquad1/4) + 1
          } 
       else if (fieldid == "c") #using one-chip data only
              tchip1 = 1
       else if (fieldid == "q")  #using one-quadrant data only
              tchip1 = 1
       else 
        {
           print("")
           print("No information as to which quadrant number (quadnos) to use!")
           print(" You have 3 choices:")
           print("  1: Produce filename for all 16 quadrants -- all")
           print("  2: Produce filename for a single chip -- c1|c2|c3|c4")
           print("  3: Produce filename for a single quadrant -- q1|q2| .. |q14|q15|q16")
           print(" Exiting ...")
           print("")
           bye
        } # this brace is from if-block field != a,c,q

  # Now we are ready to make the skyimage if we choose this option
      if (skyfile1 != "none")
        {
          print("")
          list = ""; time | scan(list)
          print("Starting to make sky images: ",list, >> cndrproclog)
          # print("Starting to make sky images: ",list)
          # print("")

          if (strlen(str(rc1))==1)
          	{
                s1="0"//str(rc1)
                }
          else s1=str(rc1)    
          if (strlen(str(rc2))==1)
          	{
                s2="0"//str(rc2)
                }
          else s2=str(rc2)    
	  
	  # now create a unique sky image name!

	  head (runnolist, nlines=1) | scan (srno1)
	  tail (runnolist, nlines=1) | scan (srno2)
	  
	  if (srno1==srno2)
	  	print ("How do you want to perform sky subtraction with just one image??")		

	  s3="sky_"//srno1//"-"//srno2//"_rc"//s2//s1//"_c"
	  
          templog = "cdossky.log"
          unlearn cdossky
	  
	  cdossky(skylist, objflist, prefiximg1, s3, skyfile1, skystfold1,
              tchip1, subsky1, usrskyopt1, usebpm1)
          unlearn type
          type(templog, >> cndrproclog)

          if (!subsky1)
            {
             # print("")
             print("Example input files for sky subtraction (CDOSSKY) :")
             print("  List of output sky frames: ", skylist)
             print("  Input list: ", objflist)
             # print("") 
             print("")
             list = ""; time | scan(list)
             print("Finished all tasks: ",list, >> cndrproclog)
             print("Finished all tasks: ",list)
             print("")
             
             print("CNDRPROC done.")
	     print ("")
             bye
           } #this brace is from substracting sky background

         # cleaning previous results -- output images from cmkchip 
          if (delfl1)
           {
               tmplist = ""; tmplist = skylist # open file skylist
               while( fscan(tmplist, tmpfile) != EOF)
                 {
                   tmplist2 = ""; tmplist2 = tmpfile # open file cobjin
                   while( fscan(tmplist2, tmpfile2) != EOF)
                      delete("@"//tmpfile2, ver-, >& "dev$null")
      
                   tmplist2 = "" # close the file tmpfile
                   delete("@"//tmpfile, ver-, >& "dev$null")
                   delete(tmpfile, ver-, >& "dev$null")
                 } # this brace is from while fold (tmplist, tempfile)

               tmplist = ""   # close the file skylist
               delete(skylist, ver-, >& "dev$null")
             }       # this brace is from if block (delfl)
        }  # this brace is from if block (skyfile1 != none)
     else
        {
           print("")
           print("Example input files for sky subtraction (CDOSSKY) :")
           print("  List of output sky frames: ", skylist)
           print("  Input list: ", objflist)
           # print("")
        } # this brace is from if else block (non-skysubtractiion case)

   # Exit the program if (skyfile1 = none || flatcorr == yes)
         if ((skyfile1 ==  "none") && (flatcorr1))
            {
              print("")
              print("Sky subtraction must be done before flat-fielding!")
              print("")
              list = ""; time | scan(list)
              print("Finished all tasks: ", list, >> cndrproclog)
              print("Finished all tasks: ", list)
              print("")

              print("CNDRPROC done.")
	      print ("")
              bye
           }

  #  Performing  flat-fielding correction
       if (flatcorr1)
         {
            print("")
            list = ""; time | scan(list)
            print("Starting flat-field correction: ", list, >> cndrproclog)
            # print("Starting flat-field correction: ", list)
            # print("")

            # print("")
            print("", >> cndrproclog)
            print("Performing flat-field correction ...")
            print("Performing flat-field correction ...",
              >> cndrproclog)
            # print("")
            tmpout = "" # clean the variable
            tmpout = "s"//prefiximg1//"_chip.in"   #output listfile from 
                                             #skysubtraction
                                 #sm51_chip.in (sm51_c01.in,..., sm51_c04.in)
            templog = "cqflatcor.log"
            unlearn cqflatcor
            cqflatcor("@"//tmpout, "@"//flatlist1)
            unlearn type
            type (templog, >> cndrproclog)

           
	   delskyfl1=no
	   
	   if (delskyfl1)
             { #cleaning the sky-subtacted images
               s1 = "" #clean the field
               tmplist = ""; tmplist = tmpout
               while (fscan(tmplist, s1) !=EOF)
                    delete("@"//s1, ver-, >& "dev$null")

               tmplist = "" #close the file
               delete("@"//tmpout, ver-, >& "dev$null")
               delete(tmpout, ver-, >& "dev$null")
             } # this brace is from sky-subtracted images
           
         } # this brace is from if-block (flatcorr1 == yes)
  #  Final cleaning up
        
	# deleting useless files (could delete a whole lot more junk actually)
	# the _1p chip images seem to be identical to the ones without the _1p
	# - well when we are only working with 1 fold anyway
	
	if (tfold1==1)
	   {
	   print ("")
	   print ("Only 1 fold, so deleting _1p images ...")
	   delete("*_*_c?_rc????_1p.fits", ver-, >& "dev$null")
	   }
	
	delete("dummy*", ver-, >& "dev$null")
	delete(runnolist, ver-, >& "dev$null")


          # print("")
          list = ""; time | scan(list)
          print("Finished all tasks: ", list, >> cndrproclog)
          # print("Finished all tasks: ", list)
          print("")

        print ("CNDRPROC done.")
	beep
	print ("")

end


