# IRAF script -- cmkqobj.cl
#	
#   function:  to make the quad-object
#               input: from the output of ccmkimg (non-offset case)
#                      from the output of ccqcent (offset case)
#               output: prehead: "obj_q" (default)
#
# programmer: sjchan (nov 97)
#               history: nov97 -- created
#                         19mar97 -- modified; produce output image name
#                                       from input image name
#                           for non-offset option:
#                              oset_file = "none"
#                    (produce oset_file containing "none" inside the program)
#
#   status: non-offset option -- tested
#           offset option -- need data  to test !!!!
#        

procedure cmkqobj(file_in, file_out, start_fold, end_fold, oset_file, useropt)

string	file_in   {"",prompt="(@List/*.fits or .imh) of Input quad-object images",mode="ql"}
string  file_out  {"",prompt="File name containing output object list", mode="ql"}
string  start_fold {"2", prompt="The start #th fold for combination", mode="ql"}
string  end_fold {"0", prompt="The end fold number for combination (0:general case)", mode="ql"}
string oset_file {"obj.sh", prompt="The list of offset file names (obj.sh/none)", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkobjpar {prompt="Imcombine parameters to make coadded-fold images"}

struct  *filist1, *filist2
struct  *tilist

begin
        string  ftmpi       #i input file list
        string  fileout     #o a file containing  output object filenames
        string  ifile       #i the final version of input file 
        string  filein      #i the input list of list individual object 
                              #(non-offset option)
        string  quadin      #i input image
        string  frameout    #o output object name
        string  cmkqobjlog   #o logfile
        string  prehead     # prehead of the output object files (bad case)
        string  startfold  #i the start fold-th for combination 
        string  endfold    #i the end fold for combination
        string  osetfile   #i the list of offset file names
        string  osetfin    #i the offset file name
                             # non-offset option: none
        bool    useropt1   # User option to input IMCOMBINE parameters
        int     ic          # counters
        int     leni       # length of input file list string
        string  ext        # dummy variable (extension of the output darks)
        string  templog    # dummy variable (temporary logfile)
        string  quadimg    # input quadrant(chip) image name in the input list
        int     icc        # dummy counter
        int     loc1       # location of the last "_" in the input image name
        string  snone      # dummy counter ("none") in string
        int     inone      # dummy counter ("none") in integer
        string  nosetfile  # dummy non-offset filename containing "none"
        int     i

      #  Get the rest of the parameters

        ftmpi = file_in
        fileout = file_out
        startfold = start_fold
        endfold = end_fold
        osetfile = oset_file
        useropt1 = useropt
        prehead = "obj_c"
        cmkqobjlog = "cmkqobj.log"
        templog = "cmkobj.log"
        filein = "quadlist.in"
        ext = ".fits"

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

     # Check existence of output files

        if (access(cmkqobjlog))
           delete(cmkqobjlog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

      # Make quad input lists, the output file called "quadlist.in" which
      #  contains the list of quad_file names. Each quad_file contains
      #  list of fold files for quad#.  (non-offset option)

       if (osetfile == "none")
         {
           _mkqlist(ifile)   # for non-offset option

          # Make the input offset file for non-offset option
           count(filein) | scan (snone)
           nosetfile = mktemp("noset")
            if (access(nosetfile))
                delete(nosetfile, ver-, >& "dev$null")
            inone = int(snone)
            for (i = 1; i <= inone; i += 1)
               print("none", >> nosetfile)

               filist2 = nosetfile
          } # this brace is from if block (osetfiile = none)
         else
           filist2 = osetfile


      # Read the list of input object list filename
        ic = 0
        filist1 = ""
        if (osetfile == "none")
           filist1 = filein    # filein = quadlist.in  # non-offset case
         else
           filist1 = ifile    # offset case:


        while ( (fscan(filist1, quadin) != EOF) && 
                (fscan(filist2, osetfin) !=EOF) )
         {
           ic += 1
      # Make the output object names and put them into a list 
              icc = 0
              tilist = ""; tilist = quadin
              while(fscan(tilist, quadimg) != EOF)
                {
                  icc += 1
                  if (icc == 1)
                    {
                      _locchar(quadimg, "_", 1)
                      loc1 = _locchar.charloc
                      if (loc1 > 0)
                         frameout = substr(quadimg, 1, loc1-1)//ext
                       else
                         frameout = prehead//str(ic)//ext
                    }
                  tilist = "" # close the file
                  break
                } # this brace is from while block (tilist, quadimg)
                print (frameout, >> fileout)
                print("", >> cmkqobjlog)
                print("Chip or Quad: ", ic, >> cmkqobjlog )
                # print("")
                print("Chip or quadrant: ", ic)
                cmkobj("@"//quadin, frameout, startfold, endfold, osetfin, useropt1)
                unlearn type
                type (templog, >> cmkqobjlog)
                print("=========================================", >> cmkqobjlog)
               
         }   # this brace is from while (filist1, quadin) and (filist2, osetfin)

         # close the files and cleaning up
           filist1 = "" ; filist2 = ""
           delete("@"//filein, ver-, >& "dev$null")
           delete(filein, ver-, >& "dev$null")
           if (osetfile == "none")
             {
              delete(nosetfile, ver-, >& "dev$null")
              if (stridx(ftmpi, "@") != 1)
                 delete(ifile, ver-, >& "dev$null")
             }

	  print ("CMKQOBJ done.")

end

