# IRAF script -- cmkqdark.cl
#	
#   function:  to make the quad-darks
#               input: from the output of cmkimg or cassquad(cmkchip)
#               output: prehead: "dark_q"
#
# programmer: sjchan (nov 97)
#   history: nov97 -- created cmkqdark.cl
#            23jan98 -- rename to cmkqdark.cl
#            28may98 -- add a required parameter: prehead
#            2july98 -- add a scaling factor (make normalized darks)
#        

procedure cmkqdark(file_in, file_out, pre_head, startfold, scalfac, useropt)

string	file_in   {"",prompt="(@List of lists) of Input dark images (chip or quads)",mode="ql"}
string  file_out  {"",prompt="File name containing output dark frame", mode="ql"}
string  pre_head  {"prefix_c", prompt="The prefix of the output dark frames", mode="ql"}
int     startfold   {1, prompt="The start #th fold for combination", mode="ql"}
bool    scalfac   {yes, prompt="Make nomalized dark frames", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkdarkpar {prompt="Imcombine parameters to make dark images"}
string  expcheck  {"Check exposure time in the header"}

struct  *filist

begin
        string  ftmpi       #i input file list
        string  fileout     #o a file containing  output dark filenames
        string  ifile       #i the final version of input file 
        string  filein      #i the input list of list individual dark
        string  quadin      #i input image
        string  frameout    #o output darks name
        string  cmkqdarklog   #o logfile
        string  prehead     # prehead of the output dark files
        int     startfold1  #i the start fold-th for combination 
        bool    scalfac1    #i make normalized darks? (default: yes)
        bool    useropt1   # User option to input IMCOMBINE parameters
        int     ic, ic2     # counters
        int     leni       # length of input file list string
        string  ext        # dummy variable (extension of the output darks)
        string  templog    # dummy variable (temporary logfile)
        string  tmpcheck   # the exposure time indicator passing from CMKDARK

      #  Get the rest of the parameters

        ftmpi = file_in
        fileout = file_out
        prehead    = pre_head
        startfold1 = startfold
#        prehead = "dark_q"
        scalfac1 = scalfac
        useropt1 = useropt
        cmkqdarklog = "cmkqdark.log"
        templog = "cmkdark.log"
        filein = "quadlist.in"
        ext = ".fits"
        tmpcheck = "G" #default
        expcheck = "G" #default

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

     # Check existence of output files

        if (access(cmkqdarklog))
           delete(cmkqdarklog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

      # Make quad input lists, the output file called "quadlist.in" which
      #  contains the list of quad_file names. Each quad_file contains
      #  list of fold files for quad#. 

        _mkqlist(ifile)

      # Read the list of input dark list filename
        ic = 0; ic2 = 0
        filist = ""
        filist = filein    # filein = quadlist.in
        while ( (fscan(filist, quadin) != EOF))
         {
           ic += 1
      # Make the output dark names and put them into a list 
              frameout = prehead//str(ic)//ext
              print (frameout, >> fileout)

        # Check the existence of the file "frameout"
              if (access(frameout))
                 delete(frameout, ver-, >& "dev$null")

               print("")
               print("Chip or Quad ", ic)
               print("Output dark image: ", frameout)

                print("", >> cmkqdarklog)
                print("Chip or Quad ", ic, >> cmkqdarklog )
                unlearn cmkdark
                cmkdark("@"//quadin, frameout, scalfac1, startfold1, useropt1)
                tmpcheck = cmkdark.check

                if (tmpcheck == "B")
                  {
                    filist = "" #close the file before exit the program
                    if (stridx(ftmpi, "@") != 1)
                        delete(ifile, ver-, >& "dev$null")     

                    expcheck = "B" # exit indicator
                    bye  
                  } #this brace is from if-block (tmpcheck = B)
                unlearn type
                type (templog, >> cmkqdarklog)
                print("=========================================", >> cmkqdarklog)

         }    # this brace is from while (filist, quadin)

         # close the files and cleaning up
           filist = ""   
           if (stridx(ftmpi, "@") != 1)
             delete(ifile, ver-, >& "dev$null")

          print("   << ========= CMKQDARK DONE =========== >>")
          beep; beep; beep

end

