# IRAF script -- cmkimg.cl
#	
#   function:  to make RC images providing a set of NDR images and a pair
#                of NDR number
#                 
#
# programmer: sjchan 
#    history:  jan98 -- created at the WHT
#            12feb98 -- delete the print statement - rc*_?p (now rc*_?f)
#                       use _locruno(framein) to locate runno, make all the
#                       file name unique
#                       (modify _mknout.cl)
#             15apr98 -- modify: NOT to use IMGETS to get the "nfolds"
#                          from the headers because the meaning 
#                           is different. It will be turned on again until
#                           the meaning of "nfolds" is clear
#             29apr98 -- modify: fix a small undiscovered bug
#                          put get information from header in a RIGHT place
#                          change nfold --> nfold
#             8june98 -- modify: using new option; cstripe
#                           (always using default: rccor == yes)
#             1july98 -- modified: calculate the "real exposure time" and
#                           put in the header
#             15july98 -- modified: replace _mkldlist.cl to _findrcfl.cl
#                           (only the produce the range1, range2 filelist)
#                           _mknout.cl will not be used anymore
#             16july98 -- modified: using the new version of cstripe with
#                          pixtype as input parameter
#                          
#             6aug98 -- modified: using the new version of cstipe without
#                          pixtype as input parameter (using fdrift)
#
#             25mar99 -- mhoenig: added option to not actually do the reset
#			  subtraction, as is needed for pre-reset-corrected data.
#			  I tried to put 'if' brackets around as small a part of the
#			  program as possible: only the actual imarith gets taken
#			  out of the equation. The files are renamed as they would
#			  be after the imarith task. Hence the other stuff like
#			  determining the exposure time for example, is still
#			  preserved and not broken. Which is quite cool I think!
#	      april99 --  minor changes (mainly "if" statements) to allow for
#		 	  preass'd data.
#	     23june99 --  changed drift options
#


procedure cmkimg(ndrfl_in, rcflout, range1, range2, tquad, head, tot_fold, tndr,stripe,  pix_type, calc_type, answer)

string	ndrfl_in {"",prompt="Input images (wildcards or @list)",mode="ql"}
string  rcflout  {"rc_inputfilename", prompt="Output list containing fold output filenames", mode="ql"}
int     range1   {1, prompt="Lower read no. in pair", mode="ql"}
int     range2   {4, prompt="Upper read no. in pair", mode="ql"}
bool    head     {yes, prompt="Get totndr from header?", mode="ql"}
int     tndr     {4, prompt="Total number of NDRs per fold (if not using header)", mode="ql"}
int     tot_fold {1, prompt="Total number of folds",mode="ql"}
int     tquad    {16, prompt="Total number of quadrants", mode="ql"}
string  stripe	 {"fd", prompt="Stripe correction algorithm to use? (fd|dB|dR|dC|B|R|C|no)", mode="ql"}
string  pix_type {"short", prompt="pixtype of output images", enum="short|ushort|integer|long|real|double", mode="ql"}
string  calc_type {"short", prompt="calctype for IMARITH operation", enum="short|ushort|integer|long|real|double", mode="ql"}
bool    answer   {yes, prompt="Sort the input list?", mode="ql"}
bool	dorc	 {yes, prompt="Actually perform reset subtraction?"}

struct  *lilist
struct  *nilist
struct  *ndrlist, *foldlist


begin
        string  ftmpi      # input file list
        int     foldnum    # total number of folds for a fixed-pos observation
        int     totndr2    # total number of NDR per fold
        int     totquad2   # total number of quad per fold
        string  ofile     # a file containing fold output filenames
        string  ifile     # the final version of input file list
        string  foldin    # a file containing fold input filenames
        string  ndrflin     # input file list containing input image per fold
        string  ndrflout  # output file list containing 
                              #output images (non-destriping option)
        string  sndrflout # output file list containing output images 
                              #(destrping option)
        string  flin        # input file fold list
        string  tndrflin[2] # dummy variables
        string  cmkimglog  # logfile
        int     ic          # dummy counters
        int     ifold       # fold counter
        int     leni       # length of input file list string
        bool    answer1    # ask sort the input list
        bool    rccor1     # ask whether this is a reset-corrected image
        bool    head1      # ask for getting information from header
        string  stripe1    # destriping correction option
        string  ind        # indicator
        string  pixty      # pixtype of output images
        string  calcty     # calcuating type for IMARITH
        string  ndrfl      # dummy variable
        string  foldinfl   # dummy variable
        string  flcheck    # number of file indicator
        string  dcheck     # dummy variable (check header information)
        string  timg       # 1st image file in the list (ifile)
        int     rg1, rg2   # RC pair (range1, range2)
        int     i4
        string  ss1, ss2, srg   # dummy variables
        string  sifold     # ifold in string 
        string  base       # prefix of basenm
        string  basenm
        string  snruno    # run number in string
        string  tmplog     # logfile of CSTRIPE  
        string  tmplog2    # logfile of _getexptime
        string  timecheck  # exposure time indicator
        string  s2
	bool 	dorc1

      #  Get the rest of the parameters

        ftmpi = ndrfl_in
        ofile = rcflout
        rg1 = range1
        rg2 = range2
        totquad2 = tquad
        head1 = head
        foldnum=tot_fold
        totndr2 = tndr
        stripe1 = stripe
        pixty = pix_type
        calcty = calc_type
        answer1 = answer
        rccor1  = yes   # always using default (reset-corrected image)
        foldin = mktemp("foldin")
        cmkimglog = "cmkimg.log"
        tmplog = "cstripe.log"
        tmplog2 = "getexptime.log"
        ind = "RC"   # Reset correction
        base = "rc"
        dcheck = ""
        timecheck = ""
        dorc1 = dorc
	
        cache imgets     # need this action due to a bug in imgets
        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
          {
           ifile = substr(ftmpi, 2, leni)
           if (ofile == "")
               ofile = "rc_"//ifile
          }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           if (ofile == "")
               ofile = "rc_ofold.in"   
         }
	 

     # Check existence of output files

        if (access(ofile))
          delete(ofile, ver-, >& "dev$null") 
        if (access(cmkimglog))
          delete(cmkimglog, ver-, >& "dev$null")
        if (access(tmplog))
          delete(tmplog, ver-, >& "dev$null")
        if (access(tmplog2))
          delete(tmplog2, ver-, >& "dev$null")


      # Sort the input file list (increaing order in sequence number)
      #  if user wishes (if no: the input file has been SORTED
        if (answer1)
            _finsort(ifile)
      
      # Get information from header; get the header information from
      #  from the first image

            lilist = ""; lilist = ifile
            while(fscan(lilist, timg) !=EOF)
              {# need to turn off because the meaning of "nfolds" is different
                #imgets(timg, param="nfolds")
                #dcheck = imgets.value
                #if ((dcheck == "") || (dcheck == "0") || (dcheck == "/"))
                # {
                #   print("NFOLDS value is BAD in the header!")
                #   bye
                # }
                #else
                #   foldnum = int(dcheck)
                if (head1)
                  {
                    imgets(timg, param="totalndr")
                     dcheck = imgets.value
		     # print("dcheck_totalndr: ", dcheck)
                    if ((dcheck == "") || (dcheck == "0") || (dcheck == "/"))
                      {
                         print("Bad TOTALNDR value in header!")
                         bye
                       }
                     else
                       totndr2 = int(dcheck)   
                   } # this brace is from if block (head1)

                _locrnonew(timg)
                snruno = _locrnonew.srunno
                break   # go out while fold
              }   # this brace is from while fold (ifile, timg)
            lilist = ""  # close the file

       # print("runno: ", snruno)
       # print("totfold: ", foldnum)
       print("Total no. of NDRs is "//totndr2//".")

       if (cndrproc.preass==1) totquad2=totquad2/4
       
      # Make fold input file lists and fold output file lists
        unlearn _findrcfl
        _findrcfl(ifile, totndr2, totquad2, rg1, rg2, foldnum, foldin, ofile) 
        flcheck = _findrcfl.f_flag
        if (flcheck == "B")
           bye

      # Read the list of input list  and the list of output list

        ifold = 0 
        lilist = ""; lilist = foldin
        while ( (fscan(lilist, flin) !=EOF))
         {    # flin = infold#      
           ifold += 1
           sifold = str(ifold)
           # print ("Fold: ", ifold)
           print("==========================================", >> cmkimglog)
           print("", >> cmkimglog)
           print("Fold: ", ifold, >> cmkimglog)

     # Read contents of infold# (only contains 2 sets of files)
            ic = 0
            nilist = ""; nilist = flin
            while ((fscan(nilist, ndrflin) != EOF))
             {   # ndrflin = ndr0i_#p: contains image files
               ic += 1
               tndrflin[ic] = ndrflin

             }   # this brace is from while fold (nilist, ndrflin)
           nilist = "" #close the file

      #Read contents of ofile (rc_rxxxx.in) 1
           nilist = ""; nilist = ofile #list of lists of lists of outfold#
           while(fscan(nilist, s2) != EOF)  #s2= outfold# -2
            {
              foldlist=""; foldlist = s2
              while(fscan(foldlist, ndrflout) !=EOF) #ndrflout = rc0401_1p
                {
                  sndrflout = "n"//ndrflout   
 
                  ndrlist = ""; ndrlist = ndrflout #rc0401_1p -
                  while(fscan(ndrlist, ndrfl) != EOF) 
                   {       
                     if (access(ndrfl))  # images -4
                        delete(ndrfl, ver-, >& "dev$null")    
                   }   
                  ndrlist = ""  # close the file
                } #this brace is from whle block (foldlist, ndrflout)
              foldlist = "" # close the file

              delete(s2, ver-, >& "dev$null")
            } #this brace is from while block (nilist, ofile)
            nilist = "" #close the file

             delete(ofile, ver-, >& "dev$null")

             print("", >> cmkimg)
             print("RC pairs: ", rg2,"and ",rg1, >> cmkimg)
             print("Reset-correcting: read "//rg2//" - read "//rg1)


                 # Provide the real signal image and update the header     
                 
		 # now do subtraction - well only if we really want to!

		 if (dorc1)
		 {		 
		   unlearn imarith
                   imarith(operand1="@"//tndrflin[2], op="-", 
                       operand2="@"//tndrflin[1],
                       result="@"//ndrflout,  pixtype=pixty, calctype=calcty,
                       verbose=yes, >> cmkimglog)
              	 }
		 else if (dorc1==0)
		 # ie. we don't actually want to reset-subtract, eg. when images
		 # already are reset-corrected out of Pixcel)
		 {
		   print (" Data is already reset-corrected; so reset subtraction will not be performed.\n However, for the sake of consistency and simplicity,\n the images will now be renamed in the usual \"rc0X0Y\" format.")
		   print ("User has chosen not to actually perform reset subtraction.\nThis is usually done when the images already come out of Pixcel reset-corrected.\nFor the sake of consistency and simplicity,\n the images will now be renamed in the usual \"rc0X0Y\" format.", >> cmkimglog)
		   imcopy ("@"//tndrflin[2], "@"//ndrflout, verbose=yes, >> cmkimglog)
		 }  
		 
                 # get the time stamp from the header and then estimate the
                 # the real exposure time, update header

                   unlearn _getexptime
                   _getexptime(tndrflin[2],tndrflin[1],ndrflout)

                 # delete the temporary input files
                   delete(tndrflin[2], ver-, >& "dev$null")
                   delete(tndrflin[1], ver-, >& "dev$null")
  
                   unlearn type
                   type(tmplog2, >> cmkimglog)
                   
                   hedit("@"//ndrflout, field="fold", value=ifold, add+, del-, 
                      ver-, update+, show-)
                   hedit("@"//ndrflout, field="rcflag", 
                      value=ind, add+, del-, ver-, update+, show-)

                # Perform destriping option
                 # B - descriping rows and columns
                 # R - descriping only rows
                 # C - descriping only columns
                 # NO - non-descriping

                if ( (stripe1 == "B")||(stripe1 == "R")||(stripe1 == "C")||
                     (stripe1 == "fd")||(stripe1 == "dB")||(stripe1 == "dR")||(stripe1 == "dC") )
                   {
                     cstripe("@"//ndrflout, stripe1)
                     unlearn type
                     type(tmplog, >> cmkimglog)
                     print(sndrflout, >> ofile) 
                   }  # this brace is from if block (destriping option)
                else
                     print(ndrflout, >> ofile)

        }    # this brace is from while fold (lilist)
         
         # close the files and cleaning up
           lilist = ""

          if (access(foldin))
           {
             # delete infold* files which are created from _mkldist.cl
             lilist = ""; lilist=foldin
             while(fscan(lilist, foldinfl) != EOF)
                delete(foldinfl, ver-)    

             lilist = ""   # close the file
             delete(foldin, ver-) 
            }


	  print ("CMKIMG done.")

end

