# IRAF script -- cirdither.cl
# 
# function: to mosaic a list of images in a given dithering pattern 
#           (small pattern only), only to mark the position of reference points
#
#	
# programmers: sjchan 
#           created: 29april98
#           modified: 5may98 -- make an input file which containing
#                                the approximated offset values
#                     6may98 -- using app-offset file (asec only) if no
#                                  header information
#                     13aug98 -- add an option to let user have a chance to 
#                                 choose one's values of IMCOMBINE parameters
#		     23april99 - mhoenig: slightly reworded output, changed
#				  epar prompts
#

procedure cirdither (listimg)

string  listimg   {"",prompt="@list of images in the dither sequence",mode="ql"}
string  offsetfl  {"offset.dit", prompt="Name of offset file", mode="ql"}
string  imgout    {"none",prompt="Name of output image", mode="ql"}
string  pixunit   {"WHT", prompt="Pixel unit to use (WHT/INT/pix)", mode="ql"}
string aoffasfl   {"none", prompt="Input offset file (only when not using header info)", mode="ql"}
bool    answer    {no, prompt="Final version of offset file?", mode="ql"}
int     boxrad    {5, prompt= "Size of search box"}
bool    useropt   {no, prompt="Change default IMCOMBINE parameters?"}
pset    mkmospar  {prompt="User-edited IMCOMBINE parameters"}


struct *filist, *slist
struct *clist1, *clist2


begin

        # Local variable declarations
        string  listimg1     #i list of image images 
        string  ashiftfl1    #i approximated offset file 
                               #(offset w.r.t. the 1st image (pixel and asec)
        string  offsetfl1      #o final output offset file
        string  imgout1      #o output mosaic image
        string  pixunit1         #i pixel unit to be used
        string  aoffasfl1    #o app-offset file (asec only)
        int     boxrad1      # radius of the search box
        bool    useropt1   # User option to input IMCOMBINE parameters
        string  framein      #i individual input image 
        string  cirditherlog     #o logfile
        string  ind           # indicator
        string  ifile, ofile  # final version of input and output list
        string  cenout        # file containing center of objects
        string  cenref,cen2     # dummy variables for 2 given pair frames
        string  cenfile       # final output file containing the center 
                              # values of objects   
        string  coordfl       # parameter for  task _circendit ( Input
                              #  coordinates of objects)
        int     leni         # dummy variable
        int     icount, ncount   # dummy variables (counters)
        int     naxis        # the length of axis of image
        real xref, yref      # reference point location
        real x2, y2          # dummy variables (object location)
        real x2new, y2new    # final version of object location
        real tot_xioffas, tot_yioffas #i input offset  w.r.t. ref. pt (asec)
        real tot_xfoffpx, tot_yfoffpx #o output offset w.r.t. ref. pt (asec)
        real  xmin, xmax     # the x-size of the mosaiced frame
        real  ymin, ymax     # the y-size of the mosaiced frame
        string sx1, sy1, sx2, sy2 # display size of the refimage in string
        real   xd1, yd1, xd2, yd2 # display size of the refimage in real
        string framein1      # the displayed first image with section
        string sec           # the section to be displayed
        real  pixelscale     # the pixelscale (dummy variable)
        string ss1           # dummy counter (ncount in string)
        real tot_xoffpx, tot_yoffpx #tot_xioffas, tot_yioffas in pixel
        string dispframein1  # the display framein for marking
        real xoffbet, yoffbet   # xoff, yoff w.r.t. the previous pos (in pix)
        real x1, y1          # object position in previous frame
        real tot_xoffpxp, tot_yoffpxp  # object offset inn previous frame
        bool answer1         # providing final version offset (default: no)
        string mscale1       # Multiplicative image scaling to be applied 
                                # in IMCOMBINE (useropt == no case)
        string mzero1        # zero level scaling to be applied in IMCOMBINE
                              # (useropt == no case)
        string s1, s2

       # IMCOMINBE parameters (user choose)
         string p_sigma, p_plfile, p_combine, p_reject, p_offsets, p_masktyp
         string p_scale, p_weight, p_statsec, p_expname, p_zero
         string p_rdnoise, p_gain
         real p_maskval, p_blank, p_lthresh, p_hthresh
         real p_lsigma, p_hsigma, p_pclip, p_sigscale
	 int  p_nlow, p_nhigh, p_nkeep, p_grow

        #  Get the rest of the positional parameters

        listimg1   = listimg
        offsetfl1  = offsetfl
        imgout1    = imgout
        pixunit1   = pixunit
        aoffasfl1  = aoffasfl
        answer1    = answer
        boxrad1    = boxrad
        useropt1   = useropt

        cirditherlog="cirdither.log"
        cenfile="cirdither.cen" # output file containing the center values 
                             # of objects
        ind="O"      # dummy definition
        ifile=mktemp("cirdifl")   # only need ifile
        ofile=mktemp("cirdofl")   # dummy definition
        cenout="dummy_cen"    # the file containing center of objects
        cenref = mktemp("cenref")
        cen2 = mktemp("cen2")
        coordfl="none"   # parameter for task _circendit (interactive case)
        sx1 = "1"; sy1 = "1"  #default
        sx2 = "1024"; sy2 = "1024"
        xref = 0.; yref= 0.
        x2 = xref; y2 = yref
        x2new = xref; y2new = yref
        dispframein1 = "tdispframe.fits"
        pixelscale = 1.0 # offset value has been transformed into pixel-coord
                          # in _dithead2fl.cl

        ashiftfl1 = mktemp("tcirdit")


        #IMCOMBINE parameters

        p_sigma  = mkmospar.m_sigma
        p_plfile = mkmospar.m_plfile
        p_combine = mkmospar.m_combine
        p_reject = mkmospar.m_reject
        p_masktyp = mkmospar.m_masktyp
        p_maskval = mkmospar.m_maskval
        p_blank = mkmospar.m_blank
        p_scale = mkmospar.m_scale
        p_zero = mkmospar.m_zero
        mscale1 = mkmospar.m_scale
        mzero1  = mkmospar.m_zero
        p_weight = mkmospar.m_weight
        p_statsec = mkmospar.m_statsec
        p_expname = mkmospar.m_expname
        p_lthresh = mkmospar.m_lthresh
        p_hthresh = mkmospar.m_hthresh
        p_nlow = mkmospar.m_nlow
        p_nhigh = mkmospar.m_nhigh
        p_nkeep = mkmospar.m_nkeep
        p_lsigma = mkmospar.m_lsigma
        p_hsigma = mkmospar.m_hsigma
        p_rdnoise = mkmospar.m_rdnoise
        p_gain = mkmospar.m_gain
        p_sigscale = mkmospar.m_sigscale
        p_pclip = mkmospar.m_pclip
        p_grow = mkmospar.m_grow

        # Check the existence of the files

        if (access(cirditherlog))
            delete (cirditherlog, ver-, >& "dev$null")
        if (access(ifile))
            delete (ifile, ver-, >& "dev$null")
        if (access(ofile))
            delete (ofile, ver-, >& "dev$null")
        if (access(cenref))
            delete (cenref, ver-, >& "dev$null")
        if (access(cen2))
            delete (cen2, ver-, >& "dev$null")
        if (access(cenfile))
            delete (cenfile, ver-, >& "dev$null")
        if (access(imgout1))
            imdelete (imgout1, ver-, >& "dev$null")
        if (access(dispframein1))
            imdelete (dispframein1, ver-, >& "dev$null")        
        if (access(ashiftfl1))
            delete (ashiftfl1, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(listimg1, ind, ifile, ofile)

        # Make a jump to non-interactive mode (providing an offset file 
           #  in pixel coordinate)

          if (answer1)
              goto nonint

          # read the file 'ifile' containing the names of files

          icount=0; ic=0

        if (access(offsetfl1))   # output offset file
             delete (offsetfl1, ver-, >& "dev$null")

        # Find out how many images in the pattern
          count(ifile) | scan(ss1)
          ncount = int(ss1)

        # To get the offset information from the header and then put them
        # into a file "ashiflfl1"

          _dithead2fl(ifile, pixunit1, aoffasfl1, ashiftfl1)


        # Change the offset information in pixel and find out the overlaying
        # region in reference frame

          print("Total images in dither sequence: ",ncount, >> cirditherlog)
          print("==========================================", >> cirditherlog)

          tot_xoffpxp = 0.0; tot_yoffpxp = 0.0

          filist  = ""; slist = ""
          filist = ifile; slist = ashiftfl1
          while ( (fscan(filist, framein) != EOF) && 
            (fscan(slist, tot_xoffpx,tot_yoffpx,tot_xioffas,tot_yioffas) != EOF) )
          {
           icount += 1
   
            print("")
            print("Image "//str(icount)//": "//framein)

            if (icount == 1)
              {
                  _ddispsize(framein, ashiftfl1, pixelscale)
                  framein1 = _ddispsize.fdisp
                  imcopy(framein1, dispframein1, ver+, >& "dev$null")
                  xd1 = _ddispsize.xdd1
                  yd1 = _ddispsize.ydd1
                  xd2 = _ddispsize.xdd2
                  yd2 = _ddispsize.ydd2

                  print("Display frame: ", framein1)
                  coordfl = "none"
                  _circendit(dispframein1,cenout,coordfl,boxrad1)
                  rename(cenout, cenref, field="all")  
                  delete(dispframein1, ver-, >& "dev$null")

                  tot_xfoffpx = tot_xoffpx
                  tot_yfoffpx = tot_yoffpx
                  
                  print("image"//str(icount),": ", framein, >> cirditherlog)
                  print("display frame: ", framein1, >> cirditherlog)
                  print("tot_xfoffpx, tot_yfoffpx: ", tot_xfoffpx, tot_yfoffpx, >> cirditherlog)
                  print("", >> cirditherlog)
                  print(tot_xfoffpx, tot_yfoffpx, >> offsetfl1) #put them into outfile
                  print(framein, >> cenfile) #make a file containing centers

                  clist1 = ""; clist1 = cenref
                  while ( fscan(clist1, xref, yref) !=EOF)
                    {
                     print("xref,yref,tot_xoffpx,tot_yoffpx (in pix) w.r.t. smaller display: ", xref, yref, tot_xoffpx, tot_yoffpx, >> cirditherlog)
                     # print("xref, yref, tot_xoffpx, tot_yoffpx (in pix) w.r.t. smaller display: ", xref, yref, tot_xoffpx, tot_yoffpx)
                      xref = xref + (xd1 - 1.0)
                      yref = yref + (yd1 - 1.0)
                     print("xref, yref, tot_xoffpx, tot_yoffpx (in pix) w.r.t original display: ", xref, yref, tot_xoffpx, tot_yoffpx, >> cirditherlog)
                     # print("xref, yref, tot_xoffpx, tot_yoffpx (in pix) w.r.t. original display: ", xref, yref, tot_xoffpx, tot_yoffpx)

               # store the current position for next iternation
                       x1 = xref; tot_xoffpxp = tot_xoffpx
                       y1 = yref; tot_yoffpxp = tot_xoffpx

                    } # this brace is from while block (read clist1)
                   clist1 = "" # close the file               

              } # this brace is from icount == 1
             else  # (icount > 1)
              {
                   print("", >> cirditherlog)
                   print("image"//str(icount),": ", framein, >> cirditherlog)
                   print("tot_xioffas,tot_yioffas(in asec),tot_xoffpx,tot_yoffpx(in pix)", 
                          tot_xioffas,tot_yioffas,tot_xoffpx,tot_yoffpx, >> cirditherlog)
                   print("previous-tot_xoffpx, previous-tot_yoffpx) :",tot_xoffpxp, tot_yoffpxp,
                          >> cirditherlog)

                   xoffbet = tot_xoffpx - tot_xoffpxp
                   yoffbet = tot_yoffpx - tot_yoffpxp
                
                   x2 = x1 - xoffbet  # in pixel-coordinate
                   y2 = y1 - yoffbet
                   print("x2, y2 (in pixels): "//x2//", "//y2)
                   print("x2, y2 (in pixels): "//x2//", "//y2, >> cirditherlog)
                   print("xoffbet, yoffset (in pix) ", xoffbet, yoffbet,
                        >> cirditherlog)

                   if ((x2 < 1.0) || (x2 > 1024.0) || (y2 < 1.0) ||
                       (y2 > 1024.0))
                     {
                      print("x2 or y2 is/are outside the range, try another object!")
                      bye
                     }
                   coordfl = "centemp.coo"
                   if (access(coordfl))
                     delete(coordfl, ver-, >& "dev$null")

                   print(x2, y2, >> coordfl) 
                   _circendit(framein,cenout,coordfl,boxrad1) # get a more accurate
                                                        # position
                   if (access(cen2))
                      delete(cen2, ver-, >& "dev$null")
                   rename(cenout, cen2, field="all")

                   clist2 = ""; clist2 = cen2
                   while(fscan(clist2, x2new, y2new) != EOF)
                       print("x2new, y2new (in pix) :", x2new, y2new,
                           >> cirditherlog)

                   clist2 = ""   # close the file 
                   print("x2new, y2new (in pixels): "//x2new//", "//y2new)

                   tot_xfoffpx = xref - x2new
                   tot_yfoffpx = yref - y2new

                   print(tot_xfoffpx, tot_yfoffpx, >> offsetfl1)

                print(framein, >> cenfile) # make a file containing centers

               # put the final offset  information into the logfile and centefile
                   print("(x2new,y2new),(tot_xfoffpx,tot_yfoffpx):",x2new,y2new,,tot_xfoffpx,tot_yfoffpx,
                          >> cirditherlog)
                   print(x2new,y2new,tot_xfoffpx,tot_yfoffpx, >> cenfile) 
         
              # store the current position and offset w.r.t. refpos for
               # next iternation

                   x1 = x2new ; tot_xoffpxp = tot_xoffpx
                   y1 = y2new ; tot_yoffpxp = tot_yoffpx
                   
              }  # this brace is from if-else block (icount > 2)

          } # this brace is from while loop (read filist, and read slist)
          filist = ""; slist = "" # close the files

          nonint: # from the jump goto nonint (for non-interactively case)
          if (imgout1 != "none")
            {
              if (!useropt1)
                 {
                  unlearn imcombine
                  filist = ""; filist = ifile
                  while( fscan(filist, s1) != EOF)
                    {
                      imgets(s1, param= "BPM", >& 'dev$null')
                      s2 = imgets.value
                      goto lab
                    }

                  lab:
                  filist = ""

                  if (s2 != "0") #keyword BPM in the header
                     imcombine.masktype = "goodvalue"
                  else
                     imcombine.masktype = "none"

                  imcombine("@"//ifile, imgout1, plfile="",sigma="", 
                  logfile=cirditherlog,
                  combine="median", reject="none", project=no, outtype="real", 
                  offsets=offsetfl1, maskvalue=0., blank=0., 
                  scale=mscale1, zero=mzero1, weight="none", statsec="", 
                  expname="", lthreshold=INDEF, hthreshold=INDEF,
                  nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=3., hsigma=3., 
                  rdnoise="0.",gain="1.", snoise="0.", sigscale=0.1,
                  pclip=-0.5, grow=0)
                }
              else
                {   #pset option
              imcombine("@"//ifile, imgout1, sigma=p_sigma, plfile=p_plfile, 
              combine=p_combine,reject=p_reject, project=no, outtype = "real",
              offsets=offsetfl1, masktype=p_masktyp, maskvalue=p_maskval, 
              blank=p_blank, scale=p_scale, zero=p_zero, weight=p_weight, 
              statsec=p_statsec, expname=p_expname, lthresh=p_lthresh, 
              hthresh=p_hthresh, nlow=p_nlow, nhigh=p_nhigh, nkeep=p_nkeep, 
              mclip+, lsigma=p_lsigma, hsigma=p_hsigma, rdnoise=p_rdnoise, 
              gain=p_gain, sigscale=p_sigscale, pclip=p_pclip, grow=p_grow, 
              logfile=cirditherlog)
                }

             } #this brace is from if-block ( imgout1 != "none")


         # Clearing up
         # close the files

         delete(ifile//","//ofile, ver-, >& "dev$null")
         delete(cenref, ver-, >& "dev$null")
         delete(cen2, ver-, >& "dev$null")
         delete(coordfl, ver-, >& "dev$null") 
         delete(ashiftfl1, ver-, >& "dev$null")

         print ("")
	 print ("CIRDITHER done.")

end


