# IRAF script -- cdossky
#	
#   function:  to make sky and to substract sky
#                and a list of running numbers
#              (this is a proto-type)
#              
#                   cmkqsky -- subqsky                    
#      abb: ir  - input requred; ih -- input hidden; ip -- input by program
#           o-i - output --> input; of - final output; oh -- output hidden
#                                   ot - temporaray output
#
# programmer: sjchan 
#    history: 20march98 (create)
#             16july98 -- modified: add an option not substracting sky
#             25aug98 -- modified: an option for user to use BPM, not automatic

procedure cdossky(skylist, cobjdlist, prefix, presky, skyfile, stfold, tchip, subsky, useropt, usebpm)

string skylist {"dithersky.in", prompt="List of lists dithering images to produce list of sky images", mode="ql"}
string cobjdlist {"cobjl.in",prompt="List of lists coadded object images", mode="ql"}
string prefix    {"pfix", prompt="Prefix of input input images", mode="ql"}
string presky    {"sky_c", prompt="Prefix of output sky frames (subsky case only)", mode="ql"}
string skyfile   {"skyframe.in", prompt="File containing names of output skyframes", mode="ql"}
string stfold    {"1", prompt="Starting fold for making sky frames", mode="ql"}
int tchip        {4, prompt="Total number of chips or quads", mode="ql"}
bool subsky      {yes, prompt="Perform substract sky background", mode="ql"}
bool useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
bool usebpm     {no, prompt="Use bad pixel map when making sky"}
pset    mkskypar {prompt="Imcombine parameters to make sky images"}

begin

        string skylist1       #ir  name of file containing list of lists
                                #  which is for making skyframes
        string cobjdlist1     #ot  file containing list of dithering lists of
        string prefix1        #i Prefix of input images
        string presky1        #ir     prefix of output sky frames
        string skyfile1       #o-i/of  name of file containing output skyframes
        string stfold1        #ir     the starting fold number for making sky
        int    tchip1         # total number of chip (1,2,3,4)
        bool   subsky1        #ir   Perform substract sky background
        bool   useropt1       #ir   user option to input IMCOBINE parameters
        bool   usebpm1        #ir   use bad pixel map when making sky
        string cdosskylog     #fo   logfile of cdossky
        string cobjclist1     #o-i  Output list of lists of chip-images 
                                # from cmkqlist (input for cubqsky)
        string  chiphead1        # prefix of files containing the input list 
                              #   for csubqsky
        string templog        #ot   temporary logfile from each task
        string ss1
        string tmpfile           # dummy variable


  # Get the rest of parameters 

       skylist1   = skylist
       cobjdlist1 = cobjdlist
       prefix1    = prefix
       presky1    = presky 
       skyfile1   = skyfile
       stfold1    = stfold
       tchip1     = tchip
       subsky1    = subsky
       useropt1   = useropt
       usebpm1    = usebpm

  # Define the local or temporary parameters
       cdosskylog   = "cdossky.log"
       templog   = "temp.log"
       chiphead1   =  prefix1//"_c"
       cobjclist1  =  prefix1//"_chip.in"


       if (access(cdosskylog))
           delete(cdosskylog, ver-, >& "dev$null")
       if (access(skyfile1))
           delete(skyfile1, ver-, >& "dev$null")


          # print("")
          print("", >> cdosskylog)
          print("Making sky images ...")
          print("Making sky images ...", 
                  >> cdosskylog)
          # print("") 
          templog = "cmkqsky.log"
          unlearn cmkqsky
          cmkqsky("@"//skylist1, skyfile1, presky1, stfold1, tchip1, 
               useropt1, usebpm1)

          unlearn type
          type(templog, >> cdosskylog)

          if (subsky1)
            {
             # Substract the sky background

               print("")
               print("", >> cdosskylog)
               print("Subtracting the sky ...")
               print("Subtracting the sky ...", 
                  >> cdosskylog)
               # print("") 

            # Prepare chip-list of object images for subtracting sky-background
               # cobjdlist1 -- containing e.g. xxx_r1320.in, xxx_r1321.in ...
               # cobjclist1 -- containing e.g. xxx_c1.in xxx_c2.in ...

               # print("Making object lists containing different dithering positions")
               # print("       under same chip number")
               cmkqlist(cobjdlist1, cobjclist1, chiphead1)
    
               # print("")
               # print("Now we are ready to substract the sky background")
               # print("")
               # Now we are ready to substract sky
               templog = "csubqsky.log"
               csubqsky("@"//cobjclist1, "@"//skyfile1)
               unlearn type
               type(templog, >> cdosskylog)

            } # this brace is from if-block (subsky == yes)

	  print ("CDOSSKY done.")
	  # print ("")


end


