# IRAF script -- _mkcflat.cl
#
#   function:  to make a combined flat frame 
#	
# programmer: sjchan (febraury 1997, oct 1997, nov 1997)
#             modified: 28apr98 -- modified from cmksky.cl
#             modified: 11aug98 -- add an option to use pset
#


procedure _mkcflat(frame_in,frame_out, n_start, useropt)

string	frame_in   {"",prompt="(@List of/ *.fits) Input images",mode="ql"}
string  frame_out  {"",prompt="Output combined image",mode="ql"}
int     n_start    {1, prompt="the starting stare number for imcombine", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkflatpar {prompt="Imcombine parameters to make flat images"}

string  *filist

begin
        string  ftmpi                # List of input images
        string  frameout             # Output combined flat image
        int     nstart               # the starting stare number for imcombine
        bool    useropt1             # user option to inut IMCOMBIN parameters
        string  frametemp            # Input image
        string  ifile,ifile1, ofile  # final version of input and output
        string  comblog              # logfile
        string  indc                 # indicator
        int     nl, nh               # nlow and nhigh (reject=minmax in 
                                     #    imcombine
        int     icount, ic           # number of images in input image list
        string  s2

       # IMCOMINBE parameters (user choose)
         string p_sigma, p_plfile, p_combine, p_reject, p_offsets, p_masktyp
         string p_scale, p_weight, p_statsec, p_expname, p_zero
         string p_rdnoise, p_gain
         real p_maskval, p_blank, p_lthresh, p_hthresh
         real p_lsigma, p_hsigma, p_pclip, p_sigscale
	 int  p_nlow, p_nhigh, p_nkeep, p_grow


        #  Get the rest of the parameter

        ftmpi=frame_in
        frameout=frame_out
        nstart = n_start
        useropt1 = useropt
        comblog="_mkcflat.log"
        ind="C"       # dummy definition
        icount = 0; ic = 0
        ifile="dummy1"
        ifile1 = "dummy1a"
        ofile="dummy2"
        nh=0
        nl=0

        #IMCOMBINE parameters

        p_sigma  = mkflatpar.f_sigma
        p_plfile = mkflatpar.f_plfile
        p_combine = mkflatpar.f_combine
        p_reject = mkflatpar.f_reject
        p_masktyp = mkflatpar.f_masktyp
        p_maskval = mkflatpar.f_maskval
        p_blank = mkflatpar.f_blank
        p_scale = mkflatpar.f_scale
        p_zero = mkflatpar.f_zero
        p_weight = mkflatpar.f_weight
        p_statsec = mkflatpar.f_statsec
        p_expname = mkflatpar.f_expname
        p_lthresh = mkflatpar.f_lthresh
        p_hthresh = mkflatpar.f_hthresh
        p_nlow = mkflatpar.f_nlow
        p_nhigh = mkflatpar.f_nhigh
        p_nkeep = mkflatpar.f_nkeep
        p_lsigma = mkflatpar.f_lsigma
        p_hsigma = mkflatpar.f_hsigma
        p_rdnoise = mkflatpar.f_rdnoise
        p_gain = mkflatpar.f_gain
        p_sigscale = mkflatpar.f_sigscale
        p_pclip = mkflatpar.f_pclip
        p_grow = mkflatpar.f_grow

		
        #  Check the existence of the logfile
           if (access(comblog))
             delete(comblog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ifile1))
             delete(ifile1, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
           if (access(frameout))
             delete(frameout, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(ftmpi, indc, ifile, ofile)
          

        # Read the file 'ifile' to count the number of files

        filist = ifile
        while (fscan(filist,frametemp) !=EOF)
         {
          ic += 1
           # check whether BPM is in the header
           if (ic == 1)
              {
                imgets(frametemp, param = "BPM", >& "dev$null")
                s2 = imgets.value
              }

            if (ic >= nstart)
              {
                 icount += 1
                 print(frametemp, >> ifile1)
              }
         }  # this is from the while stare (filist, frametemp)

        print("icount = ", icount)
         if (icount <= 2)
           {
            nh = 0
            nl = 0
           }
         else if ((icount > 2)  && (icount < 5))
           {
            nh = 1
            nl = 1
           }
         else if ((icount >= 5) && (icount < 10))
          { 
            nh = 2
            nl = 1
          }
         else if ((icount >= 10) && (icount < 20))
          {
            nh = 5
            nl = 3
          }
         else if (icount < 30) 
         {
            nh = 10
            nl = 5
         }
         else if (icount < 40)
         {
            nh = 13
            nl = 10
         }
         else if (icount < 45)
         {
            nh = 20
            nl = 15
         }
         else if (icount < 50)
         { 
            nh = 20
            nl = 20
         }
         else if (icount < 60)
         {
            nh = 25
            nl = 20
         }
         else if (icount < 65)
         {
            nh = 30
            nl = 25 
         }
         else if (icount < 70)
         {
            nh = 30
            nl = 30 
         } 
         else if (icount < 75)
         {
             nh = 35
             nl = 30
         }
         else if (icount < 80)
         { 
             nh = 35
             nl = 35
         }
         else
         {   
             nh = 40
             nl = 35 
         }

         if (!useropt1)
           {
             unlearn imcombine
             if (s2 != "0") #keyword BPM in the header
                imcombine.masktype = "goodvalue"
             else
                imcombine.masktype = "none"     

             imcombine("@"//ifile1,frameout,combine="median", reject="minmax",
             project=no, outtype="real", offset="none",
             maskvalue=0, blank=0, scale="median", zero="none", weight="none",
             expname="", statsec="", nlow=nl, nhigh=nh, logfile=comblog)
           } #this brace is from if-block (!useropt1)(
        else
          {
            imcombine("@"//ifile1, frameout, sigma=p_sigma, plfile=p_plfile, 
              combine=p_combine,reject=p_reject, project=no, outtype = "real",
              offsets="none", masktype=p_masktyp, maskvalue=p_maskval, 
              blank=p_blank, scale=p_scale, zero=p_zero, weight=p_weight, 
              statsec=p_statsec, expname=p_expname, lthresh=p_lthresh, 
              hthresh=p_hthresh, nlow=p_nlow, nhigh=p_nhigh, nkeep=p_nkeep, 
              mclip+, lsigma=p_lsigma, hsigma=p_hsigma, rdnoise=p_rdnoise, 
              gain=p_gain, sigscale=p_sigscale, pclip=p_pclip, grow=p_grow, 
              logfile=comblog)
          }
         
        delete (ofile//","//ifile, ver-, >& "dev$null")
        delete(ifile1, ver-, >& "dev$null")
        filist=""

        print("      << ======= _mkcflat DONE ====== >>")


end

