# IRAF script -- _getexptime.cl
#      function: to get the timestamp from the headers and then to calculate
#                  the exposure time
#	
# programmer: sjchan 
#          history: 
#             30june98 -- created
#
#

procedure _getexptime(rcflin1, rcflin2, rcflout)

string	rcflin1   {"",prompt="List of images in upper limit range",mode="ql"}
string  rcflin2   {"", prompt="List of images in lower limit range", mode="ql"}
string  rcflout   {"", prompt="list imagenames with real exposure time", mode="ql"}
struct  *filist1, *filist2
struct  *folist


begin

        string  rcflin11  #list of images in upper limit range of rc-corrected
        string  rcflin21  #list of images in lower limit range of rc-corrected
        string  frame1    # input frame in the input list1, and input list2
        string  frame2
        string  frameout  #exposure time will be put in its header
        real    time1, time2 #the value of timestamp (in ms)
        string  stime1, stime2  # value of timestamp in string
        real    etime      # real exposure time (in sec)
        string  twarn      #o temporary file containing error message from
                           #    imgets
        string  swarn      #o the first word in the error message (Warning:)
        string  getetimelog  #o logfile
        string  sdate      #i the date in string


        cache imgets     # need this action due to a bug in imgets

        #  Get the rest of the parameters

          rcflin11 = rcflin1
          rcflin21 = rcflin2
          getetimelog = "getexptime.log"
          twarn    = mktemp("twarn")
          swarn    = "G"

          if (access(getetimelog))
             delete(getetimelog, ver-, >& "dev$null")

          filist1 = ""; filist2 = ""
          filist1 = rcflin11;  filist2 = rcflin21
          folist  = ""; folist = rcflout

          while( (fscan(filist1, frame1) != EOF) && 
                 (fscan(filist2, frame2) != EOF) &&
                 (fscan(folist, frameout) != EOF) )
           {
             print("", >> getetimelog)
             print("Input image1: ", frame1, >> getetimelog)
             print("Input image2: ", frame2, >> getetimelog)

             imgets(frame1, para="time_obs", >& twarn)     
             stime1 = imgets.value
             unlearn type   # check whether time_obs is in the header
             type(twarn) | scan(swarn)
             delete(twarn, ver-, >& "dev$null")

             if ((stime1 == "") || (swarn == "Warning:") || (stime1 == "/") ||
                 (stime1 == "0") )
              {
                    print("Input image1: ", frame1, >> getetimelog)
                    print("no time_obs value in the header!", >> getetimelog)
                    print("Try to get Date_Obs value!", >> getetimelog)
                    swarn = "" #cleaning the array
                    imgets(frame1, para="date_obs", >& twarn)     
                    sdate = imgets.value
                    unlearn type
                    type(twarn) | scan(swarn)
                    delete(twarn, ver-, >& "dev$null")

                    if ((sdate == "")||(swarn == "Warning:")||(sdate == "/")||
                         (sdate == "0") )
                       { 
                         swarn = "G" #clean the previous record
                         print("no Date_obs value in the header also!", >> getetimelog)
                         print("Don't have enough information to calculate time", >> getetimelog)
                         print("Time stamp is set to ZERO", >> getetimelog)
                         time1 = 0.0
                       } #this brace if from inter if-block(sdate=="","0","/")
                     else 
                       { # get the time from date_obs string
                         _date2sec(sdate)
                         time1 = _date2sec.tsec   #in sec (real)
                       }
             }
           else 
             time1 = real(stime1)  

            # check again for frame2
  
            swarn = ""
            imgets(frame2, para="time_obs", >& twarn)     
             stime2 = imgets.value
             unlearn type   # check whether time_obs is in the header
             type(twarn) | scan(swarn)
             delete(twarn, ver-, >& "dev$null")
             if ((stime2 == "") || (swarn == "Warning:") || (stime2 == "/") ||
                 (stime2 == "0") )
              {
                    print("Input image2: ", frame2, >> getetimelog)
                    print("no time_obs value in the header!", >> getetimelog)
                    print("Try to get Date_Obs value!", >> getetimelog)
                    imgets(frame2, para="date_obs", >& twarn)     
                    sdate = imgets.value
                    swarn = ""
                    unlearn type
                    type(twarn) | scan(swarn)
                    delete(twarn, ver-, >& "dev$null")
                    if ((sdate == "")||(swarn == "Warning:")||(sdate == "/") ||
                         (sdate == "0") )
                       { 
                         swarn = "G" #clean the previous record
                         print("no Date_obs value in the header also!", >> getetimelog)
                         time2 = 0.0
                       } #this brace if from inter if-block(sdate=="","0","/")
                     else
                       { # get the time from date_obs string
                         print("Time stamp of upper range image: ", time1,
                           "  sec",  >> getetimelog)
                         _date2sec(sdate)
                         time2 = _date2sec.tsec   #in sec (real)
                         print("Time stamp of lower image range: ", time2, 
                            " sec",  >> getetimelog)

                         etime = time1 - time2    # in sec (real)
                       }
             } #this brace is from if-block (stime2 = "","0" or "/"
           else
             {

               time2 = real(stime2)
               etime = (time1 - time2) * 1.0e-3  
               print("Time stamp of image-upper range: ", time1,  
                            "ms",  >> getetimelog)
               print("Time stamp of image-lower range: ", time2, 
                            "ms",  >> getetimelog)
            }

               if ((time1 == 0.0) || (time2 == 0.0))
                   etime = 0.0

         # put the the real exposure time into the image header 
             hedit(frameout, field="exptime", value=etime,
               add+, del-, ver-, update+, show-)
              print("The exposure time for ", frameout, " is: ", etime, " sec",
               >> getetimelog)


        # 
           } # this brace is from while block (filist1, filist2, folist)
        
           filist1 = ""; filist2 = ""; folist = "" # close the file


end

