# IRAF script -- cmkndrimg.cl
#	
#   function:  to provide  'real' images from a set of NDR images.
#                 
#
# programmer: sjchan (jan 98)
#        history: jan98 -- created
#                 15apr98 -- modify: NOT to use IMGETS to get the "nfolds"
#                              from the headers because the meaning 
#                              is different. It will be turned on again until
#                              the meaning of "nfolds" is clear
#                   
#

procedure cmkndrimg(ndrfl_in, rcflout, head, tot_fold, tndr, tquad, pix_type, calc_type, answer)

string	ndrfl_in   {"",prompt="(@List/*.fits or .imh) of Input images",mode="ql"}
string  rcflout  {"rc_inputfilename", prompt="Output list containing fold output filenames", mode="ql"}
int     tquad {16, prompt="total number of quadrants", mode="ql"}
bool    head     {yes, prompt="Get totndr from header", mode="ql"}
int     tot_fold  {1, prompt="total number of folds",mode="ql"}
int     tndr  {4, prompt="total number of NDR per fold (head=no case only)", mode="ql"}
string  pix_type {"real", prompt="pixtype of output images", mode="ql"}
string  calc_type {"real", prompt="calctype for IMARITH operation", mode="ql"}
bool    answer    {yes, prompt="Sort the input list?"}

struct  *lilist, *lolist, *lilist2
struct  *nilist, *nolist
struct  *ndrlist, *foldlist



begin
        string  ftmpi      # input file list
        int     foldnum    # total number of folds for a fixed-pos observation
        int     totndr2    # total number of NDR per fold
        int     totquad2   # total number of quad per fold
        string  ofile     # a file containing fold output filenames
        string  ifile     # the final version of input file list
        string  foldin    # a file containing fold input filenames
        string  ndrflin     # input file list containing input image per fold
        string  ndrflout    # output file list containing output images
        string  flin        # input file fold list
        string  flout       # output file fold list
        string  tndrflin[2] # dummy variables
        string  cmkndrimglog  # logfile
        int     icounter    # counter
        int     ic, ic2, icc     # dummy counters
        int     ifold       # fold counter
        int     leni       # length of input file list string
        int     tfoldno    # dummy variables tfoldno = foldnum - 1
        bool    answer1    # ask sort the input list
        bool    head1      # ask for getting information from header
        string  ind        # indicator
        string  pixty      # pixtype of output images
        string  calcty     # calcuating type for IMARITH
        string  ndrfl      # dummy variable
        string  foldinfl   # dummy variable
        string  flcheck    # number of file indicator
        string  dcheck     # dummy variable (check header information)
        string  timg       # 1st image file in the list (ifile)

      #  Get the rest of the parameters

        ftmpi = ndrfl_in
        ofile = rcflout
        totquad = tquad
        head1 = head
        foldnum=tot_fold
        totndr2 = tndr
        pixty = pix_type
        calcty = calc_type
        answer1=answer
        foldin = "dummyfold"
        cmkndrimglog = "cmkndrimg.log"
        tfoldno = foldnum 
        ind = "RC"   # Reset correction
        dcheck = ""
   
        cache imgets     # need this action due to a bug in imgets
        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
          {
           ifile = substr(ftmpi, 2, leni)
           if (ofile == "")
               ofile = "rc_"//ifile
          }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           if (ofile == "")
               ofile = "rc_ofold.in"   
         }

     # Check existence of output files

        if (access(ofile))
          delete(ofile, ver-) 
        if (access(cmkndrimglog))
          delete(cmkndrimglog, ver-)


      # Sort the input file list (increaing order in sequence number)
      #  if user wishes (if no: the input file has been SORTED
        if (answer1)
            _finsort(ifile)
      
      # Get information from header; get the header information from
      #  from the first image
        if (head1)
          {
            lilist2 = ""; lilist2 = ifile
            while(fscan(lilist2, timg) !=EOF)
              { # need to turn off because the meaning of "nfolds" is different
               # imgets(timg, param="nfolds")
               # dcheck = imgets.value
               #if ((dcheck == "") || (dcheck == "0") || (dcheck == "/"))
               #  {
               #    print("NFOLDS value is BAD in the header!")
               #    bye
               #  }
               # else
               #  foldnum = int(dcheck)

                imgets(timg, param="totalndr")
                dcheck = imgets.value
                if ((dcheck == "") || (dcheck == "0") || (dcheck == "/"))
                  {
                    print("TOTALNDR value is BAD in the header!")
                    bye
                  }
                else
                   totndr2 = int(dcheck)   
     
                break   # go out while fold
              }   # this brace is from while fold (ifile, timg)
            lilist2 = ""  # close the file

          }  # this brace is from if (head1) block

       print("totfold: ", foldnum)
       print("totndr: ", totndr)

      # Make fold input file lists and fold output file lists
        _mkldlist(ifile, totndr2, foldnum, foldin, ofile, totquad2)
        flcheck = _mkldlist.f_flag
        if (flcheck == "B")
           bye

      # Read the list of input list  and the list of output list

        ifold = 0
        lilist = ""; lolist = ""
        lilist = foldin;  lolist = ofile
        while ( (fscan(lilist, flin) !=EOF) && (fscan(lolist, flout) !=EOF) )
         {    # flin = infold#      # flout = outfold#
           ifold += 1
           print ("Fold: ", ifold)
           print("==========================================", >> cmkndrimglog)
           print("", >> cmkndrimglog)
           print("Fold: ", ifold, >> cmkndrimglog)

     # Read contents ofinfold# and  outfold# in current fold
            ic = 0; ic2 = 0
            nilist = ""; nolist = ""
            nilist = flin; nolist = flout
            while ( (fscan(nilist, ndrflin) != EOF))
             {   # ndrflin = ndr0i_#p: contains image files
               ic += 1
               if (ic == 1) 
                 {
                   tndrflin[ic] = ndrflin
                   goto lab   # lab is a label, 
                              # need to read once more in this file
                 }
               else if (ic == 2)
                  tndrflin[2] = ndrflin
               else 
                 {
                  tndrflin[1] = tndrflin[2]
                  tndrflin[2] = ndrflin
                 }

                while ( (fscan(nolist, ndrflout) !=EOF))
                 {    # ndrflout = rc??_#p
                   ic2 += 1   # dummy counter

                   ndrlist = ""; ndrlist = ndrflout
                   while(fscan(ndrlist, ndrfl) != EOF)
                     {
                      if (access(ndrfl))
                         delete(ndrfl, ver-)    
                     }   
                   ndrlist = ""  # close the file

                icc = ic - 1
                   print("", >> cmkndrimg)
                   print("RC pairs:", ic, icc, >> cmkndrimg)
                   print("RC pairs:", ic, icc)

                 # Provide the real signal image and update the header     
                   unlearn imarith
                   imarith(operand1="@"//tndrflin[2], op="-", 
                       operand2="@"//tndrflin[1],
                       result="@"//ndrflout,  pixtype=pixty, calctype=calcty,
                       verbose=yes, >> cmkndrimglog)
              
                   hedit("@"//ndrflout, field="fold", value=ifold, add+, del-, 
                      ver-, update+, show-)
                   hedit("@"//ndrflout, field="rcflag", 
                      value=ind, add+, del-, ver-, update+, show-)
       
                   goto lab   # 
                 }   # from while fold (ndrflout)
             lab:       # lab is from if else fold (ic == 1) 
                  # and also from the while fold (nolist) 
      
             }   # this brace is from while fold (nilist, ndrflin)
           nilist = ""; nolist = ""    
    
        }    # this brace is from while fold (lilist, lolist)
         
         # close the files and cleaning up
           lilist = ""; lolist= ""

          if (access(foldin))
            {
              # delete infold* files which are created from _mkllist.cl
              foldlist = ""; foldlist=foldin
              while(fscan(foldlist, foldinfl) != EOF)
                 delete(foldinfl, ver-)    

             foldlist = ""   # close the file
             delete(foldin, ver-) 
            }

          if (access(ofile))
            {
              print("")
              print("You need to rename outfold* and rc*_?f if you wish to use them later")
              print("")
            }

          print("   << ========= CMKNDRIMG DONE =========== >>")
          beep; beep; beep

end

