# IRAF script -- _mknout.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#    function: the make an output RC list 
#
# programmer: sjchan 
#    history:  jan98  -- created at WHT
#             12feb98 -- modified: change the output filenames 
#                        (only _1p, not _1pxx)
#             29June98 -- modified: input images with full path names and
#                                    output images without path names
#        
#

procedure _mknout(file_in, base_fl, cfold, file_out)

string	file_in   {"",prompt="List of Input images",mode="ql"}
string  base_fl   {"rc31", prompt="Base name of the output RC", mode="ql"}
string  cfold     {"01", prompt="Current fold number", mode="ql"}
string  file_out  {"",prompt="List of Output images", mode="ql"}
struct  *filist


begin
        string  filein      # input file list
        string  basefl      # base name of the output RC
        string  fileout     # output file list
        string  framein     # image name in the input file list with path
        string  framein2    # image nanme in the input file list without path
        int     len         # total length of image name
        int     lentemp     # the location of the last "_" in the filename
        int     lentemp2    # the location of the 2nd last "_" in the filename
        int     ic          # counter (quadrants) 
        string  temptail    # the tail of image name after "rc##"
        string  temphead    # the prehead of the image name before "rc##"
        string  tempfold    # the string containing fold information
        string  realhead   # the prehead of the image 
        string  cfold1      # current fold number in string
        string  sic

      #  Get the rest of the parameters

        filein = file_in
        basefl = base_fl
        cfold1 = cfold
        fileout = file_out
        temphead = ""
        tempfold = "_"//cfold1//"p"
        realhead = ""
        temptail = ""
        framein2 = ""

        if (access(fileout))
          delete(fileout, ver-, >& "dev$null")


        filist = ""; filist = filein   # open the file
       # make ndroutlist files list

         ic = 0
         while (fscan(filist,framein) !=EOF)
                {
                  ic += 1
                  _sdigit2(ic)
                  sic = _sdigit2.value   

          # detach the path name from the input image name
                    _sepdir(framein)
                    framein2 = _sepdir.fname
            
          # find out the location of the last "_" in the given filename
                  len = strlen(framein2)
                  _locate(framein2, ".")
                   lentemp = _locate.value

        # make the tails from char#(lentemp) to char#(len)
                     temptail = substr(framein2, lentemp, len)
                     temphead = substr(framein2, 1, lentemp-1)

        # find out the location of the 2nd last "_" in the given filename
        #    the location of the last "_" in temphead
                   _locate(temphead, "_")
                   lentemp2 = _locate.value

                   realhead = substr(temphead, 1, lentemp2)

         # make the output image names and put them into a given file 
                   print(realhead//basefl//tempfold//temptail, >> fileout)
        
                }  # this brace is from while fold


          filist = ""   # close the file

end

