# IRAF script -- _mkdlist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to make a list of quads files from a list of fold files
#
# programmer: sjchan (nov 97)
#        
#

procedure _mkdlist(fold_list)

string  fold_list {"", prompt="an input file containing fold input filenames",mode="ql"}
string  det_list {"detlist.in",prompt="An output file containg list of chip-image in a set of fold", mode="ql"}

struct *filist
begin
        string  foldlist          # a file containing fold input fileanmes 
        string  detlist          # a file containing fold output filenames
        string  filein1, filein2  # dummy variables (temporary files)
        string  chipimg              # prefix of each detector
        int     detnum            # total number of chips
        string  s1

      #  Get the rest of the parameters

        foldlist = fold_list
        detlist  = det_list
        filein1 = mktemp("det1")
        filein2 = mktemp("det2")
        chipimg = "chipimg"

     # Make sure the appropriate packages are loaded.
        if (!defpac("tables"))
           tables

     # Check the existence of files
        if (access(detlist))
          {
           delete("chipimg*", ver-)
           delete(detlist, ver-, >& "dev$null")
          }

     # join the lines in foldlist and store them in filein1
         unlearn joinline
         joinline("@"//foldlist, output= filein1, maxchars = 2000)
     
     #  find out the total sequence number in one fold
          count(filein1) | scan(s1)
          detnum = int(s1)

     # transpose the table/file so that input rows become output columns
     #  and input columns become output rows
        ttranspose(filein1, filein2, "t", ver-)

     # break this filein2 (multicolumns) into 'detnum' single column files

 
    # break this filein2 (multicolumns) into 'foldseqno' single column files
     #  whose root is "chipimg" if detnum > 1
 
        column(filein2, detnum, outroot = chipimg)
 
     # make a list of these chip-lists
       files(chipimg//"*", > detlist)

        filist = ""    # close the file filein2
        delete (filein1, ver-, >& "dev$null")
        delete (filein2, ver-, >& "dev$null")

end

