# IRAF script -- cobsedit.cl
#
#  function: to put all the essential keywords to the header
#
# progrmmer : sjchan (December 1997)
#

procedure cobsedit(img_list, head_file, file_in)

string img_list {"", prompt="(@List of/*.fits) Input images", mode="ql"}
string head_file {"cqlook$std_head.dat", prompt="The headfile containing the essential keywords for an observing run", mode="ql"}
string file_in  {"9dec.inf",prompt="Input filename of observing log", mode="ql"}
string loop_comb {"none", prompt="Have done loop combination(LC|none)", mode="ql"}
struct *filist1, *filist2

begin
      # Local variable declarations
        string imglist     # List of input images
        string headfile    # the headfile containing unique keywords for an
                            # observing run
        string filein      # Input filename of observing log
        string fname1      # name of loop-1 file within a given loop
        string rname1       # rootname of input files (value from input table)
        string rname2       # rootname of input files (value from input images)
        string title        # the title of this object
        string imgtype      # image type
        string ra1          # RA of the object that the telescope is tracking
        string dec1         # DEC of the object that  the telescope is tracking
        string epoch1     # equinox of the coordinates in RA, DEC
        string totloop      # total number of a loop
        string loopst       # Starting loop/run  number in a given loop
        string loopend      # end loop/run number in a given loop
        string filter1       # filter
        string exprrr1     # Length of exposure time per loop (sec)
        string utstart1     # UT at exposure start
        string ststart1     # local sideral time start
        string airmass1     # airmass at start
        string readout1     # detector readout mode
        string readrate1    # detector readout rate
        string status1      # status mode of observation
        string weather1     # weather condition
        string dateobs      # date of observation
        string tmpdate           # dummy variable (to read shiftlog)
        string ifile        # final version of input image list
        int    ic, ic2      # dummy counters
        int    leni         # dummy variable
        string cobsheadlog  # logfile
        string obsheditlog  # dummy logfile
        string loopcomb     # indicator for loop combination

      # Get the reset of the parameters
        imglist = img_list
        filein = file_in
        headfile = head_file
        loopcomb = loop_comb 
        dateobs = "09/12/97"
        rname2 = "RR"
        cobsheadlog = "cobshead.log"
        obsheditlog = "obshedit.log"
        if (loopcomb == "yes")
           loopcomb = "LC"

        if (access(cobsheadlog))
           delete(cobsheadlog, ver-, >& "dev$null")

      # Find out an suitable input option
        leni=strlen(imglist)
         if (stridx(imglist, "@") == 1)
           ifile = substr(imglist, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

      # stick the headfile the input images
        mkheader("@"//ifile, headfile, append+, ver+, >> cobsheadlog)

      # Read the imglist and the observing log
        filist1 = ""; filist1=ifile   # open input files
        filist2 = ""; filist2 = filein
        i = 0; k= 0   # counters
        while (fscan(filist2, tmpdate) !=EOF)
          { 
             _locate(tmpdate, "=") #locate the last "=" in the string
             i = _locate.value
             k = strlen(tmpdate)

             if (substr(tmpdate,1, i-1) == "DATE-OBS")
               {
                  dateobs = substr(tmpdate,i+1, k)
                  break   # find the date-obs
               }  
          }   # this brace is from while loop to read dateobs
    
        j = 0 
        while (fscan(filist2, fname1,rname1, title, imgtype,ra1,dec1,epoch1,
               totloop, loopst, loopend, filter1, exprrr1, utstart1,
               ststart1,airmass1, readout1, readrate1,status1,weather1) !=EOF)
         {
            j += 1 

             if (j > 1) 
              { # read the image list
                 ic = 0 ; ic2 = 0  # initiate the counter
                 while (fscan(filist1, ifile) !=EOF)
                  {
                    _locate(ifile, "_") # locate the last "_" in the string
                    ic2 = _locate.value
                     rname2 = substr(ifile, 1, ic2-1)
                     ic += 1   # count current loopnum within a given loop
                    
                    print("===========================", >> cobsheadlog)
                    print("", >> cobsheadlog)
                    print("Image Name: ", ifile, >> cobsheadlog)
                    print("Put the essential keywords into the header", >> cobsheadlog)
                    if (ifile == fname1)
                      {
                  # put the information to the header
                        _obshedit(ifile,fname1,rname1,title,imgtype,ra1,dec1,
                           epoch1,totloop, loopst,loopend,filter1,exprrr1,
                           utstart1, ststart1, airmass1, readout1, readrate1,
                           status1, weather1, dateobs)
                           unlearn type
                         type (obsheditlog, >> cobsheadlog)      
                         if (loopcomb == "LC")
                           {
                              hedit(ifile,field="loopcomb",value="LC",add+,
                                  del-,ver-,update+,show-)                 
                              goto lab
                            }

                      }  # this brace is from if loop (ifile == fname1)
                    else  
                      {
                        if ( (rname1 == rname2) && (ic > 1) )
                          {
                            # put the information to the header
                           _obshedit(ifile,fname1,rname1,title,imgtype,
                             ra1,dec1,
                             epoch1,totloop, loopst,loopend,filter1,exprrr1,
                             utstart1, ststart1, airmass1, readout1, readrate1,
                             status1, weather1,dateobs)
                              unlearn type
                              type (obsheditlog, >> cobsheadlog)
                          }
                        else
                           goto lab 

                      if (ic == int(totloop))
                          goto lab    

                      } # this brace is from ifelse loop (ifile != fname1)
                  }   # this brace is from the most inner while loop
              }  # this brace is from if loop j > 1

           lab:         # jump from (if (rname1 != rname2)

                 # read next line in the obslogfile
          } #this brace is from while loop to read the observing information
 
          print("<< ========= COBSHEAD DONE ========= >>")
          beep; beep; beep
           
end

