# IRAF script -- cmkimgall.cl
#	
#   function:  to produce all the RC images
#                RC images.
#                 
#
# programmer: sjchan (jan 98)
#        
#

procedure cmkimgall(ndrflin, totfold, totndr, totquad, rcflout, pixty, calty, ansort)

string	ndrflin  {"",prompt="(@List/*.fits or .imh) of Input NDR images",mode="ql"}
int     totfold  {min=1, prompt="total number of folds for a fixed-pos obs",mode="ql"}
int     totndr   {min=2, prompt="total number of NDR per fold", mode="ql"}
int     totquad  {16, prompt="total number of quadrants", mode="ql"}
string  rcflout  {"rc2_inputfilename", prompt="List of lists of output RC files", mode="ql"}
string  pixty  {"real", prompt="pixtype of output images", mode="ql"}
string  calty {"real", prompt="calctype for IMARITH operation", mode="ql"}
bool    ansort   {yes, prompt="Sort the input list?"}

begin

        string  ndrflin1   # input file list 
        int     totfold1   # total number of folds for a fixed-pos obs
        int     totndr1    # total number of NDR per fold
        int     totquad1    # total number of quadrants
        string  pixty1     # pixtype of output images
        string  calty1     # calctype of output images
        bool    ansort1    # sort the input list
        string  templog1   # temporary logfile (cmkrcimg.log)
        string  templog2   # temporary logfile (cmkndrimg.log)
        string  cmkimgalllog # logfile of cmkimgall
        string  rcflin1    # list of lists of input RC files 
                           # (output of cmkndrimg)
        string  rcflout1   # list of lists of output RC files
      

      #  Get the rest of the parameters

        ndrflin1 = ndrflin
        totfold1 = totfold
        totndr1  = totndr
        totquad1 = totquad
        rcflout1 = rcflout
        pixty1   = pixty
        calty1   = calty
        ansort1  = ansort
        cmkimgalllog = "cmkimgall.log"
        templog1 = "cmkndrimg.log"
        templog2 = "cmkrcimg.log"
        rcflin1 = "rcflin1.in"
        

   # Check existence of output files

      if (access(cmkimgalllog))
            delete(cmkimgalllog, ver-, >& "dev$null")
      if (access(cmkimgalllog))
            delete(rcflin1, ver-, >& "dev$null")

   # Run Task cmkndrimg to produce adjcent RC image pairs from NDR images

      print("CMKNDRIMG is running:")
      print("CMKNDRIMG is running:", >> cmkimgalllog)
      print("", >> cmkimgalllog)
         
      cmkndrimg(ndrflin1, totfold1, totndr1, totquad1, rcflin1, pixty1, calty1, ansort1)

      unlearn type
      type (templog1, >> cmkimgalllog)

  # Run Task cmkimg to produce rest of RC images 

      print("")
      print("CMKRCIMG is running:")
      print("", >> cmkimgalllog)
      print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%", >> cmkimgalllog)
      print("", >> cmkimgalllog)
      print("CMKRCIMG is running:", >> cmkimgalllog)

      cmkrcimg("@"//rcflin1, rcflout1, pixty1, calty1)

      unlearn type
      type (templog2, >> cmkimgalllog)

      delete(rcflin1, ver-, >& "dev$null")

          print("   << ========= CMKIMGALL DONE =========== >>")
          beep; beep; beep

end

