# IRAF script -- cqcent.cl
#	
#   function:  to find the shifts w.r.t. to the reference quad-image 
#                for centroiding
#               main input: from the output of cmkqlist (list of list)
#      interactive: coordinate file  (containing "none")
#      non-inteactive: coordinate file (containing filenames of coordinates
#            
#
# programmer: sjchan (nov 97)
#   history:  original name: ccqcent.cl        
#             23jan98: cqcent.cl
#

procedure cqcent(ref_in, file_in, oset_file)

string  ref_in  {"",prompt="@List of reference quad-images for centroiding", mode="ql"}
string	file_in {"",prompt="(@List/of list) of Input quad-object images",mode="ql"}
string oset_file {"cent.co", prompt="The list of coordinate files for non-interactive mode", mode="ql"}

struct  *reflist
struct  *filist1, *filist2

begin
        string  ftmpi       #i input file list
        string  ifile       #i the final version of input file 
        string  refin       #i list of reference quad-images for centroiding
        string  refimg      #i reference image
        string  quadin      #i input image
        string  frameout    #o output shift filename
        string  fileout     #o a file containing  output shift filenames
        string  cqcentlog   #o logfile
        string  prehead1    #i prehead of the file containing the shift files
        string  prehead2     # prehead of the output shift files
        string  osetfile   #i the list of offset file names
        string  osetfin    #i  non-interactive: coordinate filenmae
                             # interactive: none
        int     ic          # counters
        int     leni       # length of input file list string
        string  ext        # dummy variable (extension of the output darks)
        string  templog    # dummy variable (temporary logfile)
       #string  filein      #i the input list of list individual object 
        string  prechar     #i the prechar of the output filename which
                              #  is the input filename for cmkqobj
        string  foutemp     #i the file containing the input files for cmkqobj
        string  tempdat     #i dummy variable (temporary oset.dat)
        string  tempdatin   #i dummy variable (oset.dat filename)
        string  temposetin  #i dummy variable (containing oset.dat filenames)
   

      #  Get the rest of the parameters

        refin = ref_in
        ftmpi = file_in
        osetfile = oset_file
        cqcentlog = "cqcent.log"
        templog = "circentroid.log"
        tempdat = "oset.dat"
        #filein = "quadlist.in"
        ext = ".sh"
        prehead1="shiftlist"
        prehead2="shiftout"
        prechar = "o"
        foutemp = "oset.in"
        temposetin = "oset_q.dat"

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
         {
           ifile = substr(ftmpi, 2, leni)
           _locate(ifile,".") # the location of the last "." in the string
           i = _locate.value
           prehead1 = substr(ifile, 1, i-1)
           foutemp = prechar//ifile
         }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

         fileout = prehead1//ext
     # Check existence of output files

        if (access(cqcentlog))
           delete(cqcentlog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")
        if (access(foutemp))
           delete(foutemp, ver-, >& "dev$null")
        if (access(temposetin))
           delete(temposetin, ver-, >& "dev$null")

      # Make quad input lists, the output file called "quadlist.in" which
      #  contains the list of quad_file names. Each quad_file contains
      #  list of loop files for quad#.  

      # _mkqlist(ifile)   # for non-offset option

      # Read the list of input object list filename
        ic = 0
        reflist = ""; filist1 = ""; filist2 = ""
        reflist = refin   # list of reference quad-image
       # filist1 = filein    # filein = quadlist.in  # interactive case
         filist1 = ifile     # interactive case
        filist2 = osetfile     # for non-interactive case

        while ( (fscan(reflist, refimg) != EOF) &&
                (fscan(filist1, quadin) != EOF) && 
                (fscan(filist2, osetfin) !=EOF) )
         {
           ic += 1
      # Make the output shift names and put them into a list 
              
              _locate(quadin, ".")
              j = _locate.value
              prehead2 = substr(quadin, 1, j-1)
              frameout = prehead2//ext
              print (frameout, >> fileout)
              print (prechar//quadin, >> foutemp)

                print("", >> cqcentlog)
                print("Quad ", ic, >> cqcentlog )
     print("ic: ", ic)
     print("quadin: ", quadin)
     print("frameout: ", frameout)
     print("refimg: ", refimg)

                circentroid(refimg, "@"//quadin, frameout, cood_fl=osetfin)
                unlearn type
                type (templog, >> cqcentlog)
                print("=========================================", >> cqcentlog)

         # store the output filenames into a file
                tempdatin = "oset_q"//str(ic)//".dat"
                if (access(tempdatin))
                    delete(tempdatin, ver-, >& "dev$null")

                type(tempdat, >> tempdatin)
                print(tempdatin, >> temposetin)
               
         }   # this brace is from while (filist1, quadin) and (filist2, osetfin)

         # close the files and cleaning up
           filist1 = "" ; filist2 = ""; reflist = ""

               if (stridx(ftmpi, "@") != 1)
                {
                 delete(ifile, ver-, >& "dev$null")
                 print("")
                 print("Remember to rename ", fileout," and ", foutemp)
                }
          print("   << ========= CQCENT DONE =========== >>")
          beep; beep; beep

end

