# CIRRENAME -- IRAF script 
#
#   function: to rename files to use the @file or %%
#
#   programmer: sjchan, May 1996  (created irrename.cl)
#              modified: Nov 1997
#     history: may96:    irrename.cl
#              nov97:    ccrename.cl
#              23jan98:  cirrename.cl

procedure cirrename (files_old, files_new, answer)

string files_old     {prompt="files need to be renamed",mode="ql"}
string files_new     {prompt="new files names",mode="ql"}
bool   answer=no     {prompt="Are you going to use IRAF-rename?", mode="q"}

struct *ilist
struct *olist

begin

     string fold,fnew,ifile,ofile
     string oldna, newna
     int leni, leno

     # Get the rest of the parameter
     fold=files_old
     fnew=files_new

     # Find out the suitable input option
     
     if (answer)
     # normal usage 
         rename (fold, fnew)
        else 
       {
     # string substituting "%","//" usage, "@" file template list usage
         leni=strlen(fold)
         leno=strlen(fnew)
         rename.field="all"

       if (stridx(fold, "@") == 1)
         {
          ifile = substr(fold,2,leni)
          ofile = substr(fnew,2,leno)
         }
       else
         {
     # Make name for temporary files
          ifile=mktemp("old")
          ofile=mktemp("new")
     
          files (fold, > ifile)
          files (fnew, > ofile)
        } #this brace is frome if-else block (stridx(fold,"@") != 1)

      # Read the file 'ifile' containing the name of files which needed to be
      # renamed
        ilist=ifile; olist=ofile
        while (fscan(ilist,oldna) != EOF && fscan(olist,newna) !=EOF)
          rename (oldna, newna, field="all")

         ilist = ""; olist = "" #close the files

      # clean up

     delete (ifile//","//ofile, ver-, >& "dev$null")

    } #  close the if (answer) block

end
