# IRAF script -- caddqbpm.cl
#	
#   function:  to put BPM keyword (bapix file location to the header)
#
#
# programmer: sjchan 
#   history: 10aug98 -- created
#            
#            


procedure caddqbpm(imglistin, bpmin)

string	imglistin   {"",prompt="(@List of lists) of Input chip images",mode="ql"}
string  bpmin {"bpmlist.in", prompt="@List of badpix masks (full path)", mode= "ql"}

struct  *filist1, *filist2

begin
        string  imglistin1  #i input list of lists of images
        string  bpmin1      #i list of badpix masks
        string  ifile       #i the final version of input file 
        string  chipin      #i list of lists input image (same chip no)
        string  chipimg
        string  img         #i individual image
        string  bpmimg      #i individual mask location
        string  s1, s2     #  chipno in string
        int     leni       # length of input imglistin1 

      #  Get the rest of the parameters

        imglistin1 = imglistin
        bpmin1     = bpmin
        chipin     = "quadlist.in"

        #  Find out the suitable input option

        leni=strlen(imglistin1)

        if (stridx(imglistin1, "@") == 1)
           ifile = substr(imglistin1, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(imglistin1, option="fullname", > ifile)
         }

      # Make chip input lists, the output file called "quadlist.in" which
      #  contains the list of quad_file names. Each quad_file contains
      #  list of fold files for quad#.

        _mkqlist(ifile)

      # Read the list of input dark list filename
        filist1 = ""; filist1 = chipin     #chipin = quadlist.in #open the file
        filist2 = ""; filist2 = bpmin1
        while ( (fscan(filist1, chipimg) != EOF)&&(fscan(filist2, bpmimg) != EOF))
         {
               hselect("@"//chipimg, "chip", expr="yes") | scan(s1)
               hselect(bpmimg, "chip", expr="yes") | scan(s2)

               if (s1 == s2) 
                 {
                   hedit("@"//chipimg,field="BPM",value=bpmimg, add+, 
                          del-,ver-, update+, show-)
                 }

         }    #this brace is from while (filist1, chipin) and (filist2, bpmin1)

         # close the files and cleaning up
           filist1 = ""; filist2 = ""


end

