# IRAF script -- _profinout.cl
#	
#   this is  file management task which is a HIDDEN task.
#    user cannot use it in the front end.
# programmer: sjchan (july 97)
#                 modified: Oct 1997
#

procedure _profinout(frame_in, frame_no, file_in, file_out)

string	frame_in   {"",prompt="(@List of / *.fits) Input images",mode="ql"}
string  frame_no   {"2",prompt="The starting fold number for projection combine", mode="ql"}
string  file_in   {"",prompt="Modified Input file containing names of input images ",mode="ql"}
string  file_out  {"",prompt="Output file containing names of output images ",mode="ql"}
struct  *filist

begin
        string  framein       # Input image with FITS extension
        string  frameno       # The starting fold number for projection combine
        string  ftmpi         # List of input images
        string  frametemp     # Input image
        string  fintemp, foutemp   # List of final version of input and output
        string  ifile         # dummy input list
        int     icount        # counter
        int     leni          # dummy variables
        int     len, len3
        string  axis3              # the length(dimension) of axis3

        #  Get the rest of the parameters

        ftmpi = frame_in
        frameno = frame_no
        fintemp = file_in
        foutemp = file_out
        framein = ""

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

        filist = ifile
        icount = 0
        while (fscan(filist,frametemp) !=EOF)
        {
         icount += 1
        # Check whether the input frames with "FITS" extension
          _checkfit(frametemp)
          framein = _checkfit.framext  # now the file with fits extension
    
        # Make the final version of input list
          imgets(framein, para="i_naxis3")
          axis3 = imgets.value
          print(framein//"[*,*,"//frameno//":"//axis3//"]", >> fintemp)
 
          print("pc"//framein,  >> foutemp)

        } # this bracket is from the while loop

         if (stridx (ftmpi, "@") !=1)
            delete(ifile, ver-, >& "dev$null")
        
end

