# IRAF script -- _doplot.cl
#	
#   this is a main file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#

# programmer: sjchan 
#      history: 5aug98 -- created
#              17aug98 -- modified: get iquad, ichip, and nframes from headers
#                         selecting line pattern, colour and markder 
#                           are based on the above information, 
#               
#

procedure _doplot(plotlist, chipselect, ansrms, tquad, axislen)

string  plotlist   {"", prompt="Plotting list", mode="ql"}
bool    chipselect {yes, prompt="Overplot each chip and quadrant separately", mode="ql"}
bool  ansrms       {no, prompt="Plot variance as function of average", mode="ql"}
int     tquad      {"", prompt="Total number of quadrants", mode="ql"}
string  axislen    {"", prompt="Length of axis", mode="ql"}

struct *plist
struct *plist2

begin

        string  plotlist1      #i plotting list
        bool    chipselect1    #i  Overplot each quadrant
        bool    ansrms1
        int     tquad1         #i total number of quadrants
        string  axislen1       #i length of axis
        string  pmarker[16]        # marker (maximum choose 8*2)
        string  ppattern[4]       # line patterns ( 4 chooses)
        int     pcolor[16]        # color (4*4 chooses)
        string  snaxis              # length of axis
        int     tmpquad             # current quadrant number (1-dim)
        int     quadno              # quadrant number (2-dim)
        int     chipno              # chipno
    
        string  s2, s1, s3
        int ic, is1, i, j, k
        real xdata, ydata, zdata
        real xmax, xmin, ymax, ymin, zmax, zmin
        

      #  Get the rest of the parameters

        plotlist1 = plotlist
        chipselect1 = chipselect
        ansrms1 = ansrms
        tquad1 = tquad
        axislen1 = axislen
        s3 = "dummyplot.list"

         ic = 0
         dvpar.append = no
         plist = ""; plist = plotlist1 #open the file
         while (fscan(plist, s2) != EOF)
           {
              if (access(s3))
                 delete(s3, ver-, >& "dev$null")

              plist2 = ""; plist2 = s2
              while(fscan(plist2, xdata, ydata, zdata, tmpquad) != EOF)
                {
                  if (ansrms1)
                     print(ydata,"\t", zdata, >> s3)
                  else
                     print(xdata, "\t", ydata, >> s3)
                }
               plist2 = "" #close the file
               
             if (!chipselect1)
               sgraph (s3, pointmo=yes, szmarker=0.05) 
             else
               {
                ic += 1
                   if (ic > 1)
                      dvpar.append = yes

                if (ic <= 16)
                  {
                    pltpar.marker = pmarker[ic]
                    pltpar.crvcolor = pcolor[ic]
                  }
                if (tquad1 <= 4) 
                  {
                   pltpar.cycolor = no
                   for (k = 1; k <= 4; k += 1)
                     {
                       if ((tmpquad == k) || (axislen == "1024"))
                         {
                           pltpar.pattern = ppattern[k]
                           goto lab
                         }
                     }
                  } #this brance is from if-block (tquad <=4)
                else if (tquad1 > 4) # more than 1 chip
                  { 
                     pltpar.cycolor = yes 
                     for (k = 1; k <= 16; k += 4)
                       {
                          quadno = mod(tmpquad, 4)
                          if (quadno == 0) 
                               quadno = 4
                          chipno = (tmpquad - quadno)/4 + 1
                          
                          if ((tmpquad >=  k) && (tmpquad <= k+3))
                            { 
                              pltpar.pattern = ppattern[chipno]
                              goto lab
                            } #this brace is from if-block (tmpquad = k to k+3)
                       } #this brace is from for block (k = 1, 16, k += 4)

                  } #this brace is from if-else-block (tquad > 4)

                lab:
                sgraph (s3, pointmo=yes, szmarker=0.02) 
                sgraph(s3, pointmo=no)
                delete(s3, ver-, >& "dev$null")             
               }

          } # this brace is from while block (plist, s2)
         plist = "" #close the file

end

