# IRAF script: splat
#
#  plots pixel values vs. time for CIRSI images
#
#  Mike Hoenig, July '98


procedure splat (infiles)

file infiles   {prompt="Input files"}
string keyword {"TIME_OBS", prompt="Keyword to extract from header"}
string avg     {"mode", prompt="Type of average to be used by GSTAT",
                enum="mean|midpt|mode"}


begin


    # Define local variables

    file l_infiles  	    # input files
    string l_keyword	    # keyword to extract from header
    string l_avg	    # GSTAT average to use

    int noimages  	    # no. of input images
    int imageno     	    # total no. of images
    file imglist  	    # filename of list of images
    file imgname  	    # name of current image
    real imavg	    	    # the actual average value for the particular image
    string hs1, hs2, hs3    # 3 dummy strings for parsing the output from HEDIT
    file datafile   	    # name of file containing values to plot

    
    l_infiles = infiles
    l_keyword = keyword
    l_avg = avg


    # Make sure STSDAS is loaded (needed for GSTAT)

    if (!defpac("stsdas"))
    	{
    	stsdas motd-
    	}


    imglist=mktemp("filenames")//".list"
    
    sections (l_infiles, option="fullname", > imglist)
    noimages = sections.nimages
    print ("")
    print ("No. of images is: ", noimages)
    print ("")

    datafile="splat.data"
    if (access(datafile)) delete (datafile, ver-, >& "dev$null")
    
    list=imglist
    while (fscan (list, imgname) != EOF)
    	{
	print ("Image: ", imgname)
	gstatistics (imgname, fields=l_avg, >& "dev$null")

    	# note rather clumsy construction here. better would be:
	# imavg = gstpar.//l_avg or something. but that doesn't seem to work!
	
        if (l_avg=="mean") imavg=gstpar.mean
        if (l_avg=="midpt") imavg=gstpar.midpt
        if (l_avg=="mode") imavg=gstpar.mode
	
	print (l_avg, "\t\t = \t", imavg)
	
	hedit (imgname, fields=l_keyword, value=".", add=no, delete=no,
	verify=no, show=no, update=no) | scan (hs1, hs2, hs3)
	print (l_keyword, "\t = \t", hs3)
	print ("")
	
	print (hs3, "\t", imavg, >> datafile)
	}

    delete (imglist, ver-, >& "dev$null")
    
    print ("")
    print ("Plotting graph...")
    print ("")
    sgraph (datafile, device="stdgraph", append=no, fill=yes, pointmo=yes, 
    	    marker="box", szmarke=4, box=yes, grid=no, ticklab=yes,
	    xlabel=l_keyword, ylabel=l_avg, title="splat: "//l_infiles, 
	    sysid=yes) 
			 
	   	   
end
