# IRAF script: rcimages
#
#  subtask to perform reset correction AND remove first (reset) frame from list
#
#  Mike Hoenig, 21-01-99


procedure rcimages (infiles, outlist)

file infiles	{prompt="Files to process"}
string outlist	{prompt="List of output files"}
bool sub1st 	{yes, prompt="Remove first (reset) frame from list?"}
bool rccorr 	{no, prompt="Perform reset-correction?"}
bool silent 	{no, prompt="Shut up?"}
string check	{"N/A", prompt="Did everything go OK? (leave this one alone)"}

begin


    # Define local variables

    file l_infiles  	    # input files
    string l_outlist  	    # list of output images
    bool l_sub1st   	    # remove 1st image from list?
    bool l_rccorr   	    # reset-correct?
    bool l_silent   	    # keep quiet?
    string l_check  	    # everything go OK?

    file imgslist    	    # list file containing input images
    int noimages  	    # no. of input images
    string imgname 	    # name of input image in list
    string rootimgname	    # the image filename, without sequence no.
    file rsetim    	    # the name of the reset image.
    int idot	    	    # the position of the . in the filename
    string rcimgname	    # name of the reset corrected image.
    int n   	    	    # counter for image no. in sequence
    string nstr     	    # same as above but formatted
    file rcimgslist 	    # the list of rc'ed images
    string rs1	    	    # temp. string used to parse reset image
    file cleanimlist	    # cleaned (ie. - 1st) list of images
    file templist   	    # temp. list when copying
    file topoflist	    # 1st image in the list...
    
    l_infiles = infiles
    l_outlist = outlist
    l_sub1st = sub1st
    l_rccorr = rccorr
    l_check = check
    l_silent = silent

    
    imgslist=mktemp("infiles")//".list"
    if (access(imgslist)) delete (imgslist, ver-, >& "dev$null")

    sections (l_infiles, option="fullname", > imgslist)
    noimages = sections.nimages
    
    if (l_silent==no)
    	{
    	print ("")
    	print ("No. of images to process is: ", noimages)
	}

    if (l_rccorr)
    	{
        if (l_silent==no)
	    {
	    print ("")
            print ("Performing reset correction ...")
	    }

    	# Get name of reset image - NB. assuming this will always be the first
    	# image in the list
    
    	type (imgslist) | scan (rs1)
    	rsetim = rs1
    
    	print ("Reset image is: ", rsetim)
    	# Next, go down the list one by one and subtract the reset image from each
    
    	rcimgslist=mktemp("rcfilenames")//".list"
    	if (access(rcimgslist)) delete (rcimgslist, ver-, >& "dev$null")

    	n=1
    
    	list=imgslist
    	while (fscan (list, imgname) != EOF)
            {
	    # Parse out the sequence number (last 3 digits before the .)
	
	    idot = stridx (".", imgname)
	    rootimgname = substr(imgname, 1, (idot-4))
	
	    # Add a leading zero to the image number if required:
	
	    if (strlen(str(n))==1)
	    	{
	    	nstr="0"//str(n)
	    	}
	    else nstr=str(n)    
	
	    rcimgname = rootimgname//"rc"//nstr//"01.fits"
	
	    if (access(rcimgname)) delete (rcimgname, ver-, >& "dev$null")
	
	    print ("imarith "//imgname//" - "//rsetim//" "//rcimgname)
	    imarith (imgname, "-", rsetim, rcimgname)
	
	    print (rcimgname, >> rcimgslist)

	    n+=1
	    }

    	print ("Reset correction done.")
    
    	}
	
    # Remove first image off list if requested
    
    if (access(l_outlist)) delete (l_outlist, ver-, >& "dev$null")

    if (l_sub1st)
    	{
    	if (l_silent==no)
	    {
	    print ("")
	    print ("Removing reset frame from output list ...")
	    }
	    
	cleanimlist=l_outlist
	
	# Go through list of images, and rewrite to new list, unless image name
	# is that of the rc image.
    	
	if (l_rccorr) templist=rcimgslist
	else templist=imgslist
	
    	type (templist) | scan (rs1)
	
    	topoflist = rs1

	list=templist
	while (fscan (list, imgname) != EOF)
	    {
	    if (imgname != rs1)
	    	{
		print (imgname, >> cleanimlist)
		}
    	    }
    	}	    

    else
    	{
	if (l_rccorr) templist=rcimgslist
	else templist=imgslist
	
	copy (templist, l_outlist, >& "dev$null")
	}
	
    # Now let the world know mission was completed sucessfully...
        
    rcimages.check="OK"
    
    # Clean up
    
    if (l_silent==no)
    	{
	print ("")
    	print ("Cleaning up ...")
    	}
	
    if ((l_sub1st) && (l_rccorr))
    	{
    	print ("Deleting ", topoflist, " ...")
    	imdelete (topoflist, ver-)
    	}
    if (l_rccorr) delete (rcimgslist, ver-, >& "dev$null")
    delete (imgslist, ver-, >& "dev$null")
    
    if (l_silent==no)  print ("")    


end
