#  midpt.cl
#
#  Calculates the median of a list of numbers.
#  Is there no IRAF task that already does this??
#
#  Mike Hoenig, 08-02-99

procedure midpt (data)

file data 	{prompt="List of input numbers"}
real median	{"", prompt="Resultant median"}

struct *nolist	{prompt="Leave this one alone..."}

begin

file l_data

file sortedata      # the sorted version of the input list of numbers
int nonos   	    # no. if numbers in sorted list
int midpt   	    # no. of middle element in list
int n	    	    # counter

l_data=data

sortedata=mktemp("sorted")//".list"

sort (l_data, column=0, ignore_white=no, numeric_sort=yes, reverse_sort=no, >> sortedata)

count (sortedata) | scan (s1)

nonos=int(s1)

# OK, this is not 100% kosher. In cases where the list has an EVEN number of
# elements the expression below will produce a non-integer number, which will
# be truncated however due to the fact that I have defined midpt as an integer!
# So I'm not picking out the true middle element...
# Considering the length of lists I am dealing with, I doubt that makes any
# practical difference though!

midpt=(nonos+1)/2

# Now loop to pick out the middle element - is there no more elegant way to do
# this?

n=1
nolist=""; nolist=sortedata
while (fscan (nolist, s1) != EOF)
    {
    if (n==midpt)
    	{
	midpt.median=real(s1)
	}
    n+=1
    }

delete (sortedata, ver-, >& "dev$null")


end
