#  getstats.cl
#
#  gets sky and rms noise levels from images
#  (written with CIRSI images in mind)
#
#  Mike Hoenig, 04-02-99
#
#  08-02-99: updated code to use median (instead of mean) of values
#   	     had to write my own median task for this!


procedure getstats (infiles)

file infiles	{prompt="Images to be analyzed"}
string outfile	{"getstats.out", prompt="Name of file to contain the output data"}
int edge  	{100, prompt="Edge region of image to ignore"}
int step    	{50, prompt="Step size (in pixels) to use for grid"}
bool runnoyes	{no, prompt="Write run no. to output file as well?"}

struct *list2	{prompt="Leave this one alone..."}


begin

# Define local variables

file l_infiles	    	    # input files
string l_outfile    	    # name of output file
int l_edge	    	    # edge value
int l_step  	    	    # step size
bool l_runnoyes     	    # write out run no.?

file imgslist	    	    # list of input files
int noimages	    	    # no. of images\
string image1	    	    # 1st image in list
int xsize, ysize  	    # size of x axis of 1st image
int usearea    	    	    # effective are to be used in the x & y directions
file imcurfile	    	    # the file containing the input ciursor positions
string imgname	    	    # name of current image while scanning list
file imxlogfile     	    # the imexamine output log file
string s4, s5, s6, s7	    # more temp. strings for scanning!
file midptsfile, stdevsfile # temp. file (per image) for stats
string avmidpt, avstdev     # average median & std dev. per image
string runno, lastbit	    # run number / part of filename after 1st "_"
int pos_1, pos_2    	    # positions 1 & 2 of "_" (used to parse out run #)

l_infiles = infiles
l_outfile = outfile
l_edge = edge
l_step = step
l_runnoyes = runnoyes


imgslist=mktemp("infiles")//".list"

sections (l_infiles, option="fullname", > imgslist)
noimages = sections.nimages
print ("\nAnalyzing ", noimages, "images.")
 
# use first image in list to get image dimensions - BEWARE! 
# am assuming all the images in a list will be of similar dimensions

type (imgslist) | scan (image1)

imgets (image1, "i_naxis1")
xsize = int(imgets.value)

imgets (image1, "i_naxis2")
ysize = int(imgets.value)

if (ysize != xsize)
    {
    print ("\nWarning: "//image1//" has different x and y dimensions -")
    print ("x: "//xsize)
    print ("y: "//ysize)
    print ("This program uses the x size when creating its grid.")
    }

usearea = xsize - 2 * l_edge

# Create grid for imexamine cursor...

print ("\nCreating grid for imexamine cursor ...")

imcurfile=mktemp("grid")//".imcur"

for (i=l_edge; i<=(l_edge+usearea); i+=l_step)
    {
    for (j=l_edge; j<=(l_edge+usearea); j+=l_step)
    	{
    	print (i//"\t"//j//"\t101\tm", >> imcurfile)
	}
    }

# Now get the stats!

print ("\nNow obtaining image statistics ...\n")

if (access(outfile)) delete (outfile, ver-, >& "dev$null")
    
list = imgslist
while (fscan (list, imgname) != EOF)
    {
    print ("Performing imexamines on: ", imgname)
    
    imxlogfile = substr(imgname, 1, (stridx (".", imgname))-1)//".stats"

    imexamine (input=imgname, image=imgname, logfile=imxlogfile, keeplog=yes,
    ncstat=5, nlstat=5, imagecur=imcurfile, use_display=no, >& "dev$null")
    
    print ("averaging ...")
    
    midptsfile = substr(imgname, 1, (stridx (".", imgname))-1)//".midpts"
    stdevsfile = substr(imgname, 1, (stridx (".", imgname))-1)//".stdevs"

    list2 = ""; list2 = imxlogfile
    while (fscan (list2, s1, s2, s3, s4, s5, s6, s7) != EOF)
    	{    
    	if (s1 != "#")
    	    {
	    print (s4, >> midptsfile)
	    print (s5, >> stdevsfile)
    	    }	
    	}
    
    midpt (midptsfile)
    avmidpt=midpt.median
    midpt (stdevsfile)
    avstdev=midpt.median
    
    # Now write to output file
    
    if (l_runnoyes)
    	{
	pos_1=stridx("_", imgname)
	lastbit=substr(imgname, (pos_1+1), strlen(imgname))
	pos_2=stridx("_", lastbit)
	runno = substr (imgname, (pos_1+1), (pos_1+pos_2-1))
	
	print (runno, "\t", avmidpt, "\t", avstdev, >> l_outfile)
	}
    
    else
    	{
	print (avmidpt, "\t", avstdev, >> l_outfile)
	}	
        
    }
    
print ("\nResults written to "//l_outfile)

print ("\nCleaning up ...")

delete (imgslist, ver-, >& "dev$null")    
delete (imcurfile, ver-, >& "dev$null")    
delete ("*.stats", ver-, >& "dev$null")    
delete ("*.midpts", ver-, >& "dev$null") 
delete ("*.stdevs", ver-, >& "dev$null")

print ("") 
            
    
end
