# IRAF script: avgplot
#
#  Plots average signal of one set of images (run number) against another
#  Should show how similar our sets of data are! 
#  (quickly cannibalized from photrans code)
#  
#  Mike Hoenig, December '98


procedure avgplot (runno1, runno2)

string runno1   {prompt="First run number to use"}
string runno2   {prompt="Second run number to use (NB. must be same no. of files)"}
string chipquad {"c1q2", prompt="Chip and quadrant (eg. 'c1q2')"}
string avg      {"mean", prompt="Type of average to be used by GSTAT",
                 enum="mean|midpt|mode|stddev"}
string xrang   	{"*", prompt="Range of x-coordinates to be used"}		 
string yrang   	{"*", prompt="Range of y-coordinates to be used"}		 

begin


    # Define local variables

    string l_runno1  	    # run no. 1
    string l_runno2  	    # run no. 2
    string l_chipquad	    # chip, quadrant
    string l_avg	    # GSTAT average to use
    string l_xrang  	    # x range
    string l_yrang  	    # y range

    file imglist1  	    # filename of 1st list of images
    file imglist2  	    # filename of 2nd list of images
    file imglist1_2  	    # filename of 1st and 2nd list of images (pasted together)
    string immask1  	    # expression for 1st list of images
    string immask2  	    # expression for 2nd list of images
    int noimages1  	    # no. of input images - 1
    int noimages2  	    # no. of input images - 2
    string imgname1 	    # name of input image in 1st list
    string imgname2 	    # name of input image in 2nd list
    string imgname  	    # temp. file for scanning for filenames
    real imavg1  	    # temp. file for taking image averages
    real imavg2  	    # 
    file datafile	    # the final data file (for plotting)
    string lab_x     	    # x-axis label (complex string concatenation possible)
    string lab_y     	    # y-axis label
    string lab_title	    # title of graph
    string imgname1_sec	    # the image name string, including the [X:X,X:X] info
    string imgname2_sec	    # the image name string, including the [X:X,X:X] info
    
    
    l_runno1 = runno1
    l_runno2 = runno2
    l_chipquad = chipquad
    l_avg = avg
    l_xrang = xrang
    l_yrang = yrang


    # Make sure STSDAS is loaded (needed for GSTAT)

    if (!defpac("stsdas"))
    	{
    	stsdas motd-
    	}


    imglist1="filenames1.list"
    imglist2="filenames2.list"
    imglist1_2="filenames1_2.list"
    if (access(imglist1)) delete (imglist1, ver-, >& "dev$null")
    if (access(imglist2)) delete (imglist2, ver-, >& "dev$null")
    if (access(imglist1_2)) delete (imglist1_2, ver-, >& "dev$null")
    
    # The following construction is the best I could do, the only thing it doesn't
    # catch is files without _any_ prefix - which should hopefully be a thing of the
    # past anyway.
    
    immask1="*_"//l_runno1//"_"//l_chipquad//"_???.fits"
    immask2="*_"//l_runno2//"_"//l_chipquad//"_???.fits"
    
    sections (immask1, option="fullname", > imglist1)
    noimages1 = sections.nimages
    sections (immask2, option="fullname", > imglist2)
    noimages2 = sections.nimages
    
    if (noimages1!=noimages2)
    	{
	print ("")
	print ("ERROR: There seems to be a mismatch between the number of images")
	print (" for each run number!")
        print ("run no. "//l_runno1//": "//noimages1//" images")
        print ("run no. "//l_runno2//": "//noimages2//" images")
        print ("Please check your input files again...")
	print ("")
	beep
	bye
	}

    print ("")
    print ("No. of images per run number is: ", noimages2)
    print ("")
    
    # cheeky me, I just dropped to the shell to run paste - or does anyone know a
    # way in IRAF to concatenate two lists in parallel?
    
    !paste filenames1.list filenames2.list > filenames1_2.list

    # Now run through the images and get an average from both

    datafile="photrans_data.list"
    if (access(datafile)) delete (datafile, ver-, >& "dev$null")

    list=imglist1_2
    while (fscan (list, imgname1, imgname2) != EOF)
        {
	print ("Now processing images: ", imgname1, " and ", imgname2)
	
    	imgname1_sec=imgname1//"["//l_xrang//","//l_yrang//"]"
	gstatistics (imgname1_sec, fields=l_avg, >& "dev$null")
    	# note rather clumsy construction here. better would be:
	# imavg = gstpar.//l_avg or something. but that doesn't seem to work!
	if (l_avg=="mean") imavg1=gstpar.mean
    	if (l_avg=="midpt") imavg1=gstpar.midpt
    	if (l_avg=="mode") imavg1=gstpar.mode
    	if (l_avg=="stddev") imavg1=gstpar.stddev
	
    	imgname2_sec=imgname2//"["//l_xrang//","//l_yrang//"]"
	gstatistics (imgname2_sec, fields=l_avg, >& "dev$null")
    	# note rather clumsy construction here. better would be:
	# imavg = gstpar.//l_avg or something. but that doesn't seem to work!
	if (l_avg=="mean") imavg2=gstpar.mean
    	if (l_avg=="midpt") imavg2=gstpar.midpt
    	if (l_avg=="mode") imavg2=gstpar.mode
    	if (l_avg=="stddev") imavg2=gstpar.stddev

	print (imavg1, imavg2, >> datafile)
	}
	
  
    # Now plot with sgraph!
    
    print ("")
    print ("Plotting ...")
    
    lab_x=l_avg//" of "//l_runno1 
    lab_y=l_avg//" of "//l_runno2
    lab_title="Run nos. "//l_runno1//" & "//l_runno2//"  "//l_chipquad//"  "//"["//l_xrang//","//l_yrang//"]"
    
    sgraph (datafile, device="stdgraph", append=no, fill=yes, pointmo=yes, 
    	    marker="circle", szmarke=7, wl=0, wr=0, wb=0, wt=0, logx=no,
	    logy=no, box=yes, grid=no, ticklab=yes, xlabel=lab_x, ylabel=lab_y,  
	    title=lab_title, sysid=yes)
    
    # Clean up
    
    print ("")
    print ("Cleaning up ...")
    
    delete (imglist1, ver-, >& "dev$null")
    delete (imglist2, ver-, >& "dev$null")
    delete (imglist1_2, ver-, >& "dev$null")
    
    print ("")    


end
