# Meghan Gray december 10 1998
# *adds on to 2nd pass sky procedure (skytwo.cl)
# *takes skysubtracted images (s2t*.fits) and object masks used in 2nd pass
#	sky (st*.pl) to do destriping at a quadrant level for each image
# *outputs destriped images of form ds2t*.fits
# *for chips 2 and 4, images are rotated by 90 deg for analysis and then
#	rotated back

procedure destripe(dorotation)

bool dorotation		{yes, prompt="rotate images? (for chips 2 and 4)"}

begin
        string skysubim,objmask,cleanim,newim
        real mp
	bool dorot

	if (!defpac("stsdas"))
	    stsdas
        noao
	artdata
	
	dorot=dorotation
	
#create list of original object files
	if(access("destripe.in")) delete("destripe.in")
	files("%s2%%*%.fits%%", >> "destripe.in")
	
	list="destripe.in"
	while(fscan(list,s1)!=EOF){
	    # rotate images for chips 2 and 4
	    print("")
	    if (dorot) {
		print("rotating images...")
		rotate("s2"//s1//".fits","s2r"//s1//".fits",90)
		rotate("s"//s1//"objmask.pl","sr"//s1//"objmask.pl",90)
		s2=s1
		s1="r"//s1
	    }
	    
	    skysubim="s2"//s1
	    objmask="s"//s1//"objmask"
	    cleanim="s2"//s1//"_clean"
	    
	    #calculate median value of sky-sub image and replace masked regions
##
##	NOTE:  this is note the best way to do this!  Instead of replacing the masked objects
##		with the median of the sky over the whole image, it should be done row by row
##		ie.  the object pixels should be replaced with the median of the sky pixels for
##		that row to make it nice and smooth, otherwise they still end up biasing the
##		result (although at a low level)  But I can't be arsed to figure out how to
##		do this in an efficient manner just yet...
##

#	    gstat(skysubim//".fits",fields="midpt",mask=objmask//".pl", >& "dev$null")
#	    mp=gstpar.midpt
	    mp = 0
	    print(s1)
	    print("making cleaned image...")
	    imexpr("b ? "//mp//" : a",cleanim//".fits",skysubim//".fits",objmask//".pl",verb-)
	    
	    #separate cleaned images and original images into quadrant images
	    #  3  4
	    #  1  2
	    print("dividing images into quadrants...")
	    imcopy(skysubim//".fits[1:512,1:512]",      skysubim//"_q1.fits",verb-)
	    imcopy(skysubim//".fits[513:1024,1:512]",   skysubim//"_q2.fits",verb-)
	    imcopy(skysubim//".fits[1:512,513:1024]",   skysubim//"_q3.fits",verb-)
	    imcopy(skysubim//".fits[513:1024,513:1024]",skysubim//"_q4.fits",verb-)
	    
	    imcopy(cleanim//".fits[1:512,1:512]",      cleanim//"_q1.fits",verb-)
	    imcopy(cleanim//".fits[513:1024,1:512]",   cleanim//"_q2.fits",verb-)
	    imcopy(cleanim//".fits[1:512,513:1024]",   cleanim//"_q3.fits",verb-)
	    imcopy(cleanim//".fits[513:1024,513:1024]",cleanim//"_q4.fits",verb-)
	    
	    #destripe each quadrant (subtract median of each row of cleaned image from original image)
	    j=1
	    while(j<=4){
		print("destriping quadrant"//j)
		imexpr("a-median(b)",skysubim//"_q"//j//"_ds.fits",skysubim//"_q"//j//".fits",cleanim//"_q"//j//".fits")
		j=j+1
	    }
	    
	    #make an empty image with the same header as the sky-subtracted image
	    print("making new image ","d"//skysubim//".fits...")
	    newim="d"//skysubim
	    mkpattern(newim//".fits",pattern="constant",option="replace",v1=0.,ndim=2,ncols=1024,nlines=1024)
	    mkheader(newim//".fits",skysubim//".fits")
	    
	    #reassemble image
	    print("assembling quadrants...")
	    imcopy(skysubim//"_q1_ds.fits[1:512,1:512]",newim//".fits[1:512,1:512]",verbose+)
	    imcopy(skysubim//"_q2_ds.fits[1:512,1:512]",newim//".fits[513:1024,1:512]",verbose+)
	    imcopy(skysubim//"_q3_ds.fits[1:512,1:512]",newim//".fits[1:512,513:1024]",verbose+)
	    imcopy(skysubim//"_q4_ds.fits[1:512,1:512]",newim//".fits[513:1024,513:1024]",verbose+)
	    
	    #rotate final image to original orientation
	    if (dorot){
		print("rotating image...")
		rotate(newim//".fits","ds2"//s2//".fits",-90)
		delete(newim//".fits")
#		delete(skysubim//".fits")
#		delete(objmask//".pl")
	    }
	    
	    #delete quadrant images
	    j=1
	    while(j<=4){
		delete(cleanim//"_q"//j//".fits")
		delete(skysubim//"_q"//j//".fits")
		delete(skysubim//"_q"//j//"_ds.fits")
		j=j+1
	    }
#	    delete(cleanim//".fits")
	}
end


