# IRAF script -- ccleanskye
#                
#    function: to produce the location of mask of objects and then clean
#                the objects.
#	
#    stage: 
# programmer: sjchan 
#             7may98: created
#           
##

procedure ccleansky(imglist, fwhmob, threshold, imgout, objcoo, edrad)

string imglist  {"@input.in", prompt="(@List of or *.fits) input images", mode="ql"}
real   fwhmob   {5.0, prompt="FWHM of the normal objects in pixels", mode="ql"}
real   threshold {3.5, prompt="Threshold in sigma for feature detection", mode="ql"}
string imgout {"cleansky.in", prompt="list of output star-clean iamges", mode="ql"}
string objcoo {"objcoo.in", prompt="List of output location of objects", mode="ql"}
real   edrad  {2.5, prompt="Radius of the aperture mask (fwhmob unit)", mode= "ql"}

struct *filist, *folist
struct *filist2

begin

     string imglist1        #i input list string
     string imgout1         #o filename of output list (might not need it)
     real   fwhmob1         #i apphot.datapars.fwhmpsf
     real   threshold1      #i apphot.findpars.threshold
     string objcoo1         #o final version of objects coordinates list
     string framein         #i input image in the input list
     string frameout        #o output clean-sky frame
     string ind             # indicator for cleaning sky
     string ifile           # final version of input list
     string ofile           # final version of output list
     string ccleanskyelog    #o logfile
     string tcenfled       #o input coordinate file for imedit 
     real   edskysig       #  input sigma for imedit  
     real   edsigfac       #  sigma factor  
     real   edrad1s          # subsitution radius (star-like objs)
     real   edrad1b          # subsitution radius (big non-star-like objs)
     real   edbuf1s, edbuf1b    # background buffer width
     real   edwidth1s, edwidth1b   # background width
     int    idot           # the locate of the last "." in the input filename
     int    ncc            # dummy counter
     string templog        # templogfile for _fobjcoo
     string edcurfl        # imedit cursor file
     string edtemp         # string cursor for imedit "  1   b"
     int    ic1, ic2       # dummy counters
     real   xc, yc         # dummy xcen, ycen
     string  ss3           # dummy variable

     # Get the rest of the parameter
     imglist1   = imglist
     fwhmob1    = fwhmob
     threshold1 = threshold
     imgout1 = imgout
     objcoo1 = objcoo
     edrad1s  = edrad
     edrad1s  = edrad1s * fwhmob1; edrad1b = 2.0 * edrad1s
     edbuf1s  = 0.5 * edrad1s; edbuf1b = 2.0 * edbuf1s
     edwidth1s = edrad1s; edwidth1b = 2.0 * edwidth1s
     edskysig = 1.0; edsigfac = 1.0
     ind = "CS"  # cleaning sky
     ccleanskyelog = "ccleanskye.log"
     ifile = mktemp("ccsifl")
     tcenfled = "tcenfled.coo" 
     idot = 1
     templog = "_fobjcoo.log"
     edcurfl = "edcurfl.coo"
     edtemp  = "  1   b"
#     edsigfac = 0.75

    # Check the existence global files
     if (access(ccleanskyelog))
          delete(ccleanskyelog, ver-, >& "dev$null")
     if (access(ifile))
          delete(ifile, ver-, >& "dev$null")
     if (access(imgout1))
          delete(imgout1, ver-, >& "dev$null")
     if (access(objcoo1))
          delete(objcoo1, ver-, >& "dev$null")

 
    # Find out the suitable input option
       _finout(imglist1, ind, ifile, imgout1)
  
     print("", >> ccleanskyelog)
     print("Input threshold: ", threshold1, >> ccleanskyelog)
     print("Input normal fwhmobj: ", fwhmob1, >> ccleanskyelog)
     print("Input Radius of normal aperture mask (pix): ", edrad1s, >> ccleanskyelog)
     print("Radius of aperture mask for big objs (pix):", edrad1b, >> ccleanskyelog) 
     print("", >> ccleanskyelog)

   # Read the input image from the list and perform the cleaning process
     filist = ""; filist = ifile     # open the files
     folist = ""; folist = imgout1
     ncc = 0
     while( (fscan(filist,framein) != EOF) && (fscan(folist,frameout) != EOF) )
       {
          ncc += 1
          print("========================================", >> ccleanskyelog)
          print("")
          print("input image: ", framein)
          print("input image: ", framein, >> ccleanskyelog)
          print("")
          print("", >> ccleanskyelog)
          print("Now making coordinate list for cleaning")
          print("Making coordinate list for cleaning", >> ccleanskyelog)

         # make file name for object coordinate
           _locate(framein, ".") # locate the last dot in the string
           idot = _locate.value
           tcenfled = substr(framein, 1, idot)//"coo"
           print(tcenfled, >> objcoo1)
           print("Coordinate list: ", tcenfled)
 
         # get the object coordinate and skysigma (background sigma)
           _fobjcoo(framein, fwhmob1, threshold1, tcenfled)  
           edskysig = _fobjcoo.skysig * edsigfac

           print("Now cleaning the sky")
           unlearn type
           type (templog, >> ccleanskyelog)
           print("Final Coordinate list : ", tcenfled, >> ccleanskyelog)
           print("", >> ccleanskyelog)
           print("Cleaning the sky:", >> ccleanskyelog)
           print("Output cleaned-sky image: ", frameout, >> ccleanskyelog)

          if (access(edcurfl))
             delete(edcurfl, ver-, >& "dev$null")

         # Make a cursor file for imedit
           ic1 = 0; ic2 = 0
           filist2= ""; filist2= tcenfled
           while(fscan(filist2, xc, yc, ss3) != EOF)
             {
               if (ss3 == "SS")
                 {
                   ic1 += 1
                   if (ic1 == 1)
                     {
                      print(":radius ", edrad1s, >> edcurfl)
                      print(":buffer ", edbuf1s, >> edcurfl)
                      print(":width ", edwidth1s, >> edcurfl)
                     }
                   print(xc, yc, edtemp, >> edcurfl)
                 } # this brace is from if block (ss3 == "SS")
   
               if (ss3 == "BB")
                 {
                   ic2 += 1
                   if (ic2 == 1)
                     {
                      print(":radius ", edrad1b, >> edcurfl)
                      print(":buffer ", edbuf1b, >> edcurfl)
                      print(":width ", edwidth1b, >> edcurfl)
                     }
                   print(xc, yc, edtemp, >> edcurfl)
                 } # this brace is from if block (ss3 == "BB") 

             } # this block is from while block(tcenfled; xc,yc,,ss3)

           unlearn imedit
           imedit (framein, frameout, cursor = edcurfl, display = no,
               radius=edrad1s, buffer=edbuf1s, width=edwidth1s, sigma=edskysig)
#           delete(edcurfl, ver-, >& "dev$null")
        
       } #this brace is from while block (filist, framein & folist, frameout)
         filist = ""; folist= "" # close the files

          print(" <<=========== CCLEANSKYE DONE ==============>>")
          beep; beep; beep

end



