# IRAF script -- _mkrnoifl.cl
#	
#   this is a main file management task which is a HIDDEN task.
#    user cannot this it in the front end.
#   function: to make a column of running number providing a range of 
#                running number
#
# programmer: sjchan 
#      history:  8april98 -- created
#                4june98 -- add an option: coma "," as a delimiter
#		23march99 -- mhoenig: added srno_1 & srno_2 parameters, which are now
#		 used by cndrproc to create a unique name for each sky frame
#		16april99 -- mhoenig: added the "if (ilocd > 0)" to those last
#		 two lines... otherwise won't work with single run no.
#		21april99 -- mhoenig: added more conditions at the end. Now
#		 catches every case, especially when one uses two comma-separated
#		 run nos. (as I often do!) - name of sky image is now OK.
#			  -- hmm, after all that it turns out it's more reliable
#			      to just parse the run no. list in cndrproc! I'll
#			      leave my cool code in though, commented out...
#

procedure _mkrnoifl(rnorange, trnofl)

string	rnorange   {"xxxx-xxxx,xxxx",prompt="Input range of runo ",mode="ql"}
string  trnofl     {"rnofile",prompt="Output file containing a column of running number", mode="ql"}
string  srno_1     {prompt="output: first run no. in sequence (leave it alone...)"}
string  srno_2     {prompt="output: last run no. in sequence (leave it alone...)"}
begin
        string  rnorange1      #i Input range of running number
        string  trnofl1    #o Output file containing a column of running nubmer
        string  srno1, srno2   # min and max of the running number in string
        int     irno1, irno2   # min and max of the running number in integer 
        string  srno          #current running number in string in the for loop
        int     irno         #current running number in integer in the for loop
        int     ilen           # length of the input string in integer
        int     ilocd          # the location of "-" in the input range string
        int     i, ii          # dummy counter
        int     icoma          # the coma",' location
        string  ss[20]         # temporary substrings of input string
        int     ntime          # maximum of substring            
        int     ic             # comma counter
        string  stemp          # dummy substring
        int     istemp         # length of the dummy substring
	
	# int icmax

     #  Get the rest of the parameters

        rnorange1 = rnorange
        trnofl1   = trnofl
        ntime     = 20
        stemp     = rnorange1

        if (access(trnofl1))
            delete(trnofl1, ver-, >& "dev$null")

     # find out how many substrings (delimiter is ",")
       ilen=strlen(rnorange1)

       # icmax=0

       for (ic = 1; ic <= ntime; ic += 1)
         {
          if (ic == 1)
            {              
              icoma = stridx("," , rnorange1)
              if (icoma == 0)  # cannot find comma in the substring
                {
                  ss[1] = substr(rnorange1, 1, ilen)
                  goto lab
                }
              else
                  ss[1] = substr(rnorange1, 1, icoma-1)
             
              stemp = substr(rnorange1, icoma+1, ilen) # update the substring
            } # this brace is from if block (ic == 1)
           else   # (ic > 1)
              {
                 istemp = strlen(stemp)
		 
	         # icmax = ic   
	     
                 icoma = stridx("," , stemp)
                 if (icoma == 0)  # cannot find coma in the substring
                   {
                       ss[ic] = substr(stemp, 1, istemp)
                       goto lab
                   }
                 else 
                   {
                       ss[ic] = substr(stemp, 1, icoma-1)
                   }
               stemp = substr(stemp, icoma+1, istemp) # update the substring
	     
             } # this brace is from if block (ic > 1)
	  
         } # this brace is from for block (ic=1, ntime)


     lab: 
     # find out the location of "-" within the range string
     # if ilocd = 0, ONLY ONE SINGLE running number
     # if ilocd > 0 , it is a RANGE

       for (ii = 1; ii <= ic; ii += 1)
         {

            ilocd = stridx ("-", ss[ii])
            
	    if (ilocd == 0)
               print(ss[ii], >> trnofl1)
            else if (ilocd > 0)
              {
                srno1 = substr(ss[ii], 1, ilocd-1)
                irno1 = int(srno1)
                srno2 = substr(ss[ii], ilocd+1, ilen)
                irno2 = int(srno2)
                 irno  = irno1
 
                for (i = 1; i <=1000; i += 1)  
                  {
                     print(irno, >> trnofl1)
                     if (irno == irno2)
                      break
                   irno += 1
                   } # this brace is from for loop (i = 1, 1000)

              }  # this brace is from else if block (ilocd > 0)

          } # this brace is from for block (ii=1 to ic)


# This is the cool bit...

# if (ilocd > 0)				#  dashes
#	{
#	srno_1 = srno1
#	srno_2 = srno2
#	}
	
# else if ((ilocd == 0) && (icmax > 1))	#  no dashes... but commas
#	{
#	srno_1 = ss[1]
#	srno_2 = ss[icmax]
#	}
	
# else if ((ilocd == 0) && (icmax <= 1))	#  just one run no.
#	{
#	print ("How do you want to perform sky subtraction with just one image??")
#	srno_1 = ss[1]
#	srno_2 = ss[1]
#	}


end

