/* printwcs.c -- print WCS info to stdout */

#include <stdio.h>
#include <stdlib.h>
#include "irdr.h"

int main(int argc, char *argv[])
{
    int nx, ny;
    double ra, dec, scale, secpix1, secpix2;

    if (argc != 2)
        eprintf("Usage: %s file.fits\n", argv[0]);

    if (get_wcs(argv[1], &ra, &dec, &scale) < 0)
        eprintf("%s: get_wcs failed\n", argv[0]);

    if (get_key_int(argv[1], "NAXIS1", &nx) < 0)
        eprintf("%s: failed reading NAXIS1\n", argv[0]);

    if (get_key_int(argv[1], "NAXIS2", &ny) < 0)
        eprintf("%s: failed reading NAXIS2\n", argv[0]);

    if (get_key_double(argv[1], "SECPIX1", &secpix1) >= 0 &&
        get_key_double(argv[1], "SECPIX2", &secpix2) >= 0 ) {
        scale = (secpix1 + secpix2) / 2.;
    }

    printf("%f %f %f %d %d\n", ra, dec, scale, nx, ny);

    return 0;
}
