#!/usr/bin/env perl
#
# median combine all loops for each chip with dome lamp off, and with lamp
# on, and take the difference to form flatfield per chip.  (skip loop 1 due
# to reset anomaly).  call gainmap.c to convert the flatfield to a bad 
# pixel / gain map.
#
# Jan 2001
# May 2002 : Loop 1 not skipped
#

die "Usage: domeflat.pl on_runbeg on_runend off_runbeg off_runend" .
    " [nsig nxblock nyblock mingain maxgain]\n" 
    unless ($#ARGV == 3 or $#ARGV == 8);

@chips   = (1, 2, 3, 4);
@onruns  = ($ARGV[0] .. $ARGV[1]);
@offruns = ($ARGV[2] .. $ARGV[3]);
@loops   = (1..99);                                   
$onlist  = "./domeflat.onlist";
$offlist = "./domeflat.offlist";
$|       = 1;                             # turn off output buffering

$basedir = $ENV{'IRDR_BASEDIR'};

die "Please setenv IRDR_BASEDIR /path/irdr\n"
    unless ($basedir);

$datadir = $ENV{'IRDR_DATADIR'};

die "Please setenv IRDR_DATADIR /path/irdr\n"
    unless ($datadir);

$bpmprog = "$basedir/bin/gainmap";
$calcprog = "$basedir/bin/imcalc";
$cubeprog = "$basedir/bin/cubemean";

die "Expected executables: $bpmprog, $calcprog, and $cubeprog\n"
    unless (-x $bpmprog and -x $calcprog and -x $cubeprog);

for ($i = 0; $i <= $#chips; $i++) {                   # foreach chip
    $chip = "c$chips[$i]";

    $non = 0;   $noff = 0;

    open(ONLIST, "> $onlist");                        # make file lists
    open(OFFLIST, "> $offlist");

    for ($j = 0; $j <= $#onruns; $j++) {              # foreach lamp on run
        $run = sprintf("%05d", $onruns[$j]);

        for ($l = 0; $l <= $#loops; $l++) {             # foreach loop
            $loopno = sprintf("%03d", $loops[$l]);

            $infn = "$datadir/irx_${run}_${chip}_${loopno}.fits";

            if (-e $infn) {                             # add to filelist
                print ONLIST "$infn\n";
                $non += 1; 
            }
        }
    }

    for ($j = 0; $j <= $#offruns; $j++) {              # foreach lamp off run
        $run = sprintf("%05d", $offruns[$j]);

        for ($l = 0; $l <= $#loops; $l++) {             # foreach loop
            $loopno = sprintf("%03d", $loops[$l]);

            $infn = "$datadir/irx_${run}_${chip}_${loopno}.fits";

            if (-e $infn) {                             # add to filelist
                print OFFLIST "$infn\n";
                $noff += 1; 
            }
        }
    }
    
    close(ONLIST);  close(OFFLIST);
    
    print "Warning: Found no lamp off flats, chip $chip, not making gainmap\n"
        unless ($noff > 0);

    print "Warning: Found no lamp on flats, chip $chip, not making gainmap\n"
        unless ($non > 0);

    if ($noff > 0 and $non > 0) {
        print "\nMedian combine dome lamp on images to make on.fits\n";

        $cmd = "$cubeprog $onlist on.fits NULL offset median noweight float";

        print "Running combine command:\n$cmd\n";

        die "Sorry, command $cmd failed on: $onlist\n"
            unless (system($cmd) == 0);

        print "\nMedian combine dome lamp off images to make off.fits\n";

        $cmd = "$cubeprog $offlist off.fits NULL offset median noweight float";

        print "Running combine command:\n$cmd\n";

        die "Sorry, command $cmd failed on: $offlist\n"
            unless (system($cmd) == 0);

        $flat = "./flat.${chip}.fits";
        $gain = "./gain.${chip}.fits";

        print "\nSubtract lamp off from lamp on to make: $flat\n";

        $cmd  = "$calcprog on.fits '-' off.fits $flat";

        print "Running subtract command:\n$cmd\n";

        die "Sorry, command $cmd failed\n"
            unless (system($cmd) == 0);

        print "\nNormalize $flat and set bad pixels to 0.0 to make: $gain\n";

        if ($#ARGV == 3) {
            $cmd = "$bpmprog $flat $gain";
        } elsif ($#ARGV == 8) {
            $cmd = "$bpmprog $flat $gain $ARGV[4] $ARGV[5] $ARGV[6] $ARGV[7]" .
                   " $ARGV[8]";
        }

        print "Running normalize command:\n$cmd\n";

        die "Sorry, command $cmd failed on: $flat\n"
            unless (system($cmd) == 0);
    }
}

if (-e $onlist) { `rm $onlist`; }
if (-e $offlist) { `rm $offlist`; }
