#!/usr/bin/env perl
#
# median combine all loops for each chip to create dark.c?.fits
#
# May 2002
#

die "Usage: dark.pl runbeg runend\n" 
    unless ($#ARGV == 1);

@chips   = (1, 2, 3, 4);
@runs  = ($ARGV[0] .. $ARGV[1]);
@loops   = (1..99);                                   
$list  = "./dark.list";
$|       = 1;                             # turn off output buffering

$basedir = $ENV{'IRDR_BASEDIR'};

die "Please setenv IRDR_BASEDIR /path/irdr\n"
    unless ($basedir);

$datadir = $ENV{'IRDR_DATADIR'};

die "Please setenv IRDR_DATADIR /path/irdr\n"
    unless ($datadir);

$cubeprog = "$basedir/bin/cubemean";

die "Expected executable $cubeprog\n"
    unless (-x $cubeprog);

for ($i = 0; $i <= $#chips; $i++) {                   # foreach chip
    $chip = "c$chips[$i]";

    open(LIST, "> $list");                        # make file lists
    
    $nr = 0;
    for ($j = 0; $j <= $#runs; $j++) {              # foreach dark run
        $run = sprintf("%05d", $runs[$j]);

        for ($l = 0; $l <= $#loops; $l++) {             # foreach loop
            $loopno = sprintf("%03d", $loops[$l]);

            $infn = "$datadir/irx_${run}_${chip}_${loopno}.fits";

            if (-e $infn) {                             # add to filelist
                print LIST "$infn\n";
                $nr += 1; 
            }
        }
    }
    
    close(LIST);  
    
    die "Warning: Found no dark run, chip $chip\n"
        unless ($nr > 0);

  $darkfn = "./dark.${chip}.fits";
    print "\nMedian combine dark images to make dark.c${chip}.fits\n";

    $cmd = "$cubeprog $list $darkfn NULL none median noweight float";

    print "Running combine command:\n$cmd\n";

    die "Sorry, command $cmd failed on: $list\n"
         unless (system($cmd) == 0);

}

if (-e $list) { `rm $list`; }
