/* addtable.c
**
** Inserts a binary table into a MEF fits file.
**
** Andrew J. Dean 7th April, 2003
**
*/

#include <stdlib.h>
#include <string.h>
#include "fitswrap.h"

#define MAXLENGTH 200
#define LINEFEED 10

int main(int argc, char* argv[])
{
  
  FILE *fp;            /* For config file */ 
  int length=0;
  int numcol=0;
  int numdata=0;
  int numhead=0;
  float** p_data=NULL;
  char** p_names=NULL;

  char oneline[MAXLENGTH];

  int i=0;
  int j=0;

  /* Check for appropriate input */
  if (argc != 4) {
    fprintf(stderr, 
	    "Usage: %s ME-FITSfile config_file num_entries\n", 
	    argv[0]);
    exit(1);
  }

  sscanf(argv[3],"%d",&numdata);

  /* open the config file */
  if ( (fp = fopen(argv[2],"r")) == NULL ){
    printf("Cannot open file containing configuration data\n");
    exit(1);
  }
  
  /* First line should contain the table column names */
  fgets(oneline,MAXLENGTH,fp);    

  /* Check we didn't exceed the string length, i.e. we have 
     an end of line character (=10) */
  if( strchr(oneline,LINEFEED)==NULL ){
    printf("addtable: ERROR! First line of file is longer than %d characters",
	   MAXLENGTH);
    printf("\naddtable: Edit the source to make this longer");
    printf("\naddtable: (No line feed character found at end of line) ...\n");
    exit(1);
  }
  
  /* Now strip the line feed! */
  length=strlen(oneline);
  length/=sizeof(char);
  /* printf("length of string is %i\n",length); */
  oneline[length-1]='\0';

  /* Find out how many occurences of " " there are 
     Should really look for adjacent spaces too but this only makes
     the array bigger which is safe from a memory allocation point of view 
     the number of columns is found correctly later */

  i=0;
  numcol=1; /*Assume at least one column, if we have spaces there are two! */
  while( oneline[i]!= '\0'){
    if (oneline[i]==' '){
      numcol++;
    }
    i++;
  }
  
  /*  printf("addtable: Number of columns is %d\n", numcol); */
       
  if( (p_names=(char**)malloc(numcol*sizeof(char*))) == NULL ){
    printf("addtable: memory allocation failed\n");
    exit(1); 
  }
  
  /* Chop up the line */
  *(p_names)=strtok(oneline," ");
  i=1;
  while(*(p_names+i-1)!=NULL){
    /*  printf("i=%d %s\n",i-1,*(p_names+i-1)); */
    *(p_names+i)=strtok(NULL," ");   
    i++;
  }

  numcol=i-1;
  /* printf("addtable: Number of columns on attempt 2 = %d\n",numcol); */
  
  if ((p_data=(float **)malloc(numcol*sizeof(float*))) == NULL){
    printf("addtable: memory allocation failed\n");
    exit(1);
  }  
  
  for(i=0; i<numcol; i++){
    if ((p_data[i]=(float *)malloc(numdata*sizeof(float))) == NULL){
      printf("addtable: memory allocation failed\n");
      exit(1);
    }
  }
  
  /* Read in the actual data */
  for(j=0; j<numdata; j++){
    for(i=0; i<numcol; i++){
      fscanf(fp,"%f",*(p_data+i)+j);
      /* printf("%f\n",p_data[i][j]); */
    }
  }

  /* Close the input file containing the file list to be read in */
  fclose(fp);

  /* Insert into the fits file */

  numhead=0;

  if ( insert_table(argv[1], 1, numhead, NULL, NULL, numcol, p_names, 
		    numdata, p_data) ){
    printf("addfibreinfo: insert_table failed");
    exit (1);
  }
  
  /* Clean up */
  free(p_names);

  for(i=0; i<numcol; i++){
    free(p_data[i]);
  }
  free(p_data);

  /*free(format_string);
  free(name_string);
  
  free(fibreid);
  free(xgrid);
  free(ygrid);
  */
  return 0;

}

