#############################################################################
#
# task boxstat
# 
# to find statistics in each of n=(nsidexnside) boxes in an image
#
# RAJ 12.9.00
#############################################################################

procedure boxstat(im,sec,nside)

string im {prompt="MEF file"}
string sec {prompt="image section x1:x2,y1:y2"}
string nside {prompt="box size in pixels"}

begin

string l_im,l_sec
real l_nside
string sciname,varname,dqname,timname,imph,imsci,secarr[4000]
string xvals,yvals
int nexn,nimset,totexn,naxis1,naxis2,boxsize1,boxsize2
int xstart,xend,ystart,yend,numsec,i,j,k,xlen,ylen
int x1,x2,y1,y2,xnumbox,ynumbox

##query parameters
l_im=im
l_sec=sec
l_nside=real(nside)

##hardwired pars should go in package parameters
##hardwired num of extensions per imset
nexn=4
##hardwired header extname for extensions
sciname="SCI"
varname="VAR"
dqname="DQ"
timname="TIME"

##get MEF file info
imph=l_im//"[0]"

##get number of extension in file
hselect(imph,"nextend","yes") | scan(totexn)

##number of imsets
nimset=totexn/nexn

##box info
#get this from the first science extension
imsci=l_im//"[sci,1]"
print(imsci)
hselect(imsci,"naxis1",yes) | scan(naxis1)
hselect(imsci,"naxis2",yes) | scan(naxis2)

#parse section info
print(l_sec) | translit("STDIN", ",", " ") | scan(xvals,yvals)
print(xvals) | translit("STDIN",":"," ") | scan(x1,x2)
print(yvals) | translit("STDIN",":"," ") | scan(y1,y2)
xlen=x2-x1+1
ylen=y2-y1+1
#print("x1 ",x1," x2 ",x2," y1 ",y1," y2 ",y2," xlen ",xlen," ylen ",ylen)

#find the number of boxes on each axis
xnumbox=int(xlen/l_nside)
ynumbox=int(ylen/l_nside)
#print("xnumbox ",xnumbox," ynumbox ",ynumbox)



#get the required sections and write into array secarr
k=1
for(i=0;i<xnumbox;i+=1){
  xstart=x1+i*l_nside
  xend=x1+(i+1)*l_nside-1
  for(j=0;j<ynumbox;j+=1){
    ystart=y1+j*l_nside
    yend=y1+(j+1)*l_nside-1
    secarr[k]=xstart//":"//xend//","//ystart//":"//yend
#    print("k ",k," secarr ",secarr[k])
    k+=1
  }
}
numsec=k

##now for each section find the value in all the science extensions
for(k=1;k<numsec;k+=1){
  secstat(l_im,secarr[k])
}

##write out file which has
##filename
##box1
#results for each read

##box2
#results for each read

end
