# dodisplay.cl script to quickly turn raw data into an ifu image
#
# A.J. Dean 8th Jan, 2002.

procedure dodisplay(name,run_no,dateobs,stackno,interactive)

string name {prompt="Root name"}
string run_no {prompt="Run no."}
string dateobs {prompt="Date of observations"}
string stackno {prompt="Stack the n'th read of every loop, all or av (average)"}
bool interactive {yes, prompt="Run interactively?"}
#string configfile {"CIRPBIN$../IFUdat/cirpass.cfg", prompt="File containing IFU fibre configuration info"}
bool   fixheader {no, mode="lh",prompt="Update the image header keywords to do extraction?"}
string positionfile {mode="lh",prompt="File containing fibre position information"}

begin


	string fname, frunno, fdateobs, fstackno, imaoutroot, imaout, fcfgfile
	string posfile
	int inc, len, beg
	bool fixhead, inter

	fname=name
	frunno=run_no
	fdateobs=dateobs
	fstackno=stackno
	inter=interactive
#	fcfgfile=configfile
	fixhead=fixheader

	if(fixhead){

		posfile=positionfile

	}

	docirpass(name=fname,run_no=frunno,dateobs=fdateobs,stackno=fstackno,
		  interactive=inter)
                #  configfile=fcfgfile)

	## Sort out the PixCel run numbering scheme
	## eg run 1 is numbered run 0001
	## run nos should be 1-9999
    	frunno="000"//frunno
    	len=strlen(frunno)
    	beg=len-3
    	frunno=substr(frunno,beg,len)

	imaoutroot=fname//"_"//frunno//"_ima"
	imaout=fname//"_"//frunno//"_ima.fits"

	inc=1
	while(access(imaout)){
  	imaout=imaoutroot//"."//inc//".fits"
  	inc+=1
	}

	if(inc>2){
		imaout=imaoutroot//"."//inc-2//".fits"
	} else {
		imaout=fname//"_"//frunno//"_ima.fits"
	}

	if(fixhead){

		hedit(imaout//"[0]",fields="EXTRFILE",value=posfile,add+,ver-,update+)
		hedit(imaout//"[0]",fields="DOEXTR",value="PERFORM",add+,ver-,update+)
	}
	
	dotarget(imaout,interactive=inter)

	run_no=frunno+1

end

