# datamonitor.cl
#
# iraf script to watch for the arrival of new data
# reduce it when it arrives, and copy it over to the 
# backup directory
#
# Andrew J. Dean 17th Dec, 2002
#
# Andrew J. Dean Modified 26th Jun, 2003 
# To not use the date written in the monitor file
# but to use the date as returned by the computer that is running this
# program. As this program also decides whether or not to run maketoday, 
# it makes sense for this program to also set the pipeline date, based
# on the same clock!

procedure datamonitor()

string monitorfroot {prompt="File name root of the monitor files"}
string monitordir {prompt="Directory where the monitor files will appear"}
string backupdir {prompt="Directory to backup the reduced files to"}
int    firstfnum {prompt="Pipe Number (Index of the first monitor file to appear)"}
bool   dobackup  {prompt="Backup the files to the Gemini server?"}
bool   ohmask  {prompt="ohmask the IFU images before reconstruction?"}
string logfile {prompt="Text file recording data file names copied to backup directory"}

struct *in {mode="h"}

begin

string froot, mdir, bdir, filename
string name, run, date, stack, tempstring, redfile, moreredfile
string s_year, s_month, s_day, s_pipedate
int pipeday, pipemonth, pipeyear
real accurateyear, accuratediv, remainder
real accuratediv2, remainder2
int inaccuratediv, inaccuratediv2
string s_pipeday, s_pipemonth
int year, month, day
string gemininame, geminilock, geminidir
string docirppars[4]
string months[12]
int daysinmonths[12]
string thehour,junk
string thelogfile
int ithehour, nloops
real firsttime, lasttime, timeobs

int fnum, len, beg
bool exist, idispinter, dodocirpass, dodotarget, dodoflat, dothebackup
bool doohmask, idispmask

froot=monitorfroot
mdir=monitordir
bdir=backupdir
fnum=firstfnum
dothebackup=dobackup
doohmask=ohmask
thelogfile=logfile

months[1]="jan"
months[2]="feb"
months[3]="mar"
months[4]="apr"
months[5]="may"
months[6]="jun"
months[7]="jul"
months[8]="aug"
months[9]="sep"
months[10]="oct"
months[11]="nov"
months[12]="dec"

daysinmonths[1]=31
daysinmonths[2]=28 # Leap year check below
daysinmonths[3]=31
daysinmonths[4]=30
daysinmonths[5]=31
daysinmonths[6]=30
daysinmonths[7]=31
daysinmonths[8]=31
daysinmonths[9]=30
daysinmonths[10]=31
daysinmonths[11]=30
daysinmonths[12]=31

idispinter=idisplay.interactive
#print("idisplay interactive is ",idispinter)
idisplay.interactive=no

# Switch oh masking on or off
idispmask=idisplay.doohmask
idisplay.doohmask=doohmask

# Check for / on end of directory name, and add one if not there
len=strlen(mdir)
if(substr(mdir,len,len)!="/")
  mdir=mdir//"/"
len=strlen(bdir)
if(substr(bdir,len,len)!="/")
  bdir=bdir//"/"

# keep scan happy
year=0
month=0
day=0

# Find out the time and see if we need to run mktoday
junk="notset"
thehour="notset"
ithehour=0

# These added when moving away from reading the data from the monitor
# file, maybe we have more variables than we need
pipeday=0
pipemonth=0
pipeyear=0

#date | scanf("%s %s %s %s %s %s", junk, junk, junk,
#             thehour,junk,junk)

#thehour=substr(thehour,1,2)
#print(thehour) | scanf("%d",ithehour)

date("+%k%m") | scan ithehour

date("+%d") | scan pipeday
date("+%m") | scan pipemonth
date("+%Y") | scan pipeyear

# Variables for testing
#pipeday=1
#pipemonth=1
#pipeyear=2008
#ithehour=2357

# Run mktoday automatically if it's near the start of a night.
# Stop mktoday after 23:55 just in case someone runs this at 23:59:59
# and procedes to call mktoday for the next day! 
if( (ithehour>=1500) && (ithehour<=2355) ){
	mktoday
}

# Warn them about this 5 minute window
if( (ithehour>2355) && (ithehour<=2359) ){
	print("")
	print("WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!")
	print("")
	print("     mktoday has not been run automatically because")
	print("     it is close to midnight. mktoday should have already")
	print("     been run at some point before now. If not quit the")
	print("     datamonitoring software and run it now and")
	print("     before midnight!")
	print("")
	print("WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!")
	print("")
	beep;sleep(1);beep;sleep(1);beep;sleep(1);beep;sleep(1);beep
}

# New mode where we set the data reduction date in this program
if( (ithehour>=1500) && (ithehour<=2359) ){

	# Set the pipeline reduction date to today	
	if(pipemonth<10){
		s_pipemonth="0"//pipemonth
	} else {
		s_pipemonth=pipemonth
	}
	if(pipeday<10){
		s_pipeday="0"//pipeday
	} else {
		s_pipeday=pipeday
	}
	s_pipedate=pipeyear//s_pipemonth//s_pipeday

} else {

	# We should use yesterday's date

	# Special case of first day of month
	if(pipeday==1){
	
		# Need to go back a month and maybe a year
		if(pipemonth==1){
			pipemonth=12
			pipeyear=pipeyear-1
			print("***************")
			print("Happy New Year!")
			print("***************")
			
		} else {
			pipemonth=pipemonth-1
		}
		
		
		# We've now got the right month
		pipeday=daysinmonths[pipemonth]

		# But is it a leap year?
		if(pipemonth==2){
			accurateyear=pipeyear # accurateyear is a real
			accuratediv=accurateyear/4.0
			inaccuratediv=pipeyear/4 # inaccuratediv is an int
			remainder=inaccuratediv-accuratediv
			if(remainder==0.0 ){
				accuratediv2=accurateyear/100.0
				inaccuratediv2=pipeyear/100
				remainder2=inaccuratediv2-accuratediv2
				
				if(remainder2==0){
				# It's not a leap year
					#print("It was almost a leap year!")
				} else {
					#print("It's a leap year!")
					pipeday=pipeday+1
				}

			}
		}

	} else {
	# Just go back a day
		pipeday=pipeday-1
	}

	# Fill in the actual pipedate 
	if(pipemonth<10){
		s_pipemonth="0"//pipemonth
	} else {
		s_pipemonth=pipemonth
	}
	if(pipeday<10){
		s_pipeday="0"//pipeday
	} else {
		s_pipeday=pipeday
	}
	s_pipedate=pipeyear//s_pipemonth//s_pipeday
}

print("Data will be written to directories with this date: ", s_pipedate)

print("Data monitor running and waiting for input file ",
       mdir//froot//"."//fnum)

while(yes){

	filename=mdir//froot//"."//fnum
	exist=access(filename)
	if(exist){
		in=filename
		i=1
		print("Reducing: ",filename)
		while(fscan(in,tempstring)!=EOF){
			if(i==5){
				print("An error has occured while reading")
				print(filename)
				bye
			}
	  		docirppars[i]=tempstring
  			if(tempstring=="stop"){
				idisplay.interactive=idispinter
				idisplay.doohmask=idispmask
				firstfnum=firstfnum+1
				delete(filename)
				print("Stop command received, exiting")
				bye
			}
			#print(docirppars[i])
  		i+=1
	
		}

		# Stop using the date read in from the file here, use the one
		# figured out by the program instead
		docirppars[3]=s_pipedate
		
		# Figure out what data reduction should be done
		# based on the name of the file
		
		# Default reduction
		# Changed at telescope - decided to be mainly doflat
		# Makes some of the logic a little redundant
		dodocirpass=no
		dodotarget=yes
		dodoflat=yes

		if(docirppars[1]=="flat" || 
		   docirppars[1]=="Flat" ||
		   docirppars[1]=="FLAT" ||	
		   docirppars[1]=="dome" ||
		   docirppars[1]=="Dome" ||
	           docirppars[1]=="DOME" ||
		   docirppars[1]=="domeon" ||
                   docirppars[1]=="Domeon" ||
                   docirppars[1]=="DOMEON" || 
 	           docirppars[1]=="domeoff" ||
                   docirppars[1]=="Domeoff" ||
                   docirppars[1]=="DOMEOFF" ||
		   docirppars[1]=="detflat" ||
                   docirppars[1]=="Detflat" ||
                   docirppars[1]=="DETFLAT" ||
		   docirppars[1]=="twilight" ||
		   docirppars[1]=="Twilight" ||
		   docirppars[1]=="TWILIGHT" ||
                   docirppars[1]=="dark" ||
                   docirppars[1]=="Dark" ||
                   docirppars[1]=="DARK" ||
                   docirppars[1]=="metal" ||
                   docirppars[1]=="Metal" ||
                   docirppars[1]=="METAL" ||
		   docirppars[1]=="back" ||
		   docirppars[1]=="Back" ||
		   docirppars[1]=="BACK" ||
		   docirppars[1]=="gcal" ||
		   docirppars[1]=="GCAL" ){
			dodocirpass=no
			dodoflat=yes
			dodotarget=no
		}
 
		if(docirppars[1]=="arc" ||
                   docirppars[1]=="Arc" ||
                   docirppars[1]=="ARC" ||
		   docirppars[1]=="argon" ||
		   docirppars[1]=="Argon" ||
		   docirppars[1]=="ARGON" ||
		   docirppars[1]=="calfib" ||
  		   docirppars[1]=="Calfib" ||
  		   docirppars[1]=="CALFIB" ){
			dodocirpass=yes
			dodoflat=no
			dodotarget=no
		}
		
		# Any other name should be run through the default
		# reduction

		if(dodocirpass){
			docirpass(docirppars[1], docirppars[2], docirppars[3],
		          	  docirppars[4],inter+)
		}

		if(dodoflat){
			doflat(docirppars[1], docirppars[2], docirppars[3],
		               docirppars[4])
		}

		## Sort out the PixCel run numbering scheme
        	## eg run 1 is numbered run 0001
        	## run nos should be 1-9999
        	docirppars[2]="000"//docirppars[2]
        	len=strlen(docirppars[2])
        	beg=len-3
        	docirppars[2]=substr(docirppars[2],beg,len)

		# Add in a header keyword containing
		# the original cirpass file name
		redfile=docirppars[1]//"_"//docirppars[2]//"_raw.fits"
		moreredfile=docirppars[1]//"_"//docirppars[2]//"_ima.fits"

		hedit(redfile,fields="CIRPNAME",value=redfile,add+, update+, 
		      ver-,show-)
		hedit(moreredfile,fields="CIRPNAME",value=redfile,add+, 
		      update+,ver-,show-)
	
		# Sort out the INT_TIME keyword, which pixcel
		# writes incorrectly.
		# Use the samptime parameter from an _ima file
		# which will have been filled in by zsub.
		# No! It'll get deleted if you run cosmic,
		# do it the long way instead

		imgets(redfile//"[0]", "NLOOPS")
		nloops = int(imgets.value)
		nloops = nloops + 1	# As zero based indexing
	
		imgets(redfile//"[sci,1]", "TIME_OBS")
		lasttime = real(imgets.value)
		
		imgets(redfile//"[sci,"//nloops//"]","TIME_OBS")
		firsttime = real(imgets.value)
		
		timeobs = lasttime - firsttime
		# Go from millseconds to seconds
		timeobs = timeobs / 1000.0

		hedit(redfile, fields="INT_TIME", value=timeobs, add-, 
		      update+, ver-, show-)
		hedit(moreredfile, fields="INT_TIME", value=timeobs, add-, 
		      update+, ver-, show-)
	
		if(dodotarget){
			dotarget(moreredfile, extract="sum", writejpeg+, 
			         inter+)
		}
		
		# Do the Gemini backups
		# Figure out the day / month / year for Gemini files
		s_year=substr(docirppars[3],1,4) 
		print(s_year) | scanf("%d",year)
		#print("year is ",year)
		
		s_month=substr(docirppars[3],5,6)
		print(s_month) | scanf("%d",month)
		#print("month is ",months[month])
		
		s_day=substr(docirppars[3],7,8)
		print(s_day) | scanf("%d",day)

		# Gemini days are the end of the night, CIRPASS days
		# are the start of the night

		# So need to add one to the day if it's not 
		# the end of a month
		if(day==daysinmonths[month]){

			if(month==12){ # Is it the end of the year?
				
				year=year+1
				month=1
				day=1
				
			} else if(month==2){ # Is it a leap year?
				
				accurateyear=year # accurateyear is a real
				accuratediv=accurateyear/4.0
				inaccuratediv=year/4 # inaccuratediv is an int
				remainder=inaccuratediv-accuratediv
				
				if(remainder==0.0 ){
				
					accuratediv2=accurateyear/100.0
					inaccuratediv2=year/100
					remainder2=inaccuratediv2-accuratediv2
					
					if(remainder2!=0){
						# It's a leap year
						day=day+1
						#print("It's a leap year!")
					} else {
						# Not a leap year
						month=month+1
						day=1
					}
				
				} else {
						# Not a leap year
						month=month+1
						day=1	
						
				}
			
			} else { # We can just go forward a month

				month=month+1
				day=1

			}

		} else { # Not the end of a month, just go forward a day

			day=day+1

		}

		if(day<10){
			s_day="0"//day
		} else {
			s_day=day
		}

		#print("day is ",s_day)
		
		gemininame=year//months[month]//s_day//"_"//docirppars[2]
		geminilock=gemininame//".unlock"
		gemininame=gemininame//".fits"
		geminidir=year//months[month]//s_day//"/"
		#print("Gemini name is ",gemininame)
		#print("Gemini lock is ",geminilock)
		#print("Gemini dir is ",geminidir)

		if(dothebackup){

			print("Creating ",bdir//geminidir//gemininame)
			print("and ",bdir//geminidir//geminilock)

			# Write a list of the files that we've attempted 
			# to backup to a text file 
			print(redfile," ",gemininame,>>thelogfile)

			# Copy over the files
			gemcp(redfile,bdir//geminidir//gemininame)
			gemtouch(bdir//geminidir//geminilock)
		}

		delete(filename)
		fnum+=1
		firstfnum=fnum

		print("Data monitor running and waiting for input file ",
		      mdir//froot//"."//fnum)

	}

	sleep(5)

}

end





