# autofocus.cl
#
# A. J. Dean 27th July 2002

procedure autofocus(runnumber,focus1,focus2,obsdate)

int runnumber {prompt="run number of 1st observation"}
real focus1 {prompt="Focus position for 1st set of images"}
real focus2 {prompt="Focus position for 2nd set of images"}
int obsdate {prompt="Date of observations"}

struct *in {mode="h"}

begin

int xpick, ypick
int runno
real f1,f2
int date

real xcentre[4]
real ycentre[4]

string image_files[4]
string root_name[4]

string logdata
string tempstr, tempfile1, junk

int i,j,num
real xc,yc
char again = 'r'

real r1,r2

runno=runnumber
f1=focus1
f2=focus2
date=obsdate

root_name[1]="h1f1"
root_name[2]="h2f1"
root_name[3]="h2f2"
root_name[4]="h1f2"

image_files[1]="h1f1_"//runno//"_ima[sci,1].fits"
image_files[2]="h2f1_"//runno+1//"_ima[sci,1].fits"
image_files[3]="h1f2_"//runno+3//"_ima[sci,1].fits"
image_files[4]="h2f2_"//runno+2//"_ima[sci,1].fits"

for(j=1; j<=4; j+=1){
	num=runno+j-1
	docirpass(root_name[j],num,date,2)
}

tempfile1=mktemp("__tempfile__")

for(j=1; j<=4; j+=1){

	display(image_files[j],1, >& "dev$null")

	print ("Press a key on the chosen spot position")

	i = fscan(imcur, xc, yc, again, again)

        	if (frac(xc) < 0.5) xpick = int(xc)
           	else xpick = int(xc) + 1
           	if (frac(yc) < 0.5) ypick = int(yc)
           	else ypick = int(yc) + 1


	logdata=mktemp("__log__")

# ***** x axis

	print(xpick,>tempfile1)
	r1=xpick-10
	r2=xpick+10
	tempstr=r1//" "//r2
 
#	print("position ",xpick," region ",tempstr) 

	fitprofs (image_files[j], lines=ypick, bands="", dispaxis=1, nsum="5", 
		  region=tempstr, positions=tempfile1, background="", 
		  profile="gaussian", gfwhm=2., lfwhm=2., fitbackgroun=yes, 
       	          fitpositions="all", fitgfwhm="all", fitlfwhm="all", 
		  nerrsample=0, sigma0=INDEF, invgain=INDEF, components="", 
	          verbose=no, logfile=logdata, plotfile="", output="", 
	       	  option="fit", clobber=no, merge=no)

	delete(tempfile1)

#pull out the centre positions which is the first column in logfile
#and put into array fibpos
 
	in=logdata
	while(fscan(in,tempstr,junk,junk,junk,junk,junk)!=EOF){
		if(tempstr!="#"){
			xcentre[j]=real(tempstr)
    		}
	}

#	print("j= ",j,"Image ",image_files[j]," xcentre = ",xcentre[j])

	delete(logdata)
	
# ***** y axis

	print(ypick,>tempfile1)
	r1=ypick-10
	r2=ypick+10
	tempstr=r1//" "//r2
 
#	print("position ",ypick," region ",tempstr) 

	fitprofs (image_files[j], lines=xpick, bands="", dispaxis=2, nsum="5", 
		  region=tempstr, positions=tempfile1, background="", 
		  profile="gaussian", gfwhm=2., lfwhm=2., fitbackgroun=yes, 
       	          fitpositions="all", fitgfwhm="all", fitlfwhm="all", 
		  nerrsample=0, sigma0=INDEF, invgain=INDEF, components="", 
	          verbose=no, logfile=logdata, plotfile="", output="", 
	       	  option="fit", clobber=no, merge=no)

	delete(tempfile1)

#pull out the centre positions which is the first column in logfile
#and put into array fibpos
 
	in=logdata
	while(fscan(in,tempstr,junk,junk,junk,junk,junk)!=EOF){
		if(tempstr!="#"){
			ycentre[j]=real(tempstr)
    		}
	}

#	print("j= ",j,"Image ",image_files[j]," ycentre = ",ycentre[j])

	delete(logdata)

	print("xcentre=",xcentre[j]," ycentre=",ycentre[j])
	
}

hartmann(xcentre[1],ycentre[1],xcentre[2],ycentre[2],f1,xcentre[3],
	 ycentre[3],xcentre[4],ycentre[4],f2)

end






