/* specmark_no_wav.c -- marks lines on an uncalibrated spectra 
** read from a linelist
** 
**
** Andrew J. Dean. 17th July, 2001.   
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fitswrap.h"     /* for printerror and cfitsio */
#include "cpgplot.h"      /* for the graphics output */

/* Start of main code */

static float max(float* data, int num);
static float min(float* data, int num);

int main(int argc, char* argv[])
{

  /* Define parameters for fitsio */
  int status=0;                  /* Error handle for cfitsio */
  fitsfile *fptr;                /* fits input object as defined by cfitsio */
 
  int fpixel=1;                  /* First pixel to read */
  int ntoread=0;                   /* Number of pixels to read */     
  int nullvall=0;                /* Markers for bad pixels */
  int anynull=0; 
  float tempx=0;
  float tempy=0;
  float maxval=0;
  float minval=0;

  FILE* linelist;
  
  /* Local variables */
  float* data;                   /* Array for whole image data */
  float* xdata;                  /* X axis of graph */	
  /* double crval=0;
     double cdelt=1; */
  int nx=0;                      /* Dimensions of image */
  int nbytes;                    /* bytes needed for data */
  int i=0;                       /* Loop variables */
  
  char* title=NULL;
  char* outputdevice=NULL;       /* output device */


  /* Check for appropriate input */
  if (argc < 3) {
    fprintf(stderr, 
            "Usage: %s scidata.fits linelist [output.ps]\n", 
            argv[0]);
    exit(1);
  }
  
  if ( argc==4 ){
 
    if ( (outputdevice=(char *)malloc((strlen(argv[5])+4)*sizeof(char))) 
	 == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice,argv[3]);
    strcat(outputdevice,"/PS");

  } else if ( argc == 3 ){
    
    if ( (outputdevice=(char *)malloc(9*sizeof(char))) == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
 
    strcpy(outputdevice, "/xwindow");
   
  }

  /* Open the input file */
  if ( fits_open_file(&fptr, argv[1], READONLY, &status) ){
    printf("\nFailed to open file %s (must include the .fits)\n",argv[1]);
    printerror ( status ) ;
  }

  /* Get the image dimensions */
  if ( fits_read_key(fptr, TINT, "NAXIS1", &nx, NULL, &status) )
      
    printerror ( status ) ; 

  /* and the wavelength scale */
  /*if ( fits_read_key(fptr, TDOUBLE, "CRVAL1", &crval, NULL, &status) )
      
    printerror ( status ) ; 

  if ( fits_read_key(fptr, TDOUBLE, "CDELT1", &cdelt, NULL, &status) )
      
    printerror ( status ) ; 
  */
  /* printf("nx is %i, ny is %i, nloops is %i, nreads is %i \n", nx, ny, 
            nloops, nreads); */
 

  ntoread=nx; /* Number of pixels to read in */  
  nbytes=nx*sizeof(float); /* Memory needed for the data array */

    
  /* Allocate memory */
  if ( (data=(float *)malloc(nbytes)) == NULL ){

   printf("cosmicray: Memory allocation for data failed!");
   exit(1);
  }
  
  if ( (xdata=(float *)malloc(nbytes)) == NULL ){

   printf("cosmicray: Memory allocation for data failed!");
   exit(1);
  }
  
  fpixel=1;
  
  /* Read the data in */
  if ( fits_read_img(fptr, TFLOAT, fpixel, ntoread, &nullvall, 
		     data, &anynull, &status) )
    
    printerror( status );
  
  /* Fill the x array */
  for ( i=0; i<nx; i++ )
    *(xdata+i)=i+1;
    
  maxval=max(data,nx);
  minval=min(data,nx);

  maxval*=1.05;
  minval*=0.95;
 
  /* Open graphics device. */      
  if(cpgbeg(0, outputdevice, 1, 1) != 1)
    return 1; 

  /* Plot the output on screen */
  /* Define coordinate range of graph and draw axes. */
  cpgenv(*(xdata), *(xdata+nx-1), minval, maxval, 0, 0);
      
  /* Label the axes */
  if ( (title=(char *)malloc((strlen(argv[1])+strlen(argv[2])+44)*sizeof(char))) == NULL ){
      
    printf("plot: memory allocation for title failed\n");
    exit(1);
    
  }
  sprintf(title,"%s spectrum with lines marked from linelist %s",argv[1],
	  argv[2]);
  cpglab("Wavelength", "Counts", title);
  
  /*  Plot the line graph. */
  cpgsci(1); /* Blue lines */
  cpgline(nx, xdata, data);
  cpgsci(1); /* White axes */
       
  /* Write in points from the linelist */

  /* Open the linelist */
  if ( !(linelist = fopen(argv[2],"r")) ){
    
    printf("Failed to open the linelist file\n");
    exit(1);
  }
  
  while ( fscanf(linelist,"%f %f",&tempx,&tempy) !=EOF ){
 
    if ( tempx > *(xdata) && tempx <  *(xdata+nx-1) ){

      cpgsci(8); /* set colour */
      cpgsls(2); /* set style */
      cpgmove(tempx,minval);
      cpgdraw(tempx,maxval);

    }

  }
  
  fclose(linelist); 


  /* Close the graphics device */
  cpgend();

 
  /* Free memory allocated locally */
  if ( fits_close_file(fptr, &status) )
    printerror( status );
   
  free (data);
  free (xdata);
  free (title);
  free (outputdevice);

  /* successful return */
  return 0;

}

static float max(float* data,int num)
{

  int i=0;
  float temp=0;

  temp=*(data);

  for (i=0; i<num; i++ )
    
    temp = temp < *(data+i) ? *(data+i) : temp;
      
  return temp;

}

static float min(float* data,int num)
{

  int i=0;
  float temp=0;

  temp=*(data);

  for (i=0; i<num; i++ )
    
    temp = temp > *(data+i) ? *(data+i) : temp;
      
  return temp;

}
