/* object_sort.c 
 *
 * Sorts CIRPASS AAT MOS data taken using the old
 * plug plate system.
 *
 * Finds out the A and B object positions from the fibre
 * configuration files.
 *
 * A. J. Dean 2nd Dec, 2002
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

typedef struct data{

  int fibre;
  int hole;
  int object_id;
  int sorted;     /* Set to 1 once it's position has been found */
  int pos;
  float x;
  float y;
  

}data;

int main(int argc, char* argv[])
{


  data config_info[1000];
  int i=0;
  int num=0;
  int count=0;
  int objectcount=0;
  float offset_x=0;
  float offset_y=0;
  float diffx=0;
  float diffy=0;

  FILE* input_data;
  FILE* outfile;

  /* Check for appropriate input */
  if (argc < 5) {

    fprintf(stderr,
            "Usage: %s input_position_file output_object_file offset_x offset_y\n",
            argv[0]);
    fprintf(stderr,"Expected format of the position file is:\n");
    fprintf(stderr,"Fibre Hole X Y\n");
    exit(1);

  }

  sscanf(argv[3],"%f",&offset_x);
  sscanf(argv[4],"%f",&offset_y);

  /* printf("offsetx is %f, offsety is %f\n",offset_x,offset_y);*/

  /* Read in the data config file */
  if ( !(input_data = fopen(argv[1],"r")) ){

    printf("Failed to open the input data file\n");
    exit(1);
    
  }

  i=0;
   
  while ( fscanf(input_data,"%i %i %f %f",
		 &config_info[i].fibre, &config_info[i].hole,
		 &config_info[i].x, &config_info[i].y) !=EOF ){

  /* printf("%i %i %f %f\n", config_info[i].fibre, config_info[i].hole,
      config_info[i].x, config_info[i].y); */
    i+=1;
    if( i>1000 ){
      printf("Too many data points in file.\nLimit is currently 1000.\n") ;
      exit (1);
    }

  }

  num=i;
  
  fclose(input_data);

  /* Check for even number of points in file, if odd and the
   * unmatched entry is over half way through the file, the code
   * will pair up everything before it, counting to num / 2 (but
   * really one short) and therefore won't even attempt to pair up
   * the unpaired entry - so the user would get no warning of the error
   */

  if( (num - (num/2)*2) != 0 ){
    printf("Odd number of entries in file! One of the entries\n");
    printf("may escape unpaired - check the output file, or you may\n");
    printf("get an error telling you which entry is unpaired\n");
  }

  /* Do the sorting */
 
  count=0;
  objectcount=1;

  config_info[0].object_id=objectcount;
  config_info[0].pos=1;
  config_info[0].sorted=0;
  
  while(objectcount<=(num/2)){

    if( config_info[count].sorted != 1 ){

      for(i=count+1; i<num; i++){

	if( config_info[i].sorted != 1){

	  /*
	  printf("X Doing (%f - %f) - %f = %f\n",config_info[count].x,
		 config_info[i].x,offset_x,
		 (config_info[count].x - config_info[i].x)-offset_x);
	  printf("Y Doing (%f - %f) - %f = %f\n",config_info[count].y,
		 config_info[i].y,offset_y,
		 (config_info[count].y - config_info[i].y)-offset_y);
	  */ 

	  diffx=fabs(config_info[count].x - config_info[i].x - offset_x);
	  diffy=fabs(config_info[count].y - config_info[i].y - offset_y);

	  if( diffx<0.1 && diffy<0.1 ){
	    /*printf("Found a match! Object count is %i\n",objectcount);*/
	    /*printf("Diffx is %f, diffy is %f\n",diffx,diffy);*/
	    config_info[count].object_id=objectcount;
	    config_info[count].pos=1;
 	    config_info[count].sorted=1;
	    config_info[i].object_id=objectcount;
	    config_info[i].pos=2;
	    config_info[i].sorted=1;
	    objectcount+=1;
	    count+=1;
	    break;
	    
	  }
	  
	}
      
	if(i==num-1){ /* Should break in the above if before we reach here */
	
	  printf("Failed to find a match for fibre label %d\n",
		 config_info[count].fibre);
	  exit(1);
	}
      
      }

    } else {

      count++;

    }
	
  }

  /* Write out the info */
  
  /* Open the output file */
  if ( !(outfile = fopen(argv[2],"w")) ){

    printf("Failed to open the output file\n");
    exit(1);
  }


  for(i=0; i<num; i++){

    fprintf(outfile,"%i %i %i %i\n", config_info[i].fibre,
	   config_info[i].hole,
	   config_info[i].object_id,
	   config_info[i].pos);
  }

  fclose(outfile);

  return 0;

}

