/* libaddfibreinfo.c
** 
** Library code version of addfibreinfo.c - adds the CIRPASS ifu / fibre 
** slit configuration to a MEF fits file.
** 
**
** Andrew J. Dean 9th April, 2001
**
*/

#include <stdlib.h>
#include "fitswrap.h"
#include "libaddfibreinfo.h"

extern int addfibreinfo(const char* meffile, const char* configfile)
{
  
  FILE *fp;            /* For config file */
 
  int numdata=0;
  int numhead=0;
  int numcol=0;

  float yoverx=0;
  float maxdist=0;
  float* fibreid=NULL;
  float* xgrid=NULL;
  float* ygrid=NULL;

  char* keywords[]={"YOVERX","MAXDIST"};
  char* colnames[]={"FibreID", "xcord", "ycord"};
  float* data[3];
  float* keydata[2];

  int i=0;

  /* open the input file and read in the files to stack */
  if ( (fp = fopen(configfile,"r")) == NULL ){
    printf("libaddfibreinfo: Cannot open file containing configuration data\n");
    return 1;
  }
  
  
  fscanf(fp,"%d %f %f",&numdata,&yoverx,&maxdist);    
 
  /* Allocate memory for the ifu grid + values*/ 
  if ((fibreid=(float *)malloc(numdata*sizeof(float))) == NULL ||
      (xgrid=(float *)malloc(numdata*sizeof(float))) == NULL ||
      (ygrid=(float *)malloc(numdata*sizeof(float))) == NULL ){
    
    printf("addfibreinfo: memory allocation for grid arrays failed\n");
    exit(1);
    
  }  
 
  for(i=0; i<numdata; i++){
    fscanf(fp,"%f %f %f",fibreid+i,xgrid+i,ygrid+i);
  }

  /* Close the input file containing the file list to be read in */
  fclose(fp); 

  /* Insert into the fits file */

  data[0]=fibreid;
  data[1]=xgrid;
  data[2]=ygrid;

  keydata[0]=&yoverx;
  keydata[1]=&maxdist;

  numcol=3;
  numhead=2;

  if ( append_table(meffile,1, numhead, keywords, keydata, numcol, colnames, 
		    numdata, data) ){
    printf("libaddfibreinfo: append_table failed");
    exit (1);
  }

  /* Clean up */

  free(fibreid);
  free(xgrid);
  free(ygrid);

  return 0;

}


