#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* Global variables */
double sigma=1.5/2.354; /*fwhm/2.354*/
double pitch=2.034;

/*subroutines used in optextract routine*/

#define NBIN 10000
#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

int getgauss(double *gaussval, double _step)
{
  double *gaussval_ptr, term1, term2, term3, pos;

  pos=-5*sigma;
  for(gaussval_ptr=&gaussval[0];gaussval_ptr<&gaussval[NBIN];gaussval_ptr++){
    term1 = 1.0 / (sqrt(2.0*M_PI) * sigma);
    term2 = (0 - pos)/ sigma;
    term3 = -0.5 * pow(term2, 2);
    
    *gaussval_ptr=term1 * pow(M_E, term3)*_step;
    pos+=_step;
  }
  return 0;
}

double gaussint(double *gaussval, double _ilow, double _ihi, double _peakpos, double _step)
{

  int i, tot, nlowbin, nhibin;

  tot=0.0;

  _ilow=_ilow-_peakpos;
  _ihi=_ihi-_peakpos;

  nlowbin=floor(((_ilow+5*sigma)/_step)+0.5);
  nhibin=floor(((_ihi+5*sigma)/_step)+0.5);

  for(i=nlowbin;i<nhibin;i++)
    tot+=gaussval[i];
  
  return tot;
}

int getval1 (char *filename, double *val, int ppsize)
{
  /*read in doubles from file filename */
  /*CHANGE to read from IRAF database file*/

  int i, numval;
  FILE *infile;

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }

  i=0;
  do {
    fscanf(infile,"%lf",val+i);
    i++;
  } while(!feof(infile)&&i<=ppsize);
  numval=i-1;

  return numval;
}

int getphi ( double *peakpos, int numpk, int numval, int type, double **phi)
{

  double pmin, pmax, ilow, ihi, step;
  double *gaussval;
  float pixnum;
  int i,j;

  gaussval=(double*)malloc(NBIN*sizeof(double));

  /*printf("in getphi\n");
    printf("sigma %g NBIN %d\n",sigma,NBIN);*/

  step=(10*sigma)/NBIN;
  /*  printf("step is %g\n",step);*/

  /*populate gaussian array values*/
  /*printf("before getgauss\n");*/
  getgauss(gaussval,step);

  if((type==1)||(type==2)){
    for(j=0;j<numpk;j++){
      pmin=peakpos[j]-5*sigma;
      pmax=peakpos[j]+5*sigma;
      /*printf("type = %d j %d pmin %g pmax %g peak %g\n",type,j,pmin,pmax,peakpos[j]);*/
      
      for(i=0;i<abs(pmin+0.5)-1;i++){
	/*	pixnum=i+1;*/
	/*use i+1 here because these are pixel centres and first pixel is centred at 1*/
	phi[j][i]=0.0;
      }
      for(i=abs(pmin+0.5)-1;i<abs(pmax+0.5);i++){
	pixnum=i+1;
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);
	phi[j][i]=gaussint(gaussval,ilow,ihi,peakpos[j],step);
      }
      for(i=abs(pmax+0.5);i<numval;i++){
	phi[j][i]=0.0;
      }
    }
  }
  else{
    for(j=0;j<numpk;j++){
      if(j<2){
	pmin=peakpos[j]-2*pitch;
	/*printf("%s %d %s %g\n","j",j,"peakpos",peakpos[j]);*/
      }
      else{
	pmin=peakpos[j-2];
      }
      if(j>numpk-3){
	pmax=peakpos[j]+2*pitch;
      }
      else{
	pmax=peakpos[j+2];
      }
      for(i=0;i<abs(pmin+0.5)-1;i++){
	/*	pixnum=i+1;*/
	/*use i+1 here because these are pixel centres and first pixel is centred at 1*/
	phi[j][i]=0.0;
      }
      for(i=abs(pmin+0.5)-1;i<abs(pmax+0.5);i++){
	pixnum=i+1;
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);
	phi[j][i]=gaussint(gaussval,ilow,ihi,peakpos[j],step);
      }
      for(i=abs(pmax+0.5);i<numval;i++){
	phi[j][i]=0.0;
      }
    }
  }

  return 0;
}

int main()
{
  double peakpos[499];
  int numval=2048, numpk, type=2, i;
  double *phi[499];
  char filename[255];

  for(i=0;i<499;i++){
    phi[i]=(double*)malloc(2048*sizeof(double));
  }

  sprintf(filename,"peakpos_all.list");
  numpk = getval1(filename, peakpos, 499);
  
  for(i=0;i<100;i++){
    getphi(peakpos, numpk, numval, type, phi);
  }

  return 0;
}
