/* deadpix.c -- Produces a list of the deadpixels in an image from a flat field
**
** A copy of hotpix.c but the other way around!
** Plus, specify a upper limit too.
**
** Andrew J. Dean. 1st May, 2002
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fitswrap.h"     /* for printerror and cfitsio */

/* Start of main code */

int main(int argc, char* argv[])
{

  /* Local variables */
  
  FILE* outfile;

  float* data;                   /* Array for whole image data */
  long axes[2];                  /* Image dimensions */
  float deadpix_val_top;         /* Pixel values below this are dead pixels */
  float deadpix_val_bot;         /* Pixel values above this are dead pixels */
  int count=0;                   /* Count of number of dead pixels */

  int i=0;                       /* Loop variables */
  int j=0;

  /* Check for appropriate input */
  if (argc < 5) {
    fprintf(stderr, 
            "Usage: %s scidata.fits output_file deadpix_val_top deadpix_val_bottom\n", 
            argv[0]);
    exit(1);
  }
 
  sscanf(argv[3],"%f",&deadpix_val_top);
  sscanf(argv[4],"%f",&deadpix_val_bot);

  /* read in the input data */
  data=readfits_float_clever(argv[1], axes);

  /* Open the output file */
  if ( !(outfile = fopen(argv[2],"w")) ){
    
    printf("Failed to open the output file\n");
    exit(1);
  }

  /* Loop over and flag hot pixels */
  count=0;

  for(j=0; j<axes[1]; j++){

    for(i=0; i<axes[0]; i++){

      if( ( *(data + j*axes[0] + i) < deadpix_val_top ) &&
	  ( *(data + j*axes[0] + i) > deadpix_val_bot ) ){

	fprintf(outfile,"%i %i\n",i+1,j+1);
	count++;

      }

    }

  }

  fclose(outfile); 

  printf("deadpix: Found %d deadpixels\n", count);
  
  /* Free memory allocated locally */
  free (data);
    
  /* successful return */
  return 0;

}






