# usm.cl
#
# Quick script for cleaning up an image
#
# A. J. Dean. 7th April, 2002

procedure usm(f_infile, f_outfile)

string f_infile {prompt="Input MEF file"}
string f_outfile {prompt="Output MEF file"}
#int i_xclean {30, prompt="X median distance"}
#int i_yclean {1, prompt="Y median distance"}
int i_xusm {1, prompt="X usm median distance"}
int i_yusm {30, prompt="Y usm median distance"}

begin

string infile, outfile
int xclean, yclean, xusm, yusm
string temp1, temp2, temp3
int len

infile=f_infile
outfile=f_outfile
#xclean=i_xclean
#yclean=i_yclean
xusm=i_xusm
yusm=i_yusm

len=strlen(infile)
if(substr(infile,len-4,len)!=".fits") {
         infile=infile//".fits"
}

len=strlen(outfile)
if(substr(outfile,len-4,len)!=".fits") {
         outfile=outfile//".fits"
}

temp1=mktemp("_usm1_")
temp2=mktemp("_usm2_")
temp3=mktemp("_usm3_")

temp1=temp1//".fits"
temp2=temp2//".fits"
temp3=temp3//".fits"

#median(infile//"[sci,1]", temp1, xclean, yclean)
imcopy(infile//"[sci,1]", temp1)
median(infile//"[sci,1]", temp2, xusm, yusm)

print("Doing ",temp1," - ",temp2)
imarith(temp1,"-",temp2,temp3)

print("Writing ",outfile," MEF file")
makemef3(infile,temp3,outfile)

imdelete(temp1)
imdelete(temp2)
imdelete(temp3)

end


